/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.xdb.RealInputStream;
import oracle.xdb.XDBError;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBCData;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDOMException;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBDocumentType;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBEntity;
import oracle.xdb.dom.XDBEntityReference;
import oracle.xdb.dom.XDBNamedNodeMap;
import oracle.xdb.dom.XDBNodeList;
import oracle.xdb.dom.XDBNotation;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import oracle.xdb.servlet.XDBStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class XDBNode
implements Node {
    protected XDBDocument m_owner;
    protected long m_xobcstate;
    short m_type;
    protected Connection m_conn;
    boolean m_closed = false;

    private synchronized native long getParentNodeNative(long var1, long var3);

    private synchronized native String toStringNative(long var1, long var3, long var5);

    private synchronized native String getNodeNameNative(long var1, long var3);

    private synchronized native String getNSUriNative(long var1, long var3);

    private synchronized native String getLocalNameNative(long var1, long var3);

    private synchronized native String getNodeValueNative(long var1, long var3);

    private synchronized native void setNodeValueNative(long var1, long var3, String var5);

    private synchronized native String getPrefixNative(long var1, long var3);

    private synchronized native void setPrefixNative(long var1, long var3, String var5);

    private synchronized native long getSchemaNodeNative(long var1, long var3);

    private synchronized native long getOwnerDocNative(long var1, long var3);

    private synchronized native void closeNodeNative(long var1, long var3);

    private synchronized native String getQualifiedNameNative(long var1, long var3);

    private synchronized native String getExpandedNameNative(long var1, long var3);

    private synchronized native long cloneNodeNative(long var1, long var3, boolean var5);

    private synchronized native long getChildNodesNative(long var1, long var3);

    private synchronized native long getFirstChildNative(long var1, long var3);

    private static synchronized native long getChildTypeNative(long var0, long var2);

    private synchronized native long getPreviousSiblingNative(long var1, long var3);

    private synchronized native long getNextSiblingNative(long var1, long var3);

    private synchronized native long getLastChildNative(long var1, long var3);

    private synchronized native long getAttributeMapNative(long var1, long var3);

    private synchronized native boolean hasAttributesNative(long var1, long var3);

    private synchronized native long createSchemaElementNative(long var1, long var3, int var5);

    private synchronized native boolean hasChildNodesNative(long var1, long var3);

    private synchronized native long appendChildNative(long var1, long var3, long var5);

    private synchronized native long replaceChildNative(long var1, long var3, long var5, long var7);

    private synchronized native long removeChildNative(long var1, long var3, long var5);

    private synchronized native long insertBeforeNative(long var1, long var3, long var5, long var7);

    private synchronized native long getInputStreamNative(long var1, long var3, long var5, long var7);

    private synchronized native boolean isSchemaBasedNative(long var1, long var3);

    private synchronized native boolean isNilledNative(long var1, long var3);

    private synchronized native int getPrimitiveTypeNative(long var1, long var3);

    private synchronized native boolean checkNodeValidNative(long var1);

    @Override
    public String getNodeName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getNodeNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    @Override
    public short getNodeType() {
        if (this.isClosed()) {
            return 0;
        }
        return this.m_type;
    }

    @Override
    public String getNodeValue() {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 8 || this.m_type == 3 || this.m_type == 7) {
            return this.getNodeValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 8 || this.m_type == 3 || this.m_type == 7) {
            try {
                this.setNodeValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, value);
            }
            catch (DOMException e) {
                if (e.code == 31195) {
                    throw new DOMException(7, e.getMessage());
                }
                throw e;
            }
        }
    }

    @Override
    public Node getParentNode() {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 9 || this.m_type == 11 || this.m_type == 12 || this.m_type == 6) {
            return null;
        }
        long parentcstate = this.getParentNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (parentcstate != 0L) {
            return new XDBElement(this.m_owner, parentcstate);
        }
        return null;
    }

    public Node getSchemaNode() {
        if (this.isClosed()) {
            return null;
        }
        long schemaNodeCstate = this.getSchemaNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (schemaNodeCstate == 0L) {
            return null;
        }
        long ownerCstate = this.getOwnerDocNative(XDBDocument.getGP(this.m_owner.m_conn), schemaNodeCstate);
        if (ownerCstate == 0L) {
            return null;
        }
        return new XDBElement(new XDBDocument(this.m_owner.m_conn, ownerCstate), schemaNodeCstate);
    }

    @Override
    public NodeList getChildNodes() {
        if (this.isClosed()) {
            return null;
        }
        long listcstate = this.getChildNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return new XDBNodeList(listcstate, this.m_owner);
    }

    @Override
    public String getLocalName() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2 || this.m_type == 1) {
            return this.getLocalNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2) {
            return this.getPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2) {
            this.setPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, prefix);
        }
    }

    @Override
    public String getNamespaceURI() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2 || this.m_type == 1) {
            return this.getNSUriNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        if (this.isClosed()) {
            return null;
        }
        long cstate = this.getPreviousSiblingNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public Node getNextSibling() {
        if (this.isClosed()) {
            return null;
        }
        long cstate = this.getNextSiblingNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public Node getFirstChild() {
        if (this.isClosed()) {
            return null;
        }
        long cstate = this.getFirstChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public Node getLastChild() {
        if (this.isClosed()) {
            return null;
        }
        long cstate = this.getLastChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.isClosed()) {
            return null;
        }
        long mapcstate = this.getAttributeMapNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (mapcstate == 0L) {
            return null;
        }
        return new XDBNamedNodeMap(this.m_owner, mapcstate);
    }

    @Override
    public boolean hasAttributes() {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttributesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    @Override
    public Document getOwnerDocument() {
        return this.m_owner;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long cstate = this.insertBeforeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)newChild).toCState(), ((XDBNode)refChild).toCState());
        ((XDBNode)newChild).setXobCstate(cstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public Node removeChild(Node arg) throws DOMException {
        long cstate;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long parentcstate = this.getParentNodeNative(XDBDocument.getGP(this.m_owner.m_conn), ((XDBNode)arg).toCState());
        if (parentcstate == 0L) {
            throw new DOMException(8, "child node not found");
        }
        try {
            cstate = this.removeChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)arg).toCState());
        }
        catch (DOMException e) {
            if (e.code == 31195) {
                throw new DOMException(7, e.getMessage());
            }
            throw e;
        }
        ((XDBNode)arg).setXobCstate(cstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        long cstate;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        try {
            cstate = this.replaceChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)newChild).toCState(), ((XDBNode)oldChild).toCState());
        }
        catch (DOMException e) {
            if (e.code == 31195) {
                throw new DOMException(7, e.getMessage());
            }
            throw e;
        }
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public Node appendChild(Node arg) throws DOMException {
        long cstate;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (arg.getOwnerDocument() != this.m_owner) {
            throw new DOMException(4, "Invalid node");
        }
        try {
            cstate = this.appendChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)arg).toCState());
        }
        catch (DOMException e) {
            if (e.code == 31195) {
                throw new DOMException(7, e.getMessage());
            }
            throw e;
        }
        ((XDBNode)arg).setXobCstate(cstate);
        return XDBNode.getNodeFromCState(this.m_owner, cstate);
    }

    @Override
    public boolean hasChildNodes() {
        if (this.isClosed()) {
            return false;
        }
        return this.hasChildNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    @Override
    public Node cloneNode(boolean deep) {
        long nodecs = this.cloneNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, deep);
        XDBNode clone = null;
        if (nodecs != 0L) {
            switch (this.m_type) {
                case 2: {
                    clone = new XDBAttribute(this.m_owner, nodecs);
                    break;
                }
                case 4: {
                    clone = new XDBCData(this.m_owner, nodecs);
                    break;
                }
                case 8: {
                    clone = new XDBComment(this.m_owner, nodecs);
                    break;
                }
                case 11: {
                    clone = new XDBDocFragment(this.m_owner, nodecs);
                    break;
                }
                case 9: {
                    clone = new XDBDocument(this.m_conn, nodecs);
                    break;
                }
                case 10: {
                    clone = new XDBDocumentType(this.m_owner, nodecs);
                    break;
                }
                case 1: {
                    clone = new XDBElement(this.m_owner, nodecs);
                    break;
                }
                case 6: {
                    clone = new XDBEntity(this.m_owner, nodecs);
                    break;
                }
                case 5: {
                    clone = new XDBEntityReference(this.m_owner, nodecs);
                    break;
                }
                case 12: {
                    clone = new XDBNotation(this.m_owner, nodecs);
                    break;
                }
                case 7: {
                    clone = new XDBProcInst(this.m_owner, nodecs);
                    break;
                }
                case 3: {
                    clone = new XDBText(this.m_owner, nodecs);
                }
            }
        }
        return clone;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return true;
    }

    public boolean isSchemaBased() {
        if (this.isClosed()) {
            return false;
        }
        return this.isSchemaBasedNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public boolean isNilled() {
        if (this.isClosed()) {
            return false;
        }
        return this.isNilledNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public int getPrimitiveType() {
        if (this.isClosed()) {
            return -1;
        }
        return this.getPrimitiveTypeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public boolean equals(Object obj) {
        if (obj instanceof XDBNode) {
            return this.m_xobcstate == ((XDBNode)obj).m_xobcstate;
        }
        return false;
    }

    public long toCState() {
        return this.m_xobcstate;
    }

    public String toString() {
        if (this.isClosed()) {
            return null;
        }
        try {
            int conntype = XMLType.getConnType(this.m_conn);
            long gpstate = XDBDocument.getGP(this.m_owner.m_conn);
            long serviceHandle = XMLType.getServiceHandle(this.m_conn, conntype);
            return this.toStringNative(gpstate, this.m_xobcstate, serviceHandle);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void write(OutputStream s2, String charEncoding, short indent) throws IOException {
        if (s2 instanceof XDBStream) {
            ((XDBStream)((Object)s2)).writeXMLNative(this.m_xobcstate, charEncoding, indent);
        } else {
            try {
                this.writeToOutputStream(s2);
            }
            catch (SQLException e) {
                throw new IOException();
            }
        }
    }

    XDBNode(XDBDocument owner, long xob, short nodeType) {
        this.m_owner = owner;
        this.m_xobcstate = xob;
        this.m_type = nodeType;
        if (this.m_owner != null) {
            this.m_conn = this.m_owner.m_conn;
        }
        if (!this.checkNodeValidNative(this.m_xobcstate)) {
            this.m_xobcstate = 0L;
        }
    }

    XDBNode(XDBDocument owner, long xob) {
        this.m_owner = owner;
        this.m_xobcstate = xob;
        this.m_type = 0;
        if (this.m_owner != null) {
            this.m_conn = this.m_owner.m_conn;
        }
        if (!this.checkNodeValidNative(this.m_xobcstate)) {
            this.m_xobcstate = 0L;
        }
    }

    private void freeNode() {
        if (this.m_type == 9 || this.m_type == 11) {
            ((XDBDocument)this).close();
        } else {
            if (this.m_closed) {
                return;
            }
            this.closeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
            this.m_closed = true;
        }
    }

    public void close() {
        this.freeNode();
    }

    public void finalize() throws Throwable {
    }

    public String getQualifiedName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getQualifiedNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public String getExpandedName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getExpandedNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    public void setOwner(XDBDocument owner) {
        this.m_owner = owner;
    }

    public void setXobCstate(long xob) {
        this.m_xobcstate = xob;
    }

    protected boolean isClosed() {
        return this.m_closed || this.m_owner.isClosed();
    }

    protected static Node getNodeFromCState(XDBDocument owner, long cstate) {
        XDBNode retval;
        if (cstate == 0L) {
            return null;
        }
        long type = XDBNode.getChildTypeNative(XDBDocument.getGP(owner.m_conn), cstate);
        switch ((int)type) {
            case 1: {
                retval = new XDBElement(owner, cstate);
                break;
            }
            case 2: {
                retval = new XDBAttribute(owner, cstate);
                break;
            }
            case 3: {
                retval = new XDBText(owner, cstate);
                break;
            }
            case 7: {
                retval = new XDBProcInst(owner, cstate);
                break;
            }
            case 8: {
                retval = new XDBComment(owner, cstate);
                break;
            }
            case 6: {
                retval = new XDBEntity(owner, cstate);
                break;
            }
            case 5: {
                retval = new XDBEntityReference(owner, cstate);
                break;
            }
            case 4: {
                retval = new XDBCData(owner, cstate);
                break;
            }
            case 11: {
                retval = new XDBDocFragment(owner, cstate);
                break;
            }
            case 10: {
                retval = new XDBDocumentType(owner, cstate);
                break;
            }
            case 12: {
                retval = new XDBNotation(owner, cstate);
                break;
            }
            default: {
                retval = null;
            }
        }
        return retval;
    }

    public void setNodeXob(int propnum) {
        long xob;
        this.m_xobcstate = xob = this.createSchemaElementNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_owner.m_xobcstate, propnum);
    }

    public int hashCode() {
        return (int)this.m_xobcstate;
    }

    protected static void validateName(String name) throws DOMException {
        if (name == null) {
            return;
        }
        char fc = name.charAt(0);
        if (Character.isLetter(fc) || fc == '_' || fc == ':') {
            int len = name.length();
            for (int i = 1; i < len; ++i) {
                fc = name.charAt(i);
                if (Character.isLetterOrDigit(fc) || fc == '_' || fc == ':' || fc == '-' || fc == '.') continue;
                throw new XDBDOMException(5, "Invalid name: " + name);
            }
        } else {
            throw new XDBDOMException(5, "Invalid name: " + name);
        }
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_closed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        int conntype = XMLType.getConnType(this.m_conn);
        if (conntype == 0) {
            throw new SQLException();
        }
        long gpstate = XDBDocument.getGP(this.m_owner.m_conn);
        long serviceHandle = XMLType.getServiceHandle(this.m_conn, conntype);
        long errorHandle = XMLType.getErrorHandle(this.m_conn, conntype);
        long strm_c_state = this.getInputStreamNative(gpstate, serviceHandle, errorHandle, this.m_xobcstate);
        return new RealInputStream(this.m_conn, strm_c_state, 1);
    }

    public void writeToOutputStream(OutputStream os) throws SQLException {
        if (this.m_closed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        int conntype = XMLType.getConnType(this.m_conn);
        if (conntype == 0) {
            throw new SQLException();
        }
        InputStream is = this.getInputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new SQLException();
        }
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public boolean isSameNode(Node other) {
        return false;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public String getBaseURI() {
        return null;
    }
}

