/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPLocation;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketValue;

class XSLJDWPPacketStream
implements XSLJDWPConstants {
    private int inCursor = 0;
    private XSLJDWPPacket pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();

    XSLJDWPPacketStream(XSLJDWPPacket xSLJDWPPacket) {
        this.pkt = xSLJDWPPacket;
    }

    XSLJDWPPacket packet() {
        return this.pkt;
    }

    void setVMDeath() {
        this.pkt.setVMDeath();
    }

    static boolean isObjectTag(byte by) {
        return by == 76 || by == 91 || by == 115 || by == 116 || by == 103 || by == 108 || by == 99;
    }

    int readArrayID() {
        return this.readObjectID();
    }

    boolean readBoolean() {
        byte by = this.readByte();
        return by != 0;
    }

    byte readByte() {
        byte by = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return by;
    }

    char readChar() {
        int n = this.pkt.data[this.inCursor++] & 0xFF;
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((n << 8) + n2);
    }

    int readClassID() {
        return this.readInt();
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    int readFieldID() {
        return this.readInt();
    }

    int readFrameID() {
        return this.readInt();
    }

    int readInt() {
        int n = this.pkt.data.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.inCursor < n) {
            n2 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        if (this.inCursor < n) {
            n3 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        if (this.inCursor < n) {
            n4 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        if (this.inCursor < n) {
            n5 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    XSLJDWPLocation readLocation() throws XSLJDWPException {
        byte by = this.readByte();
        int n = this.readObjectID();
        int n2 = this.readMethodID();
        long l = this.readLong();
        if (n == 0) {
            return null;
        }
        return new XSLJDWPLocation(by, n, n2, l);
    }

    long readLong() {
        long l = this.pkt.data[this.inCursor++] & 0xFF;
        long l2 = this.pkt.data[this.inCursor++] & 0xFF;
        long l3 = this.pkt.data[this.inCursor++] & 0xFF;
        long l4 = this.pkt.data[this.inCursor++] & 0xFF;
        long l5 = this.pkt.data[this.inCursor++] & 0xFF;
        long l6 = this.pkt.data[this.inCursor++] & 0xFF;
        long l7 = this.pkt.data[this.inCursor++] & 0xFF;
        long l8 = this.pkt.data[this.inCursor++] & 0xFF;
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    int readMethodID() {
        return this.readInt();
    }

    int readObjectID() {
        return this.readInt();
    }

    int readReferenceType() {
        return this.readObjectID();
    }

    short readShort() {
        int n = this.pkt.data[this.inCursor++] & 0xFF;
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((n << 8) + n2);
    }

    String readString() throws XSLJDWPException {
        String string;
        int n = this.readInt();
        try {
            string = new String(this.pkt.data, this.inCursor, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XSLJDWPException(unsupportedEncodingException, 113);
        }
        finally {
            this.inCursor += n;
        }
        return string;
    }

    int readThreadID() {
        return this.readObjectID();
    }

    void close() {
        this.pkt.data = this.dataStream.toByteArray();
    }

    void writeArrayRegion(byte by, XSLJDWPPacketValue[] xSLJDWPPacketValueArray) throws XSLJDWPException {
        this.writeByte(by);
        this.writeInt(xSLJDWPPacketValueArray.length);
        for (int i = 0; i < xSLJDWPPacketValueArray.length; ++i) {
            XSLJDWPPacketValue xSLJDWPPacketValue = xSLJDWPPacketValueArray[i];
            if (XSLJDWPPacketStream.isObjectTag(xSLJDWPPacketValue.getType())) {
                this.writeValue(xSLJDWPPacketValue);
                continue;
            }
            this.writeUntaggedValue(xSLJDWPPacketValue);
        }
    }

    void writeBoolean(boolean bl) {
        if (bl) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte by) {
        this.dataStream.write(by);
    }

    void writeByteArray(byte[] byArray) {
        this.dataStream.write(byArray, 0, byArray.length);
    }

    void writeChar(char c) {
        this.dataStream.write((byte)(c >>> 8 & 0xFF));
        this.dataStream.write((byte)(c & 0xFF));
    }

    void writeClassID(int n) {
        this.writeInt(n);
    }

    void writeClassLoaderID(int n) {
        this.writeObjectID(n);
    }

    void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    void writeFieldID(int n) {
        this.writeInt(n);
    }

    void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    void writeFrameID(int n) {
        this.writeInt(n);
    }

    void writeInt(int n) {
        this.dataStream.write((byte)(n >>> 24 & 0xFF));
        this.dataStream.write((byte)(n >>> 16 & 0xFF));
        this.dataStream.write((byte)(n >>> 8 & 0xFF));
        this.dataStream.write((byte)(n & 0xFF));
    }

    void writeLocation(XSLJDWPLocation xSLJDWPLocation) {
        this.writeByte(xSLJDWPLocation.getType());
        this.writeClassID(xSLJDWPLocation.getClassID());
        this.writeMethodID(xSLJDWPLocation.getMethodID());
        this.writeLong(xSLJDWPLocation.getIndex());
    }

    void writeLong(long l) {
        this.dataStream.write((byte)(l >>> 56 & 0xFFL));
        this.dataStream.write((byte)(l >>> 48 & 0xFFL));
        this.dataStream.write((byte)(l >>> 40 & 0xFFL));
        this.dataStream.write((byte)(l >>> 32 & 0xFFL));
        this.dataStream.write((byte)(l >>> 24 & 0xFFL));
        this.dataStream.write((byte)(l >>> 16 & 0xFFL));
        this.dataStream.write((byte)(l >>> 8 & 0xFFL));
        this.dataStream.write((byte)(l & 0xFFL));
    }

    void writeMethodID(int n) {
        this.writeInt(n);
    }

    void writeNullObjectID() {
        this.writeObjectID(0);
    }

    void writeObjectID(int n) {
        this.writeInt(n);
    }

    void writeStringID(int n) {
        this.writeInt(n);
    }

    void writeReferenceTypeID(int n) {
        this.writeObjectID(n);
    }

    void writeShort(short s2) {
        this.dataStream.write((byte)(s2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(s2 & 0xFF));
    }

    void writeString(String string) throws XSLJDWPException {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeInt(byArray.length);
            this.writeByteArray(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XSLJDWPException(unsupportedEncodingException, 113);
        }
    }

    void writeTaggedObjectID(long l) {
        this.writeLong(l);
    }

    void writeThreadID(int n) {
        this.writeObjectID(n);
    }

    void writeThreadGroupID(int n) {
        this.writeObjectID(n);
    }

    void writeUntaggedValue(XSLJDWPPacketValue xSLJDWPPacketValue) throws XSLJDWPException {
        byte by = xSLJDWPPacketValue.getType();
        Object object = xSLJDWPPacketValue.getValue();
        if (!XSLJDWPPacketStream.isObjectTag(by)) {
            switch (by) {
                case 66: {
                    if (!(object instanceof Byte)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeByte((Byte)object);
                    break;
                }
                case 90: {
                    if (!(object instanceof Boolean)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeBoolean((Boolean)object);
                    break;
                }
                case 67: {
                    if (!(object instanceof Character)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeChar(((Character)object).charValue());
                    break;
                }
                case 70: {
                    if (!(object instanceof Float)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeFloat(((Float)object).floatValue());
                    break;
                }
                case 68: {
                    if (!(object instanceof Double)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeDouble((Double)object);
                    break;
                }
                case 73: {
                    if (!(object instanceof Integer)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeInt((Integer)object);
                    break;
                }
                case 74: {
                    if (!(object instanceof Long)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeLong((Long)object);
                    break;
                }
                case 83: {
                    if (!(object instanceof Short)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeShort((Short)object);
                }
            }
        } else if (object == null) {
            this.writeObjectID(0);
        } else {
            if (!(object instanceof Integer)) {
                throw new XSLJDWPException("Invalid Tag/Type pair", 113);
            }
            this.writeObjectID((Integer)object);
        }
    }

    void writeValue(XSLJDWPPacketValue xSLJDWPPacketValue) throws XSLJDWPException {
        this.writeByte(xSLJDWPPacketValue.getType());
        this.writeUntaggedValue(xSLJDWPPacketValue);
    }
}

