/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import oracle.xml.comp.CXMLReader;
import oracle.xml.comp.CXMLStream;
import oracle.xml.comp.CXMLWriter;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;

public class AttrDecl
extends XMLNode
implements XMLConstants,
Externalizable {
    int atttype;
    int attpres;
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    public static final int ENTITY = 4;
    public static final int ENTITIES = 5;
    public static final int NMTOKEN = 6;
    public static final int NMTOKENS = 7;
    public static final int NOTATION = 8;
    public static final int ENUMERATION = 9;
    public static final int DEFAULT = 0;
    public static final int REQUIRED = 1;
    public static final int IMPLIED = 2;
    public static final int FIXED = 3;
    static final String[] attrDeclTypes = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", "NOTATION", ""};
    static final String[] attrDeclPresence = new String[]{null, "#REQUIRED", "#IMPLIED", "#FIXED"};
    static final int EXTERNAL = 128;
    private static final int ATTRDECL_DTD = 0;
    private static final int ATTRDECL_PARENT = 1;
    private static final int ATTRDECL_QXNAME = 2;
    private static final int ATTRDECL_DEFAULT = 3;
    private static final int ATTRDECL_ENUMVAL = 4;
    private static final int ATTRDECL_DATASZ = 5;

    AttrDecl(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    @Override
    public short getNodeType() {
        return 14;
    }

    @Override
    public String getNodeName() {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetQxName().getQName();
            }
            case 2: {
                return this.xdbGetNodeName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public int getAttrType() {
        return this.atttype;
    }

    public int getAttrPresence() {
        return this.attpres;
    }

    @Override
    public String getDefaultValue() {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetAttrDeclDefault();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public Vector getEnumerationValues() {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetEnumValues();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLStream cXMLStream = new CXMLStream();
        cXMLStream.setObjectOutput(objectOutput);
        CXMLWriter cXMLWriter = (CXMLWriter)cXMLStream.getInfosetWriter();
        cXMLWriter.init();
        this.writeNodeInfo(cXMLWriter, true, false);
        cXMLWriter.close();
        cXMLStream.close();
    }

    @Override
    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl, boolean bl2) {
        if (!(infosetWriter instanceof CXMLWriter)) {
            return;
        }
        try {
            CXMLWriter cXMLWriter = (CXMLWriter)infosetWriter;
            cXMLWriter.writeByte(32);
            cXMLWriter.writeUTF(this.getNodeName());
            cXMLWriter.writeInt(this.atttype);
            cXMLWriter.writeInt(this.attpres);
            cXMLWriter.writeUTF(this.getDefaultValue());
            Vector vector = this.getEnumerationValues();
            if (vector != null) {
                int n = vector.size();
                cXMLWriter.writeShort(n);
                for (int i = 0; i < n; ++i) {
                    cXMLWriter.writeUTF((String)vector.elementAt(i));
                }
            } else {
                cXMLWriter.writeShort(0);
            }
            cXMLWriter.writeBoolean(this.isNodeFlag(128));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        CXMLStream cXMLStream = new CXMLStream();
        cXMLStream.setObjectInput(objectInput);
        CXMLReader cXMLReader = (CXMLReader)cXMLStream.getInfosetReader();
        cXMLReader.init();
        this.readNodeInfo(cXMLReader, true);
    }

    @Override
    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        if (!(infosetReader instanceof CXMLReader)) {
            return;
        }
        try {
            CXMLReader cXMLReader = (CXMLReader)infosetReader;
            byte by = cXMLReader.readByte();
            String string = cXMLReader.readUTF();
            this.xdkSetQxName(QxNameHash.create("", string, "", string));
            this.atttype = cXMLReader.readInt();
            this.attpres = cXMLReader.readInt();
            this.xdkSetAttrDeclDefault(cXMLReader.readUTF());
            int n = cXMLReader.readShort();
            if (n != 0) {
                Vector<String> vector = new Vector<String>(n);
                for (int i = 0; i < n; ++i) {
                    vector.addElement(cXMLReader.readUTF());
                }
                this.xdkSetEnumValue(vector);
            }
            if (cXMLReader.readBoolean()) {
                this.setNodeFlag(128);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DTD xdkGetDTD() {
        return (DTD)this.data[(int)this.nodeId + 0];
    }

    void xdkSetDTD(DTD dTD) {
        this.data[(int)this.nodeId + 0] = dTD;
    }

    @Override
    XMLNode xdkGetParentNode() {
        return (XMLNode)this.data[(int)this.nodeId + 1];
    }

    @Override
    void xdkSetParentNode(XMLNode xMLNode) {
        this.data[(int)this.nodeId + 1] = xMLNode;
    }

    @Override
    QxName xdkGetQxName() {
        return (QxName)this.data[(int)this.nodeId + 2];
    }

    @Override
    void xdkSetQxName(QxName qxName) {
        this.data[(int)this.nodeId + 2] = qxName;
    }

    String xdkGetAttrDeclDefault() {
        return (String)this.data[(int)this.nodeId + 3];
    }

    void xdkSetAttrDeclDefault(String string) {
        this.data[(int)this.nodeId + 3] = string;
    }

    Vector xdkGetEnumValues() {
        return (Vector)this.data[(int)this.nodeId + 4];
    }

    void xdkSetEnumValue(Vector vector) {
        this.data[(int)this.nodeId + 4] = vector;
    }

    @Override
    int xdkGetNodeArraySize() {
        return 5;
    }

    @Override
    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        AttrDecl attrDecl = (AttrDecl)xMLDocument.createNodeFromType((short)14);
        attrDecl.attpres = this.attpres;
        attrDecl.atttype = this.atttype;
        attrDecl.xdkSetDTD(this.xdkGetDTD());
        attrDecl.xdkSetParentNode(null);
        attrDecl.xdkSetQxName(this.xdkGetQxName());
        attrDecl.xdkSetAttrDeclDefault(this.xdkGetAttrDeclDefault());
        attrDecl.xdkSetEnumValue(this.xdkGetEnumValues());
        attrDecl.setNodeFlag(128, this.isNodeFlag(128));
        short s2 = this.getUserDataHandlerOpcode(n);
        this.callUserDataHandlers(s2, attrDecl);
        return attrDecl;
    }

    @Override
    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(128)) {
            xMLOutputStream.writeChars("<!ATTLIST ");
            xMLOutputStream.writeChars(this.getParentNode().getNodeName() + " ");
            xMLOutputStream.writeChars(this.getNodeName() + " ");
            if (this.atttype != 9) {
                xMLOutputStream.writeChars(attrDeclTypes[this.atttype] + " ");
            }
            if (this.atttype == 9 || this.atttype == 8) {
                Vector vector = this.getEnumerationValues();
                int n = vector.size();
                xMLOutputStream.write(40);
                xMLOutputStream.writeChars((String)vector.elementAt(0));
                for (int i = 1; i < n; ++i) {
                    xMLOutputStream.write(124);
                    xMLOutputStream.writeChars((String)vector.elementAt(i));
                }
                xMLOutputStream.write(41);
                xMLOutputStream.write(32);
            }
            if (this.attpres != 0) {
                xMLOutputStream.writeChars(attrDeclPresence[this.attpres]);
                xMLOutputStream.write(32);
            }
            if (this.getDefaultValue() != null) {
                xMLOutputStream.writeQuotedString(this.getDefaultValue());
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
    }

    public AttrDecl() {
    }

    AttrDecl(String string, int n) {
        this.atttype = n;
        this.xdkSetQxName(QxNameHash.create("", string, "", string));
    }
}

