/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.comp.CXMLReader;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;

class LongArrayIndex
extends BinaryIndex {
    long[][] index = new long[64][];
    int[][] children = new int[64][];
    int[] length = new int[64];
    boolean[] child = new boolean[64];
    int depth = 0;
    int level = 0;
    static final int EMPTY_FLAG = Integer.MIN_VALUE;

    LongArrayIndex() {
    }

    @Override
    public final void buildIndex(InfosetReader infosetReader) throws Exception {
        int n = 0;
        ((CXMLReader)infosetReader).init();
        this.index[0] = new long[1];
        this.children[0] = new int[1];
        while (infosetReader.hasNext()) {
            infosetReader.next();
            int n2 = infosetReader.getEventType();
            switch (n2) {
                case 1: {
                    int n3;
                    this.write(infosetReader.offsetToLong(), n);
                    this.child[n] = false;
                    if (n > 0 && !this.child[n - 1]) {
                        n3 = this.length[n];
                        this.writeChild(n3, n - 1);
                        this.child[n - 1] = true;
                    }
                    int n4 = n++;
                    this.length[n4] = this.length[n4] + 1;
                    break;
                }
                case 2: {
                    int n3 = this.length[n] | Integer.MIN_VALUE;
                    if (n3 == 0) {
                        n3 = -1;
                    }
                    if (--n < 0 || this.child[n]) break;
                    this.writeChild(n3, n);
                    this.child[n] = true;
                    break;
                }
            }
        }
        long l = 0L;
        for (int i = 1; i < 64; ++i) {
            Object[] objectArray;
            long[] lArray = this.index[i];
            if (lArray == null) {
                this.depth = i;
                break;
            }
            int n5 = this.length[i];
            l += (long)this.length[i];
            if (lArray.length - n5 > 1024) {
                objectArray = new long[n5];
                System.arraycopy(lArray, 0, objectArray, 0, n5);
                this.index[i] = objectArray;
            }
            if ((objectArray = (Object[])this.children[i]) == null || objectArray.length - n5 <= 1024) continue;
            int[] nArray = new int[n5];
            System.arraycopy(objectArray, 0, nArray, 0, n5);
            this.children[i] = nArray;
        }
    }

    private void write(long l, int n) {
        int n2;
        long[] lArray = this.index[n];
        if (lArray == null) {
            lArray = new long[1024];
            this.index[n] = lArray;
        }
        if ((n2 = this.length[n]) >= lArray.length) {
            long[] lArray2 = lArray;
            lArray = new long[n2 * 2];
            System.arraycopy(lArray2, 0, lArray, 0, lArray2.length);
            this.index[n] = lArray;
        }
        lArray[n2] = l;
    }

    private void writeChild(int n, int n2) {
        int[] nArray = this.children[n2];
        if (nArray == null) {
            nArray = new int[1024];
            this.children[n2] = nArray;
        }
        int n3 = this.length[n2];
        if (--n3 >= nArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n3 * 2];
            System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
            this.children[n2] = nArray;
        }
        nArray[n3] = n;
    }

    @Override
    long getLocator(int n, int n2) {
        return this.index[n][n2];
    }

    @Override
    int getChildStart(int n, int n2) {
        int n3 = this.children[n][n2];
        if (n3 < 0) {
            return -1;
        }
        return n3 & 0xFFFFFFFF;
    }

    @Override
    int getChildEnd(int n, int n2) {
        if (++n2 >= this.length[n]) {
            return this.length[n + 1];
        }
        int n3 = this.children[n][n2] & Integer.MAX_VALUE;
        return n3;
    }

    @Override
    int getIndexDepth() {
        return this.depth;
    }
}

