/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;
    protected int range = -1;

    public void reset() {
        this.clear();
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public T remove() {
        T t2 = this.elementAt(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return t2;
    }

    public void add(T t2) {
        this.data.add(t2);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public int range() {
        return this.range;
    }

    public T head() {
        return this.elementAt(0);
    }

    public T elementAt(int n) {
        int n2 = this.p + n;
        if (n2 >= this.data.size()) {
            throw new NoSuchElementException("queue index " + n2 + " > last index " + (this.data.size() - 1));
        }
        if (n2 < 0) {
            throw new NoSuchElementException("queue index " + n2 + " < 0");
        }
        if (n2 > this.range) {
            this.range = n2;
        }
        return this.data.get(n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.elementAt(i));
            if (i + 1 >= n) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

