/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.xdk;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import oracle.xml.jaxp.JXTransformer;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.platform.xml.xdk.XDKPrintDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XDKTransformer
implements XMLTransformer {
    private String encoding;
    private String version;
    private boolean formattedOutput;
    private boolean fragment;

    public XDKTransformer() {
        this.setEncoding("utf-8");
        this.setVersion("1.0");
        this.setFormattedOutput(true);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    @Override
    public void setFormattedOutput(boolean shouldFormat) {
        this.formattedOutput = shouldFormat;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void transform(Node sourceNode, OutputStream resultOutputStream) throws XMLPlatformException {
        try {
            OutputStreamWriter resultWriter = new OutputStreamWriter(resultOutputStream, this.getEncoding());
            this.transform(sourceNode, resultWriter);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void transform(Node sourceNode, ContentHandler resultContentHandler) throws XMLPlatformException {
        try {
            XMLNode xmlNode = (XMLNode)sourceNode;
            xmlNode.reportSAXEvents(resultContentHandler);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void transform(Node sourceNode, Result result) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        this.transform(source, result);
    }

    @Override
    public void transform(Node sourceNode, Writer resultWriter) throws XMLPlatformException {
        try {
            XMLDocument xmlDocument = sourceNode.getNodeType() == 9 ? (XMLDocument)sourceNode : (XMLDocument)sourceNode.getOwnerDocument();
            if (this.isFragment()) {
                xmlDocument.setEncoding(null);
                xmlDocument.setVersion(null);
            } else {
                xmlDocument.setEncoding(this.getEncoding());
                xmlDocument.setVersion(this.getVersion());
            }
            XMLNode xmlNode = (XMLNode)sourceNode;
            PrintWriter printWriter = new PrintWriter(resultWriter);
            XDKPrintDriver xdkPrintDriver = new XDKPrintDriver(printWriter);
            xdkPrintDriver.setFormattedOutput(this.isFormattedOutput());
            xdkPrintDriver.setEncoding(this.getEncoding());
            xdkPrintDriver.print(xmlNode);
            resultWriter.flush();
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void transform(Source source, Result result) throws XMLPlatformException {
        try {
            JXTransformer transformer = new JXTransformer();
            if (result instanceof StreamResult && this.isFragment()) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (result instanceof SAXResult && !this.isFragment()) {
                ((SAXResult)result).getHandler().startDocument();
            }
            transformer.transform(source, result);
            if (result instanceof SAXResult && !this.isFragment()) {
                ((SAXResult)result).getHandler().endDocument();
            }
        }
        catch (TransformerException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void transform(Document sourceDocument, Node resultParentNode, URL stylesheet) throws XMLPlatformException {
        try {
            XSLProcessor xslProcessor = new XSLProcessor();
            XSLStylesheet xslStylesheet = xslProcessor.newXSLStylesheet(stylesheet);
            XMLDocument xmlDocument = (XMLDocument)sourceDocument;
            XMLDocumentFragment resultDocumentFragment = xslProcessor.processXSL(xslStylesheet, xmlDocument);
            resultParentNode.appendChild(resultDocumentFragment);
        }
        catch (XSLException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    @Override
    public boolean isFragment() {
        return this.fragment;
    }
}

