/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class CurlyFoldParser
implements FoldParser {
    private boolean foldableMultiLineComments;
    private final boolean java;
    private static final char[] KEYWORD_IMPORT = "import".toCharArray();
    protected static final char[] C_MLC_END = "*/".toCharArray();

    public CurlyFoldParser() {
        this(true, false);
    }

    public CurlyFoldParser(boolean cStyleMultiLineComments, boolean java) {
        this.foldableMultiLineComments = cStyleMultiLineComments;
        this.java = java;
    }

    public boolean getFoldableMultiLineComments() {
        return this.foldableMultiLineComments;
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        boolean inMLC = false;
        int mlcStart = 0;
        int importStartLine = -1;
        int lastSeenImportLine = -1;
        int importGroupStartOffs = -1;
        int importGroupEndOffs = -1;
        int lastRightCurlyLine = -1;
        Fold prevFold = null;
        try {
            for (int line = 0; line < lineCount; ++line) {
                for (Token t2 = textArea.getTokenListForLine(line); t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
                    if (this.getFoldableMultiLineComments() && t2.isComment()) {
                        if (this.java && importStartLine > -1) {
                            if (lastSeenImportLine > importStartLine) {
                                Fold fold = null;
                                if (currentFold == null) {
                                    fold = new Fold(2, textArea, importGroupStartOffs);
                                    folds.add(fold);
                                } else {
                                    fold = currentFold.createChild(2, importGroupStartOffs);
                                }
                                fold.setEndOffset(importGroupEndOffs);
                            }
                            importGroupEndOffs = -1;
                            importGroupStartOffs = -1;
                            lastSeenImportLine = -1;
                            importStartLine = -1;
                        }
                        if (inMLC) {
                            if (!t2.endsWith(C_MLC_END)) continue;
                            int mlcEnd = t2.getEndOffset() - 1;
                            if (currentFold == null) {
                                currentFold = new Fold(1, textArea, mlcStart);
                                currentFold.setEndOffset(mlcEnd);
                                folds.add(currentFold);
                                currentFold = null;
                            } else {
                                currentFold = currentFold.createChild(1, mlcStart);
                                currentFold.setEndOffset(mlcEnd);
                                currentFold = currentFold.getParent();
                            }
                            inMLC = false;
                            mlcStart = 0;
                            continue;
                        }
                        if (t2.getType() == 1 || t2.endsWith(C_MLC_END)) continue;
                        inMLC = true;
                        mlcStart = t2.getOffset();
                        continue;
                    }
                    if (this.isLeftCurly(t2)) {
                        if (this.java && importStartLine > -1) {
                            if (lastSeenImportLine > importStartLine) {
                                Fold fold = null;
                                if (currentFold == null) {
                                    fold = new Fold(2, textArea, importGroupStartOffs);
                                    folds.add(fold);
                                } else {
                                    fold = currentFold.createChild(2, importGroupStartOffs);
                                }
                                fold.setEndOffset(importGroupEndOffs);
                            }
                            importGroupEndOffs = -1;
                            importGroupStartOffs = -1;
                            lastSeenImportLine = -1;
                            importStartLine = -1;
                        }
                        if (prevFold != null && line == lastRightCurlyLine) {
                            currentFold = prevFold;
                            prevFold = null;
                            lastRightCurlyLine = -1;
                            continue;
                        }
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t2.getOffset());
                            folds.add(currentFold);
                            continue;
                        }
                        currentFold = currentFold.createChild(0, t2.getOffset());
                        continue;
                    }
                    if (this.isRightCurly(t2)) {
                        if (currentFold == null) continue;
                        currentFold.setEndOffset(t2.getOffset());
                        Fold parentFold = currentFold.getParent();
                        if (currentFold.isOnSingleLine()) {
                            if (!currentFold.removeFromParent()) {
                                folds.remove(folds.size() - 1);
                            }
                        } else {
                            lastRightCurlyLine = line;
                            prevFold = currentFold;
                        }
                        currentFold = parentFold;
                        continue;
                    }
                    if (!this.java) continue;
                    if (t2.is(6, KEYWORD_IMPORT)) {
                        if (importStartLine == -1) {
                            importStartLine = line;
                            importGroupStartOffs = t2.getOffset();
                            importGroupEndOffs = t2.getOffset();
                        }
                        lastSeenImportLine = line;
                        continue;
                    }
                    if (importStartLine <= -1 || !t2.isIdentifier() || !t2.isSingleChar(';')) continue;
                    importGroupEndOffs = t2.getOffset();
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    public boolean isLeftCurly(Token t2) {
        return t2.isLeftCurly();
    }

    public boolean isRightCurly(Token t2) {
        return t2.isRightCurly();
    }

    public void setFoldableMultiLineComments(boolean foldable) {
        this.foldableMultiLineComments = foldable;
    }
}

