/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.spi.CustomInstanceFactory;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class RecognizeInstanceFiles
extends NamedServicesProvider {
    private static final Logger LOG = Logger.getLogger(RecognizeInstanceFiles.class.getName());
    private static volatile Lookup.Result<CustomInstanceFactory> factories;

    @Override
    public Lookup create(String path) {
        return new OverFiles(path);
    }

    @Override
    public <T> T lookupObject(String path, Class<T> type) {
        FileObject fo = FileUtil.getConfigFile(path);
        if (fo != null && fo.isData()) {
            return FOItem.createInstanceFor(fo, type);
        }
        return null;
    }

    private static Collection<? extends CustomInstanceFactory> getInstanceFactories() {
        Lookup.Result<CustomInstanceFactory> fr = factories;
        if (fr == null) {
            factories = fr = Lookup.getDefault().lookupResult(CustomInstanceFactory.class);
        }
        return fr.allInstances();
    }

    public static final <T> T createInstance(Class<T> type) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        CustomInstanceFactory fif;
        T r = null;
        Iterator<? extends CustomInstanceFactory> iterator = RecognizeInstanceFiles.getInstanceFactories().iterator();
        while (iterator.hasNext() && (r = (T)(fif = iterator.next()).createInstance(type)) == null) {
        }
        if (r == null) {
            Constructor<T> init = type.getDeclaredConstructor(new Class[0]);
            init.setAccessible(true);
            r = init.newInstance(new Object[0]);
        }
        return r;
    }

    private static final class FOItem
    extends AbstractLookup.Pair<Object> {
        private static Reference<Object> EMPTY = new WeakReference<Object>(null);
        private FileObject fo;
        private Reference<Object> ref = EMPTY;

        public FOItem(FileObject fo) {
            this.fo = fo;
        }

        @Override
        protected boolean instanceOf(Class<?> c) {
            Object r = this.ref.get();
            if (r != null) {
                return c.isInstance(r);
            }
            String instanceOf = (String)this.fo.getAttribute("instanceOf");
            if (instanceOf != null) {
                for (String xface : instanceOf.split(",")) {
                    try {
                        if (!c.isAssignableFrom(Class.forName(xface, false, FOItem.loader()))) continue;
                        return true;
                    }
                    catch (ClassNotFoundException x) {
                        LOG.log(Level.FINE, "could not load " + xface + " for " + this.fo.getPath(), x);
                    }
                }
                return false;
            }
            return c.isAssignableFrom(this.getType());
        }

        @Override
        protected boolean creatorOf(Object obj) {
            return this.ref.get() == obj;
        }

        @Override
        public synchronized Object getInstance() {
            Object r = this.ref.get();
            if (r == null) {
                r = FOItem.createInstanceFor(this.fo, Object.class);
                Object o = this.ref.get();
                if (o != null) {
                    return o;
                }
                if (r != null) {
                    this.ref = new WeakReference<Object>(r);
                }
            }
            return r;
        }

        static <T> T createInstanceFor(FileObject f, Class<T> resultType) {
            Object r = f.getAttribute("instanceCreate");
            if (r == null) {
                try {
                    Class<? extends Object> type = FOItem.findTypeFor(f);
                    if (type == null) {
                        return null;
                    }
                    r = RecognizeInstanceFiles.createInstance(type);
                }
                catch (InstantiationException ex) {
                    Exceptions.printStackTrace(ex);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace(ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace(ex);
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            return resultType.isInstance(r) ? (T)resultType.cast(r) : null;
        }

        @Override
        public Class<? extends Object> getType() {
            Class<? extends Object> type = FOItem.findTypeFor(this.fo);
            return type != null ? type : Void.class;
        }

        private static Class<? extends Object> findTypeFor(FileObject f) {
            String clazz = FOItem.getClassName(f);
            if (clazz == null) {
                return null;
            }
            try {
                return Class.forName(clazz, false, FOItem.loader());
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
                return null;
            }
        }

        @Override
        public String getId() {
            String s2 = this.fo.getPath();
            if (s2.endsWith(".instance")) {
                s2 = s2.substring(0, s2.length() - ".instance".length());
            }
            return s2;
        }

        @Override
        public String getDisplayName() {
            String n = this.fo.getName();
            try {
                n = this.fo.getFileSystem().getDecorator().annotateName(n, Collections.singleton(this.fo));
            }
            catch (FileStateInvalidException ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
            }
            return n;
        }

        private static String getClassName(FileObject fo) {
            int last;
            Object attr = fo.getAttribute("instanceClass");
            if (attr instanceof String) {
                return BaseUtilities.translate((String)attr);
            }
            if (attr != null) {
                LOG.warning("instanceClass was a " + attr.getClass().getName());
            }
            if ((attr = fo.getAttribute("instanceCreate")) != null) {
                return attr.getClass().getName();
            }
            Enumeration<String> attributes = fo.getAttributes();
            while (attributes.hasMoreElements()) {
                if (!attributes.nextElement().equals("instanceCreate")) continue;
                return null;
            }
            String name = fo.getName();
            int first = name.indexOf(91) + 1;
            if (first != 0) {
                LOG.log(Level.WARNING, "Cannot understand {0}", fo);
            }
            if ((last = name.indexOf(93)) < 0) {
                last = name.length();
            }
            if (first < last) {
                name = name.substring(first, last);
            }
            name = name.replace('-', '.');
            name = BaseUtilities.translate(name);
            return name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FOItem other = (FOItem)obj;
            return this.fo == other.fo || this.fo != null && this.fo.equals(other.fo);
        }

        public int hashCode() {
            int hash = 3;
            hash = 11 * hash + (this.fo != null ? this.fo.hashCode() : 0);
            return hash;
        }

        private static ClassLoader loader() {
            ClassLoader l = Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = FOItem.class.getClassLoader();
            }
            return l;
        }
    }

    private static final class OverFiles
    extends ProxyLookup
    implements FileChangeListener {
        private final String path;
        private final FileChangeListener weakL;
        private final AbstractLookup.Content content;
        private final AbstractLookup lkp;

        public OverFiles(String path) {
            this(path, new ArrayList<FOItem>(), new AbstractLookup.Content());
        }

        private OverFiles(String path, List<FOItem> items, AbstractLookup.Content cnt) {
            this(path, items, new AbstractLookup(cnt), cnt);
        }

        private OverFiles(String path, List<FOItem> items, AbstractLookup lkp, AbstractLookup.Content cnt) {
            super(OverFiles.computeDelegates(path, items, lkp));
            this.path = path;
            this.lkp = lkp;
            this.content = cnt;
            this.content.setPairs(OverFiles.order(items));
            FileSystem fs = null;
            try {
                fs = FileUtil.getSystemConfigRoot().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace(ex);
            }
            this.weakL = FileUtil.weakFileChangeListener(this, fs);
            fs.addFileChangeListener(this.weakL);
        }

        private static List<FOItem> order(List<FOItem> items) {
            LinkedHashMap<FileObject, FOItem> m4 = new LinkedHashMap<FileObject, FOItem>();
            for (FOItem item : items) {
                m4.put(item.fo, item);
            }
            List<FileObject> files = FileUtil.getOrder(m4.keySet(), true);
            ArrayList<FOItem> r = new ArrayList<FOItem>(files.size());
            for (FileObject f : files) {
                r.add((FOItem)m4.get(f));
            }
            return r;
        }

        private void refresh(FileEvent ev) {
            if (!(ev.getFile().getPath() + "/").startsWith(this.path)) {
                return;
            }
            ArrayList<FOItem> items = new ArrayList<FOItem>();
            Lookup[] delegates = OverFiles.computeDelegates(this.path, items, this.lkp);
            this.content.setPairs(OverFiles.order(items));
            this.setLookups(delegates);
        }

        private static Lookup[] computeDelegates(String p, List<FOItem> items, Lookup lkp) {
            ClassLoader l;
            FileObject fo = FileUtil.getConfigFile(p);
            LinkedList<Lookup> delegates = new LinkedList<Lookup>();
            delegates.add(lkp);
            if (fo != null) {
                for (FileObject f : fo.getChildren()) {
                    Object real;
                    if (f.isFolder()) {
                        delegates.add(new OverFiles(f.getPath()));
                        continue;
                    }
                    if (f.hasExt("shadow") && (real = f.getAttribute("originalFile")) instanceof String) {
                        f = FileUtil.getConfigFile((String)real);
                    }
                    if (!f.hasExt("instance") && f.getAttribute("instanceCreate") == null) continue;
                    items.add(new FOItem(f));
                }
            }
            if ((l = Lookup.getDefault().lookup(ClassLoader.class)) == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == null) {
                l = RecognizeInstanceFiles.class.getClassLoader();
            }
            delegates.add(Lookups.metaInfServices(l, "META-INF/namedservices/" + p));
            return delegates.toArray(new Lookup[0]);
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            this.refresh(fe);
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            this.refresh(fe);
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.refresh(fe);
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.refresh(fe);
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.refresh(fe);
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.refresh(fe);
        }
    }
}

