/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.export;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.netbeans.api.visual.export.SceneExporter;
import org.netbeans.api.visual.export.WidgetPolygonalCoordinates;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class Scene2Image {
    private final File file;
    private final Scene scene;
    private Set<?> selectedObjects;
    private int imageHeight;
    private int imageWidth;
    private double scale;

    public Scene2Image(Scene scene, File file) {
        this.scene = scene;
        this.file = file;
    }

    public ArrayList<WidgetPolygonalCoordinates> getSceneImageMapCoordinates(int margin) {
        ArrayList<WidgetPolygonalCoordinates> list = new ArrayList<WidgetPolygonalCoordinates>();
        List<Widget> layers = this.scene.getChildren();
        boolean oneLayer = false;
        for (Widget layer : layers) {
            if (oneLayer) break;
            List<Widget> widgets = layer.getChildren();
            if (this.selectedObjects != null) {
                ObjectScene oScene = (ObjectScene)this.scene;
                widgets.clear();
                for (Object o : this.selectedObjects) {
                    widgets.add(oScene.findWidget(o));
                }
                oneLayer = true;
            }
            for (Widget w : widgets) {
                Polygon polygon = new Polygon();
                if (w instanceof ConnectionWidget) {
                    int sign;
                    int yMargin;
                    int xMargin;
                    int y;
                    int x;
                    int i;
                    List<Point> controlPoints = ((ConnectionWidget)w).getControlPoints();
                    int numPoints = controlPoints.size();
                    if (numPoints == 0) continue;
                    Point start = controlPoints.get(0);
                    Point finish = controlPoints.get(controlPoints.size() - 1);
                    Point currentPoint = start;
                    int rise = 1;
                    int run = 1;
                    for (i = 0; i < numPoints; ++i) {
                        Point nextPoint = null;
                        if (i + 1 < numPoints) {
                            nextPoint = controlPoints.get(i + 1);
                            rise = currentPoint.y - nextPoint.y;
                            run = currentPoint.x - nextPoint.x;
                        }
                        x = currentPoint.x;
                        y = currentPoint.y;
                        xMargin = 0;
                        yMargin = 0;
                        if (rise == 0) {
                            yMargin = margin;
                        } else if (run == 0) {
                            xMargin = margin;
                        } else {
                            sign = rise * run / Math.abs(rise * run);
                            xMargin = sign * margin;
                            yMargin = margin;
                        }
                        polygon.addPoint((int)((double)x * this.scale + (double)xMargin), (int)((double)y * this.scale + (double)yMargin));
                        currentPoint = nextPoint;
                    }
                    currentPoint = finish;
                    for (i = numPoints - 1; i >= 0; --i) {
                        Point prevPoint = null;
                        if (i - 1 >= 0) {
                            prevPoint = controlPoints.get(i - 1);
                            rise = currentPoint.y - prevPoint.y;
                            run = currentPoint.x - prevPoint.x;
                        }
                        x = currentPoint.x;
                        y = currentPoint.y;
                        xMargin = 0;
                        yMargin = 0;
                        if (rise == 0) {
                            yMargin = -margin;
                        } else if (run == 0) {
                            xMargin = -margin;
                        } else {
                            sign = rise * run / Math.abs(rise * run);
                            xMargin = sign * margin;
                            yMargin = -margin;
                        }
                        polygon.addPoint((int)((double)x * this.scale + (double)xMargin), (int)((double)y * this.scale + (double)yMargin));
                        currentPoint = prevPoint;
                    }
                } else {
                    Point p0 = w.getLocation();
                    Rectangle r = w.getPreferredBounds();
                    int width = (int)((double)r.width * this.scale);
                    int height = (int)((double)r.height * this.scale);
                    int x = (int)((double)p0.x * this.scale);
                    int y = (int)((double)p0.y * this.scale);
                    polygon.addPoint(x - 1, y - 1);
                    polygon.addPoint(x + width + 1, y - 1);
                    polygon.addPoint(x + width + 1, y + height + 1);
                    polygon.addPoint(x - 1, y + height + 1);
                }
                list.add(new WidgetPolygonalCoordinates(w, polygon));
            }
        }
        return list;
    }

    public BufferedImage createImage(SceneExporter.ImageType imageType, SceneExporter.ZoomType zoomType, boolean visibleAreaOnly, boolean selectedOnly, int quality, int width, int height, boolean createImageMap) throws IOException {
        double _scale = this.scene.getZoomFactor();
        Rectangle sceneRec = this.scene.getPreferredBounds();
        Rectangle viewRect = this.scene.getView() != null ? this.scene.getView().getVisibleRect() : sceneRec;
        ArrayList<Widget> hiddenWidgets = new ArrayList<Widget>();
        int _imageWidth = sceneRec.width;
        int _imageHeight = sceneRec.height;
        Set<?> _selectedObjects = null;
        if (selectedOnly && this.scene instanceof ObjectScene) {
            ObjectScene gScene = (ObjectScene)this.scene;
            HashSet invisible = new HashSet();
            invisible.addAll(gScene.getObjects());
            _selectedObjects = gScene.getSelectedObjects();
            invisible.removeAll(_selectedObjects);
            for (Object o : invisible) {
                Widget widget = gScene.findWidget(o);
                if (widget == null || !widget.isVisible()) continue;
                widget.setVisible(false);
                hiddenWidgets.add(widget);
            }
        }
        if (visibleAreaOnly) {
            _imageWidth = viewRect.width;
            _imageHeight = viewRect.height;
        } else {
            switch (zoomType) {
                case CUSTOM_SIZE: {
                    _imageWidth = width;
                    _imageHeight = height;
                    _scale = Math.min((double)width / (double)sceneRec.width, (double)height / (double)sceneRec.height);
                    break;
                }
                case FIT_IN_WINDOW: {
                    _scale = Math.min((double)viewRect.width / (double)sceneRec.width, (double)viewRect.height / (double)sceneRec.height);
                    _imageWidth = (int)((double)sceneRec.width * _scale);
                    _imageHeight = (int)((double)sceneRec.height * _scale);
                    break;
                }
                case CURRENT_ZOOM_LEVEL: {
                    _imageWidth = (int)((double)sceneRec.width * this.scene.getZoomFactor());
                    _imageHeight = (int)((double)sceneRec.height * this.scene.getZoomFactor());
                    break;
                }
                case ACTUAL_SIZE: {
                    _imageWidth = sceneRec.width;
                    _imageHeight = sceneRec.height;
                    _scale = 1.0;
                }
            }
        }
        if (createImageMap) {
            this.selectedObjects = _selectedObjects;
            this.imageHeight = _imageHeight;
            this.imageWidth = _imageWidth;
            this.scale = _scale;
        }
        BufferedImage bufferedImage = new BufferedImage(_imageWidth, _imageHeight, 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.translate(0, 0);
        g2.scale(_scale, _scale);
        this.scene.paint(g2);
        for (Widget w : hiddenWidgets) {
            w.setVisible(true);
        }
        if (this.file != null) {
            FileImageOutputStream fo = new FileImageOutputStream(this.file);
            if (imageType == SceneExporter.ImageType.JPG) {
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                ImageWriter writer = iter.next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                if (quality > 100) {
                    quality = 100;
                }
                if (quality < 0) {
                    quality = 0;
                }
                iwp.setCompressionQuality(quality / 100);
                writer.setOutput(fo);
                IIOImage image = new IIOImage(bufferedImage, null, null);
                writer.write(null, image, iwp);
                writer.dispose();
            } else {
                ImageIO.write((RenderedImage)bufferedImage, "" + (Object)((Object)imageType), fo);
            }
            try {
                fo.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedImage;
    }
}

