/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class FlowNetwork<N, E> {
    private EmbeddedPlanarGraph<N, E> originalGraph;
    private Map<MGraph.Vertex<N>, Node<N>> vertexNodeMap;
    private Map<Face, Node<N>> faceNodeMap;
    public Collection<Node<N>> nodes;
    public Collection<Arc<N>> arcs;
    public Node<N> source;
    public Node<N> sink;

    public static <N, E> FlowNetwork<N, E> createGraph(EmbeddedPlanarGraph<N, E> graph) {
        FlowNetwork<N, E> network = new FlowNetwork<N, E>(graph);
        super.createGraph();
        return network;
    }

    private FlowNetwork(EmbeddedPlanarGraph<N, E> graph) {
        this.originalGraph = graph;
        this.vertexNodeMap = new HashMap<MGraph.Vertex<N>, Node<N>>();
        this.faceNodeMap = new HashMap<Face, Node<N>>();
        this.nodes = new ArrayList<Node<N>>();
        this.arcs = new ArrayList<Arc<N>>();
    }

    private void createGraph() {
        Collection<MGraph.Vertex<N>> vertices = this.originalGraph.getOriginalGraph().getVertices();
        ArrayList<Face> faces = this.originalGraph.getFaces();
        for (MGraph.Vertex<N> v : vertices) {
            Node<N> vn = this.getNode(v);
            for (Face f : faces) {
                if (!f.containsVertex(v)) continue;
                Node<N> fn = this.getNode(f);
                List<Face.Dart> darts = f.getDartsFrom(v);
                for (Face.Dart d : darts) {
                    this.addArc(vn, fn, d);
                }
            }
        }
        for (Face f : faces) {
            Node<N> fn = this.getNode(f);
            for (Face.Dart d : f.getDarts()) {
                Face nf = this.originalGraph.getOppositeFace(f, d);
                Node<N> nfn = this.getNode(nf);
                this.addArc(fn, nfn, d);
            }
        }
        this.source = new Node();
        ((Node)this.source).isSource = true;
        this.sink = new Node();
        ((Node)this.sink).isSink = true;
        int sourceProduction = 0;
        int sinkProduction = 0;
        for (Node<N> n : this.getNodes()) {
            Arc<N> arc;
            if (((Node)n).production > 0) {
                arc = this.addArc(this.source, n);
                ((Arc)arc).capacity = ((Node)n).production;
                ((Arc)arc).cost = 0;
                sourceProduction += ((Node)n).production;
                continue;
            }
            if (((Node)n).production >= 0) continue;
            arc = this.addArc(n, this.sink);
            ((Arc)arc).capacity = -((Node)n).production;
            ((Arc)arc).cost = 0;
            sinkProduction += ((Node)n).production;
        }
        ((Node)this.source).production = sourceProduction;
        ((Node)this.sink).production = sinkProduction;
    }

    public EmbeddedPlanarGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public Node<N> getNode(MGraph.Vertex<N> vertex) {
        Node<N> node = this.vertexNodeMap.get(vertex);
        if (node == null) {
            node = new Node<N>(vertex);
            this.vertexNodeMap.put(vertex, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node<N> getNode(Face face) {
        Node<N> node = this.faceNodeMap.get(face);
        if (node == null) {
            node = new Node(face);
            this.faceNodeMap.put(face, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node<N> getSource() {
        return this.source;
    }

    public Node<N> getSink() {
        return this.sink;
    }

    public Arc<N> addArc(Node<N> sourceNode, Node<N> destNode, Face.Dart dart) {
        Arc<N> arc = new Arc<N>(sourceNode, destNode, dart);
        this.arcs.add(arc);
        return arc;
    }

    public Arc<N> addArc(Node<N> sourceNode, Node<N> destNode) {
        return this.addArc(sourceNode, destNode, null);
    }

    public void removeArc(Arc<N> arc) {
        this.arcs.remove(arc);
        Node<N> node = arc.getSourceNode();
        if (node != null) {
            node.removeOutputArc(arc);
        }
        if ((node = arc.getDestinationNode()) != null) {
            node.removeInputArc(arc);
        }
    }

    public Collection<Node<N>> getNodes() {
        return this.nodes;
    }

    public Collection<Arc<N>> getArcs() {
        return this.arcs;
    }

    public void removeSourceAndSink() {
        this.nodes.remove(this.source);
        this.nodes.remove(this.sink);
        ArrayList<Arc<N>> _arcs = new ArrayList<Arc<N>>(this.source.getOutputArcs());
        for (Arc arc : _arcs) {
            this.removeArc(arc);
        }
        _arcs = new ArrayList<Arc<N>>(this.sink.getInputArcs());
        for (Arc arc : _arcs) {
            this.removeArc(arc);
        }
    }

    public String toString() {
        String s2 = "Flow Network\n";
        s2 = s2 + "Source:\n" + this.source + "\n";
        s2 = s2 + "Sink:\n" + this.sink + "\n";
        s2 = s2 + "Nodes:\n";
        for (Node<N> n : this.nodes) {
            s2 = s2 + n + "\n";
        }
        return s2;
    }

    public static class ResidualArc<N>
    extends Arc<N> {
        private boolean isReverse;
        private Arc<N> arc;

        public ResidualArc(Node<N> sourceNode, Node<N> destNode, Arc<N> arc, boolean isReverse) {
            super(sourceNode, destNode, null);
            this.isReverse = isReverse;
            this.arc = arc;
            if (!isReverse) {
                this.setCapacity(arc.getCapacity() - arc.getFlow());
            } else {
                this.setCapacity(arc.getFlow());
            }
            this.setCost(arc.getCost());
        }

        public boolean isReverse() {
            return this.isReverse;
        }

        public Arc<N> getArc() {
            return this.arc;
        }

        @Override
        public String toString() {
            String s2 = "ResidualArc:\n";
            s2 = s2 + "isReverse = " + this.isReverse + "\n";
            s2 = s2 + "capacity = " + this.getCapacity() + "\n";
            s2 = s2 + "cost = " + this.getCost() + "\n";
            s2 = s2 + "flow = " + this.getFlow() + "\n";
            return s2;
        }
    }

    public static class ResidualFlowNetwork<N, E>
    extends FlowNetwork<N, E> {
        private Map<Arc<N>, ResidualArc<N>> arcToResidualArcMap;
        private Map<Arc<N>, ResidualArc<N>> arcToReverseResidualArcMap;
        private FlowNetwork<N, E> network;
        private Map<Node<N>, Node<N>> nodeMap;

        public ResidualFlowNetwork(FlowNetwork<N, E> network) {
            super(null);
            this.network = network;
            this.nodeMap = new HashMap<Node<N>, Node<N>>();
            this.arcToResidualArcMap = new HashMap<Arc<N>, ResidualArc<N>>();
            this.arcToReverseResidualArcMap = new HashMap<Arc<N>, ResidualArc<N>>();
            this.source = this.getNode(network.getSource());
            this.source.isSource = true;
            this.sink = this.getNode(network.getSink());
            this.sink.isSink = true;
            for (Arc<N> arc : network.getArcs()) {
                this.addResidualArc(arc);
            }
        }

        private void addResidualArc(Arc<N> arc) {
            Node<N> sourceNode = this.getNode(arc.getSourceNode());
            Node<N> destNode = this.getNode(arc.getDestinationNode());
            ResidualArc<N> residualArc = new ResidualArc<N>(sourceNode, destNode, arc, false);
            this.arcToResidualArcMap.put(arc, residualArc);
            ResidualArc<N> reverseResidualArc = new ResidualArc<N>(destNode, sourceNode, arc, true);
            this.arcToReverseResidualArcMap.put(arc, reverseResidualArc);
        }

        public ResidualArc<N> getResidualArcFromArc(Arc<N> arc) {
            return this.arcToResidualArcMap.get(arc);
        }

        public ResidualArc<N> getReverseResidualArcFromArc(Arc<N> arc) {
            return this.arcToReverseResidualArcMap.get(arc);
        }

        @Override
        private Node<N> getNode(Node<N> node) {
            Node<N> residualNode = this.nodeMap.get(node);
            if (residualNode == null) {
                if (node.isVertexNode()) {
                    residualNode = ((FlowNetwork)this).getNode(node.getVertex());
                } else if (node.isFaceNode()) {
                    residualNode = this.getNode(node.getFace());
                } else {
                    residualNode = new Node();
                    residualNode.setProduction(node.getProduction());
                    this.nodes.add(residualNode);
                }
                this.nodeMap.put(node, residualNode);
            }
            return residualNode;
        }
    }

    public static class Arc<N> {
        private Node<N> sourceNode;
        private Node<N> destinationNode;
        private int capacity;
        private int cost;
        private int flow;
        private int lowerBound;
        private Face.Dart dart;

        public Arc(Node<N> source, Node<N> destination, Face.Dart dart) {
            this.sourceNode = source;
            this.destinationNode = destination;
            this.dart = dart;
            this.flow = 0;
            if (this.sourceNode.isVertexNode() || destination.isVertexNode()) {
                this.lowerBound = 0;
                this.capacity = 3;
                this.cost = 0;
            } else if (this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode()) {
                this.lowerBound = 0;
                this.capacity = Integer.MAX_VALUE;
                this.cost = 1;
            }
            this.sourceNode.addOutputArc(this);
            this.destinationNode.addInputArc(this);
        }

        public Node<N> getSourceNode() {
            return this.sourceNode;
        }

        public Node<N> getDestinationNode() {
            return this.destinationNode;
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public int getCost() {
            return this.cost;
        }

        public void setCost(int cost) {
            this.cost = cost;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public void setFlow(int flow) {
            this.flow = flow;
        }

        public int getFlow() {
            return this.flow;
        }

        public void addFlow(int delta) {
            this.flow += delta;
        }

        public void substractCapacity(int delta) {
            this.capacity -= delta;
        }

        public void addCapacity(int delta) {
            this.capacity += delta;
        }

        public boolean isVertexArc() {
            return this.sourceNode.isVertexNode();
        }

        public boolean isFaceArc() {
            return this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode();
        }

        public String toString() {
            String s2 = "Arc:\n";
            s2 = s2 + "capacity = " + this.capacity + "\n";
            s2 = s2 + "cost = " + this.cost + "\n";
            s2 = s2 + "flow = " + this.flow + "\n";
            s2 = s2 + "lowerBound = " + this.lowerBound + "\n";
            return s2;
        }
    }

    public static class Node<N> {
        private Face face;
        private MGraph.Vertex<N> vertex;
        private Collection<Arc<N>> inputArcs = new ArrayList<Arc<N>>();
        private Collection<Arc<N>> outputArcs = new ArrayList<Arc<N>>();
        private int production;
        private boolean isSource;
        private boolean isSink;

        public Node() {
        }

        public Node(Face face) {
            this();
            this.face = face;
            int degree = face.getDegree();
            this.production = face.isOuterFace() ? -(1 * degree + 4) : (degree == 2 ? 0 : -(1 * degree - 4));
        }

        public Node(MGraph.Vertex<N> vertex) {
            this();
            this.vertex = vertex;
            this.production = 4 - vertex.getDegree();
        }

        public MGraph.Vertex<N> getVertex() {
            return this.vertex;
        }

        public Face getFace() {
            return this.face;
        }

        public boolean isFaceNode() {
            return this.face != null;
        }

        public boolean isVertexNode() {
            return this.vertex != null;
        }

        public void addInputArc(Arc<N> arc) {
            this.inputArcs.add(arc);
        }

        public void removeInputArc(Arc<N> arc) {
            this.inputArcs.remove(arc);
        }

        public void addOutputArc(Arc<N> arc) {
            this.outputArcs.add(arc);
        }

        public void removeOutputArc(Arc<N> arc) {
            this.outputArcs.remove(arc);
        }

        public Collection<Arc<N>> getInputArcs() {
            return this.inputArcs;
        }

        public Collection<Arc<N>> getOutputArcs() {
            return this.outputArcs;
        }

        public Arc<N> getArcToVia(Node<N> node, Face.Dart dart) {
            MGraph.Edge<?> edge = dart.getEdge();
            for (Arc<N> arc : this.outputArcs) {
                if (arc.getDestinationNode() != node || arc.getDart().getEdge() != edge) continue;
                return arc;
            }
            return null;
        }

        public int getProduction() {
            return this.production;
        }

        public void setProduction(int production) {
            this.production = production;
        }

        public String toString() {
            String s2 = "Node: \n";
            if (this.isSource) {
                s2 = "Source Node:\n";
            } else if (this.isSink) {
                s2 = "Sink Node:\n";
            }
            s2 = s2 + "hashCode: " + this.hashCode() + "\n";
            s2 = s2 + "vertex: " + this.vertex + "\n";
            s2 = s2 + "face: " + this.face + "\n";
            s2 = s2 + "production: " + this.production + "\n";
            return s2;
        }
    }
}

