/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.DualGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class GTPlanarizer<N, E> {
    private final int DEFAULT_ITERATIONS = 1;
    private int maxIterations = 1;
    private boolean isRandom = false;
    private Random random = new Random();

    public Collection<EmbeddedPlanarGraph<N, E>> planarize(MGraph<N, E> graph) {
        Collection<EmbeddedPlanarGraph<N, E>> epgs = this.createPlanarSubgraphs(graph);
        return epgs;
    }

    private Collection<EmbeddedPlanarGraph<N, E>> createPlanarSubgraphs(MGraph<N, E> graph) {
        ArrayList LMax = null;
        ArrayList RMax = null;
        ArrayList BMax = null;
        List<MGraph.Vertex<N>> orderingMax = null;
        for (int i = 0; i < this.maxIterations; ++i) {
            ArrayList L = new ArrayList();
            ArrayList arrayList = new ArrayList();
            ArrayList B = new ArrayList();
            List<MGraph.Vertex<N>> ordering = this.computeOrdering(graph.getVertices());
            this.computeLRB(L, arrayList, B, ordering);
            if (LMax != null && L.size() + arrayList.size() <= LMax.size() + RMax.size()) continue;
            LMax = L;
            RMax = arrayList;
            BMax = B;
            orderingMax = ordering;
        }
        int order = 0;
        for (MGraph.Vertex vertex : orderingMax) {
            vertex.setNumber(order++);
        }
        LinkedHashSet<Face> leftFaces = new LinkedHashSet<Face>();
        LinkedHashSet<Face> linkedHashSet = new LinkedHashSet<Face>();
        Collection<List<Face>> faceLists = this.createAllFaces(LMax, RMax, orderingMax, leftFaces, linkedHashSet);
        ArrayList<EmbeddedPlanarGraph<N, EmbeddedPlanarGraph<N, E>>> epgs = new ArrayList<EmbeddedPlanarGraph<N, EmbeddedPlanarGraph<N, E>>>();
        for (List<Face> faceList : faceLists) {
            EmbeddedPlanarGraph<N, E> epg = EmbeddedPlanarGraph.createGraph(graph);
            epgs.add(epg);
            epg.addFaces(faceList);
        }
        this.insertRemainingEdges(epgs, BMax, linkedHashSet, false, leftFaces, new HashSet(LMax));
        return epgs;
    }

    private List<MGraph.Vertex<N>> computeOrdering(Collection<MGraph.Vertex<N>> vertices) {
        ArrayList<MGraph.Vertex<N>> ordering = new ArrayList<MGraph.Vertex<N>>();
        ArrayList<MGraph.Vertex<N>> vertexArray = new ArrayList<MGraph.Vertex<N>>(vertices);
        int order = 0;
        MGraph.Vertex<N> v = this.getMinimumDegreeVertex(vertexArray);
        this.assignOrdering(ordering, v, order++);
        vertexArray.remove(v);
        ArrayList<MGraph.Vertex<N>> candidates = new ArrayList<MGraph.Vertex<N>>();
        while (!vertexArray.isEmpty()) {
            Collection<MGraph.Vertex<?>> neighbors = v.getNeighbors();
            for (MGraph.Vertex<?> nv : neighbors) {
                MGraph.Vertex<?> tmp = nv;
                if (!vertexArray.contains(tmp)) continue;
                candidates.add(tmp);
            }
            v = this.getMinimumDegreeVertex(candidates);
            if (v == null) {
                v = (MGraph.Vertex<N>)vertexArray.get(0);
            }
            this.assignOrdering(ordering, v, order++);
            vertexArray.remove(v);
            candidates.clear();
        }
        return ordering;
    }

    private MGraph.Vertex<N> getMinimumDegreeVertex(Collection<MGraph.Vertex<N>> vertices) {
        if (vertices.size() == 0) {
            return null;
        }
        ArrayList<MGraph.Vertex<N>> candidates = new ArrayList<MGraph.Vertex<N>>();
        int minDegree = this.getMinimumDegree(vertices);
        for (MGraph.Vertex<N> v : vertices) {
            if (v.getDegree() != minDegree) continue;
            candidates.add(v);
        }
        return this.pickVertex(candidates);
    }

    private int getMinimumDegree(Collection<MGraph.Vertex<N>> vertices) {
        int minDegree = Integer.MAX_VALUE;
        for (MGraph.Vertex<N> v : vertices) {
            int degree = v.getDegree();
            if (degree >= minDegree) continue;
            minDegree = degree;
        }
        return minDegree;
    }

    private MGraph.Vertex<N> pickVertex(List<MGraph.Vertex<N>> candidates) {
        int index = 0;
        if (this.isRandom()) {
            index = this.random.nextInt(candidates.size());
        }
        return candidates.get(index);
    }

    private void computeLRB(List<MGraph.Edge<?>> L, List<MGraph.Edge<?>> R2, List<MGraph.Edge<?>> B, List<MGraph.Vertex<N>> ordering) {
        int tmp;
        int jewo;
        int jevo;
        MGraph.Edge<?> je;
        int j;
        int tmp2;
        int iewo;
        int ievo;
        MGraph.Edge<?> ie;
        int i;
        List<MGraph.Edge<?>> edges = this.assignEdgeWeights(ordering);
        int size = edges.size();
        for (i = 0; i < size; ++i) {
            ie = edges.get(i);
            if (R2.contains(ie)) continue;
            ievo = ie.getV().getNumber();
            if (ievo > (iewo = ie.getW().getNumber())) {
                tmp2 = ievo;
                ievo = iewo;
                iewo = tmp2;
            }
            L.add(ie);
            for (j = i + 1; j < size; ++j) {
                je = edges.get(j);
                if (R2.contains(je)) continue;
                jevo = je.getV().getNumber();
                if (jevo > (jewo = je.getW().getNumber())) {
                    tmp = jevo;
                    jevo = jewo;
                    jewo = tmp;
                }
                if ((ievo >= jevo || jevo >= iewo || iewo >= jewo) && (jevo >= ievo || ievo >= jewo || jewo >= iewo)) continue;
                R2.add(je);
            }
        }
        size = R2.size();
        for (i = 0; i < size; ++i) {
            ie = R2.get(i);
            if (B.contains(ie)) continue;
            ievo = ie.getV().getNumber();
            if (ievo > (iewo = ie.getW().getNumber())) {
                tmp2 = ievo;
                ievo = iewo;
                iewo = tmp2;
            }
            for (j = i + 1; j < size; ++j) {
                je = R2.get(j);
                if (B.contains(je)) continue;
                jevo = je.getV().getNumber();
                if (jevo > (jewo = je.getW().getNumber())) {
                    tmp = jevo;
                    jevo = jewo;
                    jewo = tmp;
                }
                if ((ievo >= jevo || jevo >= iewo || iewo >= jewo) && (jevo >= ievo || ievo >= jewo || jewo >= iewo)) continue;
                B.add(je);
            }
        }
        R2.removeAll(B);
    }

    /*
     * WARNING - void declaration
     */
    private List<MGraph.Edge<?>> assignEdgeWeights(Collection<MGraph.Vertex<N>> vertices) {
        void var5_12;
        LinkedHashSet edges = new LinkedHashSet();
        for (MGraph.Vertex<N> vertex : vertices) {
            Collection<MGraph.Edge<?>> collection = vertex.getEdges();
            for (MGraph.Edge<?> e : collection) {
                edges.add(e);
            }
        }
        if (!this.isRandom) {
            return new ArrayList(edges);
        }
        int size = edges.size();
        for (MGraph.Edge edge : edges) {
            edge.setWeight(0);
        }
        ArrayList arrayList = new ArrayList(edges);
        boolean bl = false;
        while (var5_12 < size - 2) {
            MGraph.Edge ie = (MGraph.Edge)arrayList.get((int)var5_12);
            for (void j = var5_12 + true; j < size - 1; ++j) {
                MGraph.Edge je = (MGraph.Edge)arrayList.get((int)j);
                if (je.getWeight() >= ie.getWeight()) continue;
                arrayList.set((int)var5_12, je);
                arrayList.set((int)j, ie);
                ie = je;
            }
            ++var5_12;
        }
        return arrayList;
    }

    private void assignOrdering(List<MGraph.Vertex<N>> ordering, MGraph.Vertex<N> v, int order) {
        ordering.add(v);
        v.setNumber(order);
    }

    private Collection<List<Face>> createAllFaces(Collection<MGraph.Edge<?>> L, Collection<MGraph.Edge<?>> R2, List<MGraph.Vertex<N>> ordering, Collection<Face> leftFaces, Collection<Face> rightFaces) {
        ArrayList<Face> faces = new ArrayList<Face>();
        leftFaces.addAll(this.createFaces(L, null, ordering, false));
        rightFaces.addAll(this.createFaces(R2, L, ordering, true));
        faces.addAll(leftFaces);
        faces.addAll(rightFaces);
        this.removeFaces(faces);
        Collection<List<Face>> faceLists = this.computeFaceLists(faces);
        for (List<Face> faceList : faceLists) {
            Face outerFace = this.createOuterFace(faceList, L, R2);
            faceList.add(0, outerFace);
            rightFaces.add(outerFace);
            leftFaces.add(outerFace);
        }
        return faceLists;
    }

    private Collection<List<Face>> computeFaceLists(List<Face> faces) {
        ArrayList<List<Face>> faceLists = new ArrayList<List<Face>>();
        faces = new ArrayList<Face>(faces);
        while (!faces.isEmpty()) {
            ArrayList<Face> faceList = new ArrayList<Face>();
            faceLists.add(faceList);
            Face firstFace = faces.remove(0);
            faceList.add(firstFace);
            for (int i = 0; i < faceList.size(); ++i) {
                ArrayList<Face> connectedFaces = new ArrayList<Face>();
                Face iface = (Face)faceList.get(i);
                for (int j = 0; j < faces.size(); ++j) {
                    Face jface = faces.get(j);
                    if (!iface.connects(jface)) continue;
                    connectedFaces.add(jface);
                }
                faces.removeAll(connectedFaces);
                faceList.addAll(connectedFaces);
            }
        }
        return faceLists;
    }

    private Face createOuterFace(List<Face> faces, Collection<MGraph.Edge<?>> L, Collection<MGraph.Edge<?>> R2) {
        HashSet<Object> sharedEdges = new HashSet<Object>();
        LinkedHashSet<Face.Dart> outerDarts = new LinkedHashSet<Face.Dart>();
        HashSet<Object> outerEdges = new HashSet<Object>();
        ArrayList<Face.Dart> reverseDarts = new ArrayList<Face.Dart>();
        HashSet reverseEdges = new HashSet();
        int size = faces.size();
        MGraph.Edge firstDart = null;
        for (int i = 0; i < size; ++i) {
            Face f = faces.get(i);
            for (Face.Dart d : f.getDarts()) {
                MGraph.Edge<?> e = d.getEdge();
                boolean isSharedEdge = false;
                if (sharedEdges.contains(e)) continue;
                for (int j = i + 1; j < size; ++j) {
                    Face nf = faces.get(j);
                    if (!nf.containsEdge(e)) continue;
                    sharedEdges.add(e);
                    isSharedEdge = true;
                    break;
                }
                if (isSharedEdge) continue;
                if (firstDart == null) {
                    firstDart = d;
                    outerEdges.add(e);
                    continue;
                }
                if (!outerEdges.contains(e)) {
                    outerDarts.add(d);
                    outerEdges.add(e);
                    continue;
                }
                reverseDarts.add(d);
                reverseEdges.add(d.getEdge());
            }
        }
        outerDarts.addAll(reverseDarts);
        Face outerFace = new Face();
        outerFace.setOuterFace(true);
        MGraph.Vertex<?> v = firstDart.getV();
        outerDarts.remove(firstDart);
        outerFace.addEdge(((Face.Dart)firstDart).getEdge());
        ArrayList<Face.Dart> candidateDarts = new ArrayList<Face.Dart>();
        while (!outerDarts.isEmpty()) {
            candidateDarts.clear();
            int vNumber = v.getNumber();
            for (Face.Dart d : outerDarts) {
                if (!d.contains(v)) continue;
                candidateDarts.add(d);
            }
            Face.Dart nextDart = null;
            if (candidateDarts.size() > 1) {
                for (Face.Dart cd2 : candidateDarts) {
                    if (!reverseEdges.contains(cd2.getEdge())) continue;
                    reverseEdges.remove(cd2.getEdge());
                    nextDart = cd2;
                    break;
                }
                if (nextDart == null) {
                    for (Face.Dart cd2 : candidateDarts) {
                        if (!R2.contains(cd2.getEdge())) continue;
                        nextDart = cd2;
                        break;
                    }
                }
                if (nextDart == null) {
                    for (Face.Dart cd2 : candidateDarts) {
                        if (nextDart == null) {
                            nextDart = cd2;
                            continue;
                        }
                        MGraph.Vertex<?> cw = null;
                        cw = cd2.getW().getNumber() > cd2.getV().getNumber() ? cd2.getW() : cd2.getV();
                        MGraph.Vertex<?> nw = null;
                        nw = nextDart.getW().getNumber() > nextDart.getV().getNumber() ? nextDart.getW() : nextDart.getV();
                        int cNumber = cw.getNumber();
                        int nNumber = nw.getNumber();
                        if (cNumber <= vNumber || cNumber >= nNumber) continue;
                        nextDart = cd2;
                    }
                }
            } else {
                nextDart = candidateDarts.size() > 0 ? (Face.Dart)candidateDarts.get(0) : null;
            }
            if (nextDart == null) continue;
            outerDarts.remove(nextDart);
            outerFace.addEdge(nextDart.getEdge());
            v = nextDart.getOppositeVertex(v);
        }
        outerFace.setOuterFace(true);
        outerFace.createDarts();
        return outerFace;
    }

    private Collection<Face> createFaces(Collection<MGraph.Edge<?>> subgraph, Collection<MGraph.Edge<?>> alternateSubgraph, List<MGraph.Vertex<N>> ordering, boolean reverseDirection) {
        ArrayList<Face> faces = new ArrayList<Face>();
        block0: for (MGraph.Vertex<N> v : ordering) {
            Collection<MGraph.Edge<N>> connEdges = this.getIncidentEdges(v, subgraph);
            while (!connEdges.isEmpty()) {
                int maxOrder = v.getNumber();
                MGraph.Edge<N> maxEdge = null;
                for (MGraph.Edge<N> e : connEdges) {
                    MGraph.Vertex<N> w = e.getOppositeVertex(v);
                    int order = w.getNumber();
                    if (order <= maxOrder) continue;
                    maxOrder = order;
                    maxEdge = e;
                }
                if (maxEdge == null) continue block0;
                connEdges.remove(maxEdge);
                Collection<MGraph.Edge<?>> shortestPath = this.computeShortedReturnPath(v, maxEdge.getOppositeVertex(v), maxEdge, subgraph, alternateSubgraph);
                if (shortestPath.isEmpty()) continue;
                Face face = new Face();
                face.addEdge(maxEdge);
                face.addEdges(shortestPath);
                boolean invalidFace = false;
                if (face.getDegree() == 2) {
                    for (Face f : faces) {
                        if (!face.borders(f)) continue;
                        invalidFace = true;
                        break;
                    }
                }
                if (invalidFace) continue;
                if (reverseDirection) {
                    face.reverseDirection();
                }
                face.createDarts();
                faces.add(face);
            }
        }
        return faces;
    }

    private Collection<MGraph.Edge<?>> computeShortedReturnPath(MGraph.Vertex<?> sourceVertex, MGraph.Vertex<?> currentVertex, MGraph.Edge<?> currentEdge, Collection<MGraph.Edge<?>> edges, Collection<MGraph.Edge<?>> alternateEdges) {
        ArrayList result = new ArrayList();
        Collection<MGraph.Edge<?>> connEdges = this.getIncidentEdges(currentVertex, edges);
        connEdges.remove(currentEdge);
        int sourceOrder = sourceVertex.getNumber();
        int currentOrder = currentVertex.getNumber();
        Object edge = null;
        int minOrder = currentOrder;
        boolean lowerOrderFound = false;
        for (MGraph.Edge<?> e : connEdges) {
            MGraph.Vertex<?> vertex = e.getOppositeVertex(currentVertex);
            int order = vertex.getNumber();
            if (order < minOrder && order >= sourceOrder) {
                minOrder = order;
                edge = e;
            }
            if (order >= currentOrder) continue;
            lowerOrderFound = true;
        }
        if (edge == null && alternateEdges != null) {
            connEdges = this.getIncidentEdges(currentVertex, alternateEdges);
            int maxOrder = sourceOrder;
            for (MGraph.Edge edge2 : connEdges) {
                MGraph.Vertex<?> w = edge2.getOppositeVertex(currentVertex);
                int order = w.getNumber();
                if (order >= maxOrder && order < currentOrder) {
                    maxOrder = order;
                    edge = edge2;
                }
                if (order >= currentOrder) continue;
                lowerOrderFound = true;
            }
        }
        if (edge == null && !lowerOrderFound) {
            edge = currentEdge;
        }
        if (edge != null) {
            if (((MGraph.Edge)edge).contains(sourceVertex)) {
                result.add((MGraph.Edge<?>)edge);
            } else {
                Collection<MGraph.Edge<?>> shortestPath = null;
                MGraph.Vertex<?> oppositeVertex = ((MGraph.Edge)edge).getOppositeVertex(currentVertex);
                if (!oppositeVertex.equals(currentVertex) || !edge.equals(currentEdge)) {
                    shortestPath = this.computeShortedReturnPath(sourceVertex, oppositeVertex, (MGraph.Edge<?>)edge, edges, alternateEdges);
                }
                if (!shortestPath.isEmpty()) {
                    result.add((MGraph.Edge<?>)edge);
                    result.addAll(shortestPath);
                }
            }
        }
        return result;
    }

    private void removeFaces(Collection<Face> faces) {
        ArrayList<Face> facesToRemove = new ArrayList<Face>();
        for (Face f : faces) {
            if (f.isOuterFace() || f.getDegree() != 2) continue;
            for (Face nf : faces) {
                if (nf.isOuterFace() || f == nf || !f.borders(nf)) continue;
                facesToRemove.add(f);
            }
        }
        faces.removeAll(facesToRemove);
    }

    private Collection<MGraph.Edge<?>> getIncidentEdges(MGraph.Vertex<?> v, Collection<MGraph.Edge<?>> edges) {
        ArrayList result = new ArrayList(v.getEdges());
        result.retainAll(edges);
        return result;
    }

    private void insertRemainingEdges(Collection<EmbeddedPlanarGraph<N, E>> epgs, Collection<MGraph.Edge<?>> edgesToInsert, Collection<Face> faces, boolean isLeftFaces, Collection<Face> facesToIgnore, Collection<MGraph.Edge<?>> edgesToIgnore) {
        if (edgesToInsert.isEmpty()) {
            return;
        }
        for (EmbeddedPlanarGraph<N, E> epg : epgs) {
            DualGraph<N, E> dualGraph = DualGraph.createGraph(epg, facesToIgnore, edgesToIgnore);
            for (MGraph.Edge<?> edge : edgesToInsert) {
                this.insertEdge(dualGraph, edge, faces, isLeftFaces);
            }
        }
    }

    private void insertEdge(DualGraph<?, ?> graph, MGraph.Edge<?> edgeToInsert, Collection<Face> faces, boolean isLeftFaces) {
        EmbeddedPlanarGraph<?, ?> epg = graph.getOriginalGraph();
        MGraph<?, ?> originalGraph = epg.getOriginalGraph();
        MGraph.Vertex<?> v = edgeToInsert.getV();
        MGraph.Vertex<?> w = edgeToInsert.getW();
        boolean reverse = false;
        if (v.getNumber() < w.getNumber()) {
            reverse = true;
        }
        List<DualGraph.FaceEdge> shortestPath = this.computeShortestPathInDualGraph(graph, v, w, faces);
        DualGraph.FaceEdge fe = null;
        DualGraph.FaceVertex fv = null;
        MGraph.Vertex<?> currentVertex = null;
        MGraph.Vertex<?> prevVertex = v;
        MGraph.DummyEdge<?> newEdge = null;
        MGraph.Edge<?> prevEdge = null;
        ArrayList newFaceEdges = null;
        int length = shortestPath.size();
        for (int i = 0; i <= length; ++i) {
            if (i == length) {
                currentVertex = w;
            } else {
                fe = shortestPath.get(i);
                if (i == 0) {
                    fv = fe.getVertex(v);
                }
                if (newFaceEdges != null) {
                    fv.getFace().replaceEdge(prevEdge, newFaceEdges);
                }
                currentVertex = originalGraph.insertDummyVertex(fe.getEdge(), MGraph.DummyVertex.Type.CROSSING);
                ((MGraph.DummyVertex)currentVertex).setNumber(Integer.MAX_VALUE);
                newFaceEdges = new ArrayList(currentVertex.getEdges());
            }
            newEdge = originalGraph.addDummyEdge(prevVertex, currentVertex);
            newEdge.setOriginalEdge(edgeToInsert);
            MGraph.Vertex<?> startingVertex = null;
            startingVertex = isLeftFaces ? (reverse ? currentVertex : prevVertex) : (reverse ? prevVertex : currentVertex);
            this.subdivide(graph, fv, fe, newFaceEdges, newEdge, startingVertex, faces);
            prevVertex = currentVertex;
            prevEdge = fe.getEdge();
            if (i >= length) continue;
            fv = fe.getOppositeVertex(fv);
        }
        this.removeFaces(epg.getFaces());
        graph.updateFaces();
        graph.updateEdges();
    }

    private Collection<DualGraph.FaceVertex> getIncidentFaceVertices(MGraph.Vertex<?> v, DualGraph<?, ?> graph, Collection<Face> rightFaces) {
        LinkedHashSet<DualGraph.FaceVertex> result = new LinkedHashSet<DualGraph.FaceVertex>();
        DualGraph.FaceVertex outerFace = null;
        Collection<MGraph.Edge<?>> edges = v.getEdges();
        for (MGraph.Edge<?> e : edges) {
            Collection<DualGraph.FaceVertex> faceVertices = graph.getVerticesBorderingEdge(e);
            for (DualGraph.FaceVertex fv : faceVertices) {
                Face f = fv.getFace();
                if (!rightFaces.contains(f)) continue;
                if (f.isOuterFace()) {
                    outerFace = fv;
                    continue;
                }
                result.add(fv);
            }
        }
        if (result.isEmpty()) {
            result.add(outerFace);
        }
        return result;
    }

    private List<DualGraph.FaceEdge> computeShortestPathInDualGraph(DualGraph<?, ?> graph, MGraph.Vertex<?> v, MGraph.Vertex<?> w, Collection<Face> rightFaces) {
        EmbeddedPlanarGraph<?, ?> epg = graph.getOriginalGraph();
        Collection<DualGraph.FaceVertex> vFaceVertices = this.getIncidentFaceVertices(v, graph, rightFaces);
        Collection<DualGraph.FaceVertex> wFaceVertices = this.getIncidentFaceVertices(w, graph, rightFaces);
        ArrayList<DualGraph.FaceEdge> shortestPath = null;
        int shortestPathLength = Integer.MAX_VALUE;
        for (DualGraph.FaceVertex vfv : vFaceVertices) {
            for (DualGraph.FaceVertex wfv : wFaceVertices) {
                ArrayList<DualGraph.FaceEdge> path;
                if (vfv == wfv || (path = this.computeShortestPathInDualGraph(vfv, wfv, new HashSet<DualGraph.FaceVertex>(), shortestPathLength, rightFaces)) == null || shortestPath != null && path.size() >= shortestPath.size()) continue;
                shortestPath = path;
                shortestPathLength = shortestPath.size();
                if (shortestPath.size() != 1) continue;
                return shortestPath;
            }
        }
        return shortestPath;
    }

    private ArrayList<DualGraph.FaceEdge> computeShortestPathInDualGraph(DualGraph.FaceVertex sourceVertex, DualGraph.FaceVertex destVertex, Collection<DualGraph.FaceVertex> visitedVertices, int minPathLength, Collection<Face> faces) {
        ArrayList<DualGraph.FaceEdge> shortestPath = null;
        visitedVertices.add(sourceVertex);
        for (DualGraph.FaceEdge e : sourceVertex.getEdges()) {
            ArrayList<DualGraph.FaceEdge> path;
            if (e.contains(destVertex)) {
                shortestPath = new ArrayList<DualGraph.FaceEdge>();
                shortestPath.add(e);
                break;
            }
            DualGraph.FaceVertex oppositeVertex = e.getOppositeVertex(sourceVertex);
            if (!faces.contains(oppositeVertex.getFace()) || visitedVertices.contains(oppositeVertex) || visitedVertices.size() - 1 > minPathLength || (path = this.computeShortestPathInDualGraph(oppositeVertex, destVertex, visitedVertices, minPathLength, faces)) == null || shortestPath != null && path.size() >= shortestPath.size() - 1) continue;
            shortestPath = new ArrayList();
            shortestPath.add(e);
            shortestPath.addAll(path);
            minPathLength = shortestPath.size();
        }
        visitedVertices.remove(sourceVertex);
        return shortestPath;
    }

    public void subdivide(DualGraph<?, ?> graph, DualGraph.FaceVertex fv, DualGraph.FaceEdge fe, Collection<MGraph.Edge<?>> newFaceEdges, MGraph.Edge<?> dividingEdge, MGraph.Vertex<?> startingVertex, Collection<Face> faces) {
        Face face = fv.getFace();
        face.replaceEdge(fe.getEdge(), newFaceEdges);
        List<Face.Dart> removedDarts = face.replaceDarts(dividingEdge, startingVertex);
        Face newFace = new Face();
        MGraph.Edge firstDart = null;
        for (Face.Dart d : removedDarts) {
            if (firstDart == null) {
                firstDart = d;
            }
            newFace.addEdge(d.getEdge());
        }
        newFace.addEdge(dividingEdge);
        newFace.createDarts(firstDart.getV());
        EmbeddedPlanarGraph<?, ?> epg = graph.getOriginalGraph();
        epg.addFace(newFace);
        faces.add(newFace);
        graph.updateFaces();
    }

    public void setRandom(boolean flag) {
        this.isRandom = flag;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setMaxIterations(int iterations) {
        this.maxIterations = iterations;
    }

    private int getMaxIterations() {
        return this.maxIterations;
    }
}

