/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class AquaVectorCloseButton
extends VectorIcon {
    public static final Icon DEFAULT = new AquaVectorCloseButton(State.DEFAULT);
    public static final Icon PRESSED = new AquaVectorCloseButton(State.PRESSED);
    public static final Icon ROLLOVER = new AquaVectorCloseButton(State.ROLLOVER);
    private final State state;

    private AquaVectorCloseButton(State state) {
        super(14, 12);
        this.state = state;
    }

    @Override
    protected void paintIcon(Component c, Graphics2D g2, int width, int height, double scaling) {
        double d = Math.min(width, height);
        Color bgColor = new Color(0, 0, 0, 0);
        Color fgColor = new Color(0, 0, 0, 168);
        if (this.state == State.ROLLOVER) {
            fgColor = Color.WHITE;
            bgColor = new Color(255, 35, 25, 215);
        } else if (this.state == State.PRESSED) {
            fgColor = Color.WHITE;
            bgColor = new Color(185, 43, 33, 215);
        }
        if (bgColor.getAlpha() > 0) {
            double circPosX = ((double)width - d) / 2.0;
            double circPosY = ((double)height - d) / 2.0;
            Ellipse2D.Double bgCircle = new Ellipse2D.Double(circPosX, circPosY, d, d);
            g2.setColor(bgColor);
            g2.fill(bgCircle);
        }
        g2.setColor(fgColor);
        double strokeWidth = 1.4 * scaling;
        double mx = (double)width / 2.0;
        double my = (double)height / 2.0;
        double cr = 0.45 * (d / 2.0);
        BasicStroke stroke = new BasicStroke((float)strokeWidth, 1, 1);
        Area area = new Area();
        area.add(new Area(stroke.createStrokedShape(new Line2D.Double(mx - cr, my - cr, mx + cr, my + cr))));
        area.add(new Area(stroke.createStrokedShape(new Line2D.Double(mx + cr, my - cr, mx - cr, my + cr))));
        g2.fill(area);
    }

    private static enum State {
        DEFAULT,
        PRESSED,
        ROLLOVER;

    }
}

