/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.net.URI;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public final class NetworkSettings {
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final Logger LOGGER = Logger.getLogger(NetworkSettings.class.getName());
    private static ThreadLocal<Boolean> authenticationDialogSuppressed = new ThreadLocal();

    public static String getProxyHost(URI u) {
        ProxyCredentialsProvider provider = Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (provider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        return provider == null ? null : provider.getProxyHost(u);
    }

    public static String getProxyPort(URI u) {
        ProxyCredentialsProvider provider = Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (provider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        return provider == null ? null : provider.getProxyPort(u);
    }

    public static String getAuthenticationUsername(URI u) {
        ProxyCredentialsProvider provider = Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (provider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        if (provider != null && provider.isProxyAuthentication(u)) {
            return provider.getProxyUserName(u);
        }
        return null;
    }

    public static char[] getAuthenticationPassword(URI u) {
        ProxyCredentialsProvider provider = Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (provider == null) {
            LOGGER.log(Level.WARNING, "No ProxyCredentialsProvider found in lookup {0} thus no proxy information will provide!", Lookup.getDefault());
        }
        if (provider != null && provider.isProxyAuthentication(u)) {
            return provider.getProxyPassword(u);
        }
        return null;
    }

    @Deprecated
    public static String getKeyForAuthenticationPassword(URI u) {
        ProxyCredentialsProvider provider = Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (provider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        if (provider != null && provider.isProxyAuthentication(u)) {
            return PROXY_AUTHENTICATION_PASSWORD;
        }
        return null;
    }

    public static <R> R suppressAuthenticationDialog(Callable<R> blockOfCode) throws Exception {
        try {
            authenticationDialogSuppressed.set(Boolean.TRUE);
            R r = blockOfCode.call();
            return r;
        }
        finally {
            authenticationDialogSuppressed.remove();
        }
    }

    public static boolean isAuthenticationDialogSuppressed() {
        return Boolean.TRUE.equals(authenticationDialogSuppressed.get());
    }

    public static abstract class ProxyCredentialsProvider {
        protected abstract String getProxyUserName(URI var1);

        protected abstract char[] getProxyPassword(URI var1);

        protected abstract boolean isProxyAuthentication(URI var1);

        protected abstract String getProxyHost(URI var1);

        protected abstract String getProxyPort(URI var1);
    }
}

