/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ctrl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLResultSetTableModel;
import net.hironico.minisql.ui.history.QueryExecutionListener;

public class QueryResultCallable
implements Callable<List<SQLResultSetTableModel>> {
    private static final Logger LOGGER = Logger.getLogger(QueryResultCallable.class.getName());
    private final String sqlQuery;
    private final DbConfig config;
    private final boolean batchMode;
    private final Set<QueryExecutionListener> historyListeners = new HashSet<QueryExecutionListener>();

    public QueryResultCallable(String query, DbConfig config) {
        this(query, config, false);
    }

    public QueryResultCallable(String query, DbConfig config, boolean batchMode) {
        this.sqlQuery = query;
        this.config = config;
        this.batchMode = batchMode;
    }

    private SQLResultSetTableModel getResults(ResultSet resultSet) throws SQLException {
        return new SQLResultSetTableModel(resultSet, "Query", this.sqlQuery, 2);
    }

    private SQLResultSetTableModel getResults(int updateCount) throws SQLException {
        SQLResultSetTableModel result = new SQLResultSetTableModel(null, "Update query", this.sqlQuery, 2);
        Object[] columns = new String[]{"Updated"};
        result.setColumnIdentifiers(columns);
        Object[] row = new String[]{"Update count is " + updateCount};
        result.addRow(row);
        return result;
    }

    @Override
    public List<SQLResultSetTableModel> call() throws Exception {
        ArrayList<SQLResultSetTableModel> modelResults = new ArrayList<SQLResultSetTableModel>();
        try (Connection con = this.config.getConnection();){
            String[] sqlCommands = new String[]{this.sqlQuery};
            if (this.batchMode) {
                sqlCommands = this.sqlQuery.split(this.config.batchStatementSeparator);
            }
            for (String oneSqlCommand : sqlCommands) {
                Statement stmt = con.createStatement();
                boolean hasResultSet = stmt.execute(oneSqlCommand);
                int updateCount = stmt.getUpdateCount();
                do {
                    SQLResultSetTableModel oneResult = null;
                    if (hasResultSet) {
                        oneResult = this.getResults(stmt.getResultSet());
                    } else if (updateCount >= 0) {
                        oneResult = this.getResults(updateCount);
                    }
                    if (oneResult != null) {
                        modelResults.add(oneResult);
                    }
                    for (SQLWarning warn = stmt.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                        LOGGER.warning(warn.getLocalizedMessage());
                    }
                    hasResultSet = stmt.getMoreResults();
                    updateCount = stmt.getUpdateCount();
                } while (hasResultSet || updateCount >= 0);
                stmt.close();
            }
        }
        catch (ClassNotFoundException | SQLException sqle) {
            throw new Exception(sqle);
        }
        finally {
            this.fireQueryExecuted();
        }
        LOGGER.finer("Found " + modelResults.size() + " resultsets.");
        return modelResults;
    }

    public void addQueryHistoryListener(QueryExecutionListener listener) {
        this.historyListeners.add(listener);
    }

    public void removeQueryHistoryListener(QueryExecutionListener listener) {
        this.historyListeners.remove(listener);
    }

    private void fireQueryExecuted() {
        Runnable runNotif = () -> this.historyListeners.forEach(listener -> listener.queryExecuted(this.sqlQuery));
        Thread thread = new Thread(runNotif);
        thread.start();
    }
}

