/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.batch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import net.hironico.common.swing.ribbon.RibbonTab;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.DbConfigFile;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.batch.BatchFileTreeTableModel;
import net.hironico.minisql.ui.batch.ButtonEditor;
import net.hironico.minisql.ui.batch.ButtonRenderer;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class BatchPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(BatchPanel.class.getName());
    private JXTreeTable treeTable;
    private JToolBar toolbar;
    private JComboBox<String> cmbConfig;
    private BatchFileTreeTableModel model;
    private File lastUsedFolder;

    public BatchPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.model = new BatchFileTreeTableModel();
        this.treeTable = new JXTreeTable((TreeTableModel)this.model);
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.configureColumns();
        this.add((Component)this.getToolbar(), "North");
        JScrollPane scrollPane = new JScrollPane((Component)this.treeTable);
        this.add((Component)scrollPane, "Center");
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.toolbar.add(this.getCmbConfig());
        }
        return this.toolbar;
    }

    private JComboBox<String> getCmbConfig() {
        if (this.cmbConfig == null) {
            this.cmbConfig = new JComboBox();
            for (String cfg : DbConfigFile.getConfigNames()) {
                this.cmbConfig.addItem(cfg);
            }
            this.cmbConfig.addItemListener(e -> {
                if (1 == e.getStateChange()) {
                    this.setEditorTabTitle();
                    String configName = (String)e.getItem();
                    DbConfig dbConfig = DbConfigFile.getConfig(configName);
                    this.model.setDbConfig(dbConfig);
                }
            });
            String currentDbConfig = (String)this.cmbConfig.getSelectedItem();
            this.model.setDbConfig(DbConfigFile.getConfig(currentDbConfig));
        }
        return this.cmbConfig;
    }

    private void setEditorTabTitle() {
        String title = String.format("Batch %s", this.getCmbConfig().getSelectedItem());
        MainWindow.getInstance().setEditorTabTitle(this, title);
    }

    public void resetResults() {
        this.model.resetResults();
        this.treeTable.repaint();
    }

    public void clear() {
        this.model.clear();
        this.treeTable.repaint();
    }

    public void loadDirectory(File folder) {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            LOGGER.warning("Invalid folder: " + String.valueOf(folder));
            return;
        }
        this.lastUsedFolder = folder;
        File[] files = folder.listFiles();
        this.loadFiles(files);
    }

    public void loadFiles(File[] files) {
        BatchFileTreeTableModel model = (BatchFileTreeTableModel)this.treeTable.getTreeTableModel();
        if (files != null) {
            Arrays.stream(files).filter(File::isFile).forEach(model::addFile);
        } else {
            LOGGER.severe("Cannot load files from empty or null file list. Empty directory?");
        }
        this.treeTable.expandAll();
    }

    private void configureColumns() {
        this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.treeTable.getColumnModel().getColumn(1).setCellRenderer(new ButtonRenderer());
        this.treeTable.getColumnModel().getColumn(1).setCellEditor(new ButtonEditor(new JCheckBox(), this.treeTable));
        this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.treeTable.getColumnModel().getColumn(1).setMaxWidth(100);
        this.treeTable.getColumnModel().getColumn(2).setCellRenderer(new ButtonRenderer());
        this.treeTable.getColumnModel().getColumn(2).setCellEditor(new ButtonEditor(new JCheckBox(), this.treeTable));
        this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.treeTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(200);
    }

    public File getLastUsedFolder() {
        return this.lastUsedFolder;
    }

    public DbConfig getSelectedDbConfig() {
        if (this.getCmbConfig().getItemCount() <= 0) {
            LOGGER.warning("No db config in this batch panel. Returning null.");
            return null;
        }
        String dbConfigName = (String)this.getCmbConfig().getSelectedItem();
        LOGGER.info("Batch panel db config: " + dbConfigName);
        return DbConfigFile.getConfig(dbConfigName);
    }

    public void runAll() {
        BatchFileTreeTableModel model = (BatchFileTreeTableModel)this.treeTable.getTreeTableModel();
        model.setDbConfig(this.getSelectedDbConfig());
        model.runAll();
    }

    public void updateRibbon() {
        RibbonTab ribbonTab = MainWindow.getInstance().getRibbon().setSelectedRibbonTab("Batch");
        ribbonTab.updateDisplay();
    }
}

