/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.batch;

import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.hironico.minisql.model.SQLResultSetTableModel;
import net.hironico.minisql.ui.ShowQueryPanelAction;
import net.hironico.minisql.ui.batch.BatchFileNode;
import net.hironico.minisql.ui.batch.BatchFileTreeTableModel;
import net.hironico.minisql.ui.editor.QueryPanel;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;

class ButtonEditor
extends DefaultCellEditor {
    private static final Logger LOGGER = Logger.getLogger(ButtonEditor.class.getName());
    private final JButton button;
    private final JXTreeTable treeTable;
    private String label;
    private boolean isPushed;
    private int editingRow;

    public ButtonEditor(JCheckBox checkBox, JXTreeTable treeTable) {
        super(checkBox);
        this.treeTable = treeTable;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(e -> this.fireEditingStopped());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = true;
        this.editingRow = row;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            this.performAction();
        }
        this.isPushed = false;
        return this.label;
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    private void performAction() {
        int modelRow = this.treeTable.convertRowIndexToModel(this.editingRow);
        Object node = this.treeTable.getPathForRow(modelRow).getLastPathComponent();
        if (!(node instanceof DefaultMutableTreeTableNode)) {
            return;
        }
        DefaultMutableTreeTableNode treeNode = (DefaultMutableTreeTableNode)node;
        Object object = treeNode.getUserObject();
        if (!(object instanceof BatchFileNode)) {
            return;
        }
        BatchFileNode fileNode = (BatchFileNode)object;
        SwingUtilities.invokeLater(() -> {
            if ("Edit".equals(this.label)) {
                this.handleEdit(fileNode);
            } else if ("Run".equals(this.label)) {
                this.handleRun(fileNode);
            }
        });
    }

    private void handleEdit(BatchFileNode fileNode) {
        File file = fileNode.getFile();
        LOGGER.info("Edit action for file: " + file.getName());
        ShowQueryPanelAction openQueryEditorAction = new ShowQueryPanelAction();
        openQueryEditorAction.actionPerformed(null);
        QueryPanel queryPanel = openQueryEditorAction.getLastOpenedQueryPanel();
        queryPanel.loadFile(file);
    }

    private void handleRun(BatchFileNode fileNode) {
        LOGGER.info("Run action for file: " + fileNode.getFileName());
        BatchFileTreeTableModel model = (BatchFileTreeTableModel)this.treeTable.getTreeTableModel();
        TreePath treePath = this.treeTable.getPathForRow(this.editingRow);
        Object treeNode = treePath.getLastPathComponent();
        if (!(treeNode instanceof DefaultMutableTreeTableNode)) {
            LOGGER.severe("Last path component is not a DefaultMutableTreeTableNode.");
            return;
        }
        DefaultMutableTreeTableNode treeTableNode = (DefaultMutableTreeTableNode)treeNode;
        Object object = treeTableNode.getUserObject();
        if (!(object instanceof BatchFileNode)) {
            LOGGER.severe("Tree node user object i snot a BatchFileNode." + treeNode.getClass().getName());
            return;
        }
        BatchFileNode batchFileNode = (BatchFileNode)object;
        if (batchFileNode.isDirectory()) {
            LOGGER.severe("Running run action on a directory !");
            return;
        }
        model.setValueAt("Wait...", treeNode, 3);
        this.treeTable.repaint();
        Future<List<SQLResultSetTableModel>> fut = batchFileNode.run(model.getDbConfig());
        model.updateWhenFinished(fut, batchFileNode, treePath);
    }
}

