/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.editor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.hironico.common.swing.JSplitPaneNoDivider;
import net.hironico.common.swing.ribbon.RibbonTab;
import net.hironico.common.swing.table.FilterableTable;
import net.hironico.common.utils.json.JSONFile;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.DbConfigFile;
import net.hironico.minisql.model.SQLResultSetTableModel;
import net.hironico.minisql.ui.ExecuteQueryAction;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.editor.action.OpenQueryAction;
import net.hironico.minisql.ui.editor.action.SaveQueryAction;
import net.hironico.minisql.ui.renderer.ClobTableCellEditor;
import net.hironico.minisql.ui.renderer.ClobTableCellRenderer;
import net.hironico.minisql.ui.renderer.DateTableCellRenderer;
import net.hironico.minisql.ui.renderer.DecimalTableCellRenderer;
import net.hironico.minisql.ui.renderer.RowHighlightRenderer;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.JXStatusBar;

public class QueryPanel
extends JPanel
implements DbConfigFile.DbConfigFileListener {
    private static final Logger LOGGER = Logger.getLogger(QueryPanel.class.getName());
    private String lastUsedDirectory = null;
    private JToolBar toolbar = null;
    private JComboBox<String> cmbConfig = null;
    private JToggleButton toggleTable = null;
    private JToggleButton toggleJSON = null;
    private JToggleButton toggleText = null;
    private ButtonGroup groupResultType = null;
    private JSplitPaneNoDivider splitQuery = null;
    private RSyntaxTextArea txtQuery = null;
    private RTextScrollPane scrollQuery = null;
    private JPanel pnlQuery = null;
    private JXStatusBar stbEditorStatusBar = null;
    private JLabel lblPosition = null;
    private JLabel lblSelection = null;
    private JLabel lblBatchMode = null;
    private JLabel lblStatusMessage = null;
    private JPanel pnlResults = null;
    private ExecuteQueryAction executeQueryAction = null;
    private SaveQueryAction saveQueryAction = null;
    private OpenQueryAction openQueryAction = null;
    private boolean batchMode = false;

    public QueryPanel() {
        this.initialize();
        DbConfigFile.addListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolbar(), "North");
        this.add((Component)this.getSplitQuery(), "Center");
        this.getSplitQuery().setDividerLocation(250);
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.toolbar.add(this.getCmbConfig());
            this.toolbar.addSeparator();
            this.toolbar.add(this.getToggleTable());
            this.toolbar.add(this.getToggleJSON());
            this.toolbar.add(this.getToggleText());
        }
        return this.toolbar;
    }

    private ButtonGroup getGroupResultType() {
        if (this.groupResultType == null) {
            this.groupResultType = new ButtonGroup();
        }
        return this.groupResultType;
    }

    private JToggleButton getToggleTable() {
        if (this.toggleTable == null) {
            this.toggleTable = new JToggleButton("Table");
            this.toggleTable.setSelected(true);
            this.getGroupResultType().add(this.toggleTable);
        }
        return this.toggleTable;
    }

    private JToggleButton getToggleJSON() {
        if (this.toggleJSON == null) {
            this.toggleJSON = new JToggleButton("JSON");
            this.getGroupResultType().add(this.toggleJSON);
        }
        return this.toggleJSON;
    }

    private JToggleButton getToggleText() {
        if (this.toggleText == null) {
            this.toggleText = new JToggleButton("Text");
            this.getGroupResultType().add(this.toggleText);
        }
        return this.toggleText;
    }

    public String getLastUserDirectory() {
        if (this.lastUsedDirectory == null) {
            this.lastUsedDirectory = System.getProperty("user.home");
        }
        return this.lastUsedDirectory;
    }

    public void setLastUsedDirectory(String directoryName) {
        this.lastUsedDirectory = directoryName;
    }

    private OpenQueryAction getOpenQueryAction() {
        if (this.openQueryAction == null) {
            this.openQueryAction = new OpenQueryAction();
        }
        return this.openQueryAction;
    }

    private SaveQueryAction getSaveQueryAction() {
        if (this.saveQueryAction == null) {
            this.saveQueryAction = new SaveQueryAction();
        }
        return this.saveQueryAction;
    }

    private ExecuteQueryAction getExecuteQueryAction() {
        if (this.executeQueryAction == null) {
            this.executeQueryAction = new ExecuteQueryAction();
        }
        return this.executeQueryAction;
    }

    private JComboBox<String> getCmbConfig() {
        if (this.cmbConfig == null) {
            this.cmbConfig = new JComboBox();
            for (String cfg : DbConfigFile.getConfigNames()) {
                this.cmbConfig.addItem(cfg);
            }
            this.cmbConfig.addItemListener(e -> {
                if (1 == e.getStateChange()) {
                    MainWindow.getInstance().setEditorTabTitle(this, (String)this.cmbConfig.getSelectedItem());
                }
            });
        }
        return this.cmbConfig;
    }

    public void setDividerLocation(double location) {
        this.getSplitQuery().setDividerLocation(location);
    }

    private JSplitPaneNoDivider getSplitQuery() {
        if (this.splitQuery == null) {
            this.splitQuery = new JSplitPaneNoDivider();
            this.splitQuery.setBorder(BorderFactory.createEmptyBorder());
            this.splitQuery.setOrientation(0);
            this.splitQuery.setDividerLocation(250);
            this.splitQuery.add((Component)this.getPnlQuery(), (Object)"top");
            this.splitQuery.add((Component)this.getPnlResults(), (Object)"bottom");
        }
        return this.splitQuery;
    }

    public DbConfig getConfig() {
        int index = this.getCmbConfig().getSelectedIndex();
        if (index < 0) {
            return null;
        }
        String cfgName = this.getCmbConfig().getItemAt(index);
        if (cfgName == null) {
            return null;
        }
        return DbConfigFile.getConfig(cfgName);
    }

    public void setConfig(DbConfig config) {
        if (config == null) {
            return;
        }
        this.getCmbConfig().getModel().setSelectedItem(config.name);
    }

    public String getQueryText() {
        String sql = this.getTxtQuery().getSelectedText();
        if (sql == null) {
            sql = this.getTxtQuery().getText();
        }
        return sql == null ? "" : sql.trim();
    }

    public void setQueryText(String text) {
        this.getTxtQuery().setText(text);
    }

    public int getResultDisplayType() {
        if (this.getToggleTable().isSelected()) {
            return 2;
        }
        if (this.getToggleJSON().isSelected()) {
            return 3;
        }
        if (this.getToggleText().isSelected()) {
            return 1;
        }
        LOGGER.warning("Cannot find out about the display type of the results. Using table as a default.");
        return 2;
    }

    public void setResultsComponent(JComponent resultsComp) {
        this.getPnlResults().removeAll();
        this.getPnlResults().add((Component)resultsComp, "Center");
        this.getPnlResults().updateUI();
        this.getSplitQuery().setDividerLocation(250);
        this.getTxtQuery().setCaretPosition(0);
    }

    private JPanel getPnlResults() {
        if (this.pnlResults == null) {
            this.pnlResults = new JPanel();
            this.pnlResults.setBorder(BorderFactory.createEmptyBorder());
            this.pnlResults.setLayout(new BorderLayout());
        }
        return this.pnlResults;
    }

    private RTextScrollPane getScrollQuery() {
        if (this.scrollQuery == null) {
            this.scrollQuery = new RTextScrollPane((RTextArea)this.getTxtQuery());
            this.scrollQuery.setBorder(BorderFactory.createEmptyBorder());
            this.scrollQuery.setVerticalScrollBarPolicy(22);
        }
        return this.scrollQuery;
    }

    private JPanel getPnlQuery() {
        if (this.pnlQuery == null) {
            this.pnlQuery = new JPanel();
            this.pnlQuery.setLayout(new BorderLayout());
            this.pnlQuery.add((Component)this.getScrollQuery(), "Center");
            this.pnlQuery.add((Component)this.getStbEditorStatusBar(), "South");
        }
        return this.pnlQuery;
    }

    public RSyntaxTextArea getTxtQuery() {
        if (this.txtQuery == null) {
            this.txtQuery = new RSyntaxTextArea();
            this.txtQuery.setBorder(BorderFactory.createEmptyBorder());
            this.txtQuery.setSyntaxEditingStyle("text/sql");
            this.txtQuery.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    ActionEvent evt;
                    if (e.getKeyCode() == 116) {
                        evt = new ActionEvent(QueryPanel.this.getTxtQuery(), -1, "execute");
                        QueryPanel.this.getExecuteQueryAction().actionPerformed(evt);
                    }
                    if (e.getKeyCode() == 69 && e.isControlDown()) {
                        evt = new ActionEvent(QueryPanel.this.getTxtQuery(), -1, "execute");
                        QueryPanel.this.getExecuteQueryAction().actionPerformed(evt);
                    }
                    if (e.getKeyCode() == 115 && e.isControlDown()) {
                        MainWindow.getInstance().removeCurrentEditorTab();
                    }
                    if (e.getKeyCode() == 83 && e.isControlDown()) {
                        evt = new ActionEvent("", -1, "save");
                        QueryPanel.this.getSaveQueryAction().actionPerformed(evt);
                    }
                    if (e.getKeyCode() == 79 && e.isControlDown()) {
                        evt = new ActionEvent("", -1, "open");
                        QueryPanel.this.getOpenQueryAction().actionPerformed(evt);
                    }
                    if (e.getKeyCode() == 78 && e.isControlDown()) {
                        QueryPanel pnl = new QueryPanel();
                        pnl.setConfig(QueryPanel.this.getConfig());
                        MainWindow.getInstance().addNewEditorTab(pnl, QueryPanel.this.getConfig().name);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this.txtQuery.addCaretListener(e -> {
                int line = this.getTxtQuery().getCaretLineNumber() + 1;
                int y = this.getTxtQuery().getCaretOffsetFromLineStart();
                this.getLblPosition().setText(String.format("%d:%d (%d)", line, y, e.getDot()));
                String selectionText = this.getTxtQuery().getSelectedText();
                if (selectionText == null) {
                    this.getLblSelection().setText("0 chars");
                } else {
                    int lineBreaks = selectionText.length() - selectionText.replace("\n", "").length();
                    if (lineBreaks == 0) {
                        this.getLblSelection().setText(String.format("%d chars.", this.getTxtQuery().getSelectedText().length()));
                    } else {
                        this.getLblSelection().setText(String.format("%d chars, %d line breaks.", selectionText.length(), lineBreaks));
                    }
                }
            });
            this.txtQuery.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    QueryPanel.this.updateRibbon();
                }
            });
            float fontSize = 11.0f;
            if (SystemInfo.isLinux) {
                float f = fontSize = SystemInfo.isKDE ? 13.0f : 15.0f;
            }
            if (SystemInfo.isMacOS) {
                fontSize = 13.0f;
            }
            float fontScaledSize = UIScale.scale((float)fontSize);
            Font scaledFont = this.txtQuery.getFont().deriveFont(fontScaledSize);
            this.txtQuery.setFont(scaledFont);
        }
        return this.txtQuery;
    }

    private JXStatusBar getStbEditorStatusBar() {
        if (this.stbEditorStatusBar == null) {
            this.stbEditorStatusBar = new JXStatusBar();
            this.stbEditorStatusBar.setBorder(BorderFactory.createEtchedBorder());
            this.stbEditorStatusBar.add((Component)this.getLblPosition());
            this.stbEditorStatusBar.add((Component)this.getLblSelection());
            this.stbEditorStatusBar.add((Component)this.getLblBatchMode());
            this.stbEditorStatusBar.add((Component)this.getLblStatusMessage());
        }
        return this.stbEditorStatusBar;
    }

    private JLabel getLblSelection() {
        if (this.lblSelection == null) {
            this.lblSelection = new JLabel("0 chars");
            this.lblSelection.setToolTipText("Number of characters and line breaks if any currently selected");
        }
        return this.lblSelection;
    }

    private String getBatchModeStatusText() {
        return String.format("<html>Batch mode: <b>%s</b></html>", this.batchMode ? "ON" : "OFF");
    }

    private JLabel getLblBatchMode() {
        if (this.lblBatchMode == null) {
            this.lblBatchMode = new JLabel(this.getBatchModeStatusText());
            this.lblBatchMode.setToolTipText("Creates SQL statements executed separately using the statement separator in connection config.");
        }
        return this.lblBatchMode;
    }

    private JLabel getLblPosition() {
        if (this.lblPosition == null) {
            this.lblPosition = new JLabel();
            this.lblPosition.setText("1:0 (0)");
            this.lblPosition.setToolTipText("Caret position at 'line:offset (char number)'");
        }
        return this.lblPosition;
    }

    private JLabel getLblStatusMessage() {
        if (this.lblStatusMessage == null) {
            this.lblStatusMessage = new JLabel();
            this.lblStatusMessage.setText("");
        }
        return this.lblStatusMessage;
    }

    public void setStatusMessage(String msg) {
        this.getLblStatusMessage().setText(msg);
    }

    public static JComponent getResultComponentTab(List<SQLResultSetTableModel> modelListToDisplay) {
        JTabbedPane tabResults = new JTabbedPane(3);
        tabResults.setBorder(BorderFactory.createEmptyBorder(-2, -2, -1, -3));
        if (modelListToDisplay == null || modelListToDisplay.isEmpty()) {
            JComponent comp = QueryPanel.getEmptyResultComponent();
            tabResults.addTab("No result", comp);
        } else {
            for (int index = 0; index < modelListToDisplay.size(); ++index) {
                SQLResultSetTableModel model = modelListToDisplay.get(index);
                Object title = model.getTitle() != null ? model.getTitle() : String.format("Result #%d", index);
                title = (String)title + String.format(" (%d rows)", model.getRowCount());
                JComponent comp = QueryPanel.getResultComponent(model);
                tabResults.addTab((String)title, comp);
            }
        }
        return tabResults;
    }

    private static JComponent getEmptyResultComponent() {
        JPanel pnl = new JPanel();
        pnl.add(new JLabel("Although the query was correct the database did not return anything."));
        pnl.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        return pnl;
    }

    private static JComponent getResultComponent(SQLResultSetTableModel modelToDisplay) {
        switch (modelToDisplay.getDisplayType()) {
            case 1: {
                return QueryPanel.getResultComponentText(modelToDisplay);
            }
            case 3: {
                return QueryPanel.getResultComponentJSON(modelToDisplay);
            }
            case 4: {
                return QueryPanel.getResultComponentSQL(modelToDisplay);
            }
        }
        return QueryPanel.getResultComponentTable(modelToDisplay);
    }

    private static RSyntaxTextArea getResultTextArea(String syntax) {
        RSyntaxTextArea textResults = new RSyntaxTextArea();
        textResults.setSyntaxEditingStyle(syntax);
        textResults.setBorder(BorderFactory.createEmptyBorder());
        textResults.setEditable(false);
        return textResults;
    }

    private static RTextScrollPane getResultTextAreaScroll(RSyntaxTextArea textResults) {
        RTextScrollPane scrollResults = new RTextScrollPane((RTextArea)textResults);
        scrollResults.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        scrollResults.setHorizontalScrollBarPolicy(30);
        scrollResults.setVerticalScrollBarPolicy(20);
        return scrollResults;
    }

    private static String tableModelToString(DefaultTableModel modelToDisplay) {
        StringBuilder textToDisplay = new StringBuilder();
        for (int row = 0; row < modelToDisplay.getRowCount(); ++row) {
            for (int column = 0; column < modelToDisplay.getColumnCount(); ++column) {
                Object value;
                if (column > 0) {
                    textToDisplay.append("\t");
                }
                String valueStr = (value = modelToDisplay.getValueAt(row, column)) == null ? "NULL" : value.toString();
                textToDisplay.append(valueStr);
            }
        }
        return textToDisplay.toString();
    }

    private static String tableModelToJSON(DefaultTableModel modelToDisplay) {
        try {
            ArrayList flatRows = new ArrayList();
            for (int row = 0; row < modelToDisplay.getRowCount(); ++row) {
                HashMap<String, Object> rowValues = new HashMap<String, Object>();
                for (int col = 0; col < modelToDisplay.getColumnCount(); ++col) {
                    String colName = modelToDisplay.getColumnName(col);
                    rowValues.put(colName, modelToDisplay.getValueAt(row, col));
                }
                flatRows.add(rowValues);
            }
            return JSONFile.serialize(flatRows);
        }
        catch (JsonProcessingException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            return sw.toString();
        }
    }

    private static JComponent getResultComponentSQL(DefaultTableModel modelToDisplay) {
        RSyntaxTextArea textResults = QueryPanel.getResultTextArea("text/sql");
        textResults.setText(QueryPanel.tableModelToString(modelToDisplay));
        return QueryPanel.getResultTextAreaScroll(textResults);
    }

    private static JComponent getResultComponentJSON(DefaultTableModel modelToDisplay) {
        RSyntaxTextArea textResults = QueryPanel.getResultTextArea("text/json");
        textResults.setText(QueryPanel.tableModelToJSON(modelToDisplay));
        return QueryPanel.getResultTextAreaScroll(textResults);
    }

    private static JComponent getResultComponentText(DefaultTableModel modelToDisplay) {
        RSyntaxTextArea textResults = QueryPanel.getResultTextArea("text/csv");
        textResults.setText(QueryPanel.tableModelToString(modelToDisplay));
        return QueryPanel.getResultTextAreaScroll(textResults);
    }

    private static JComponent getResultComponentTable(DefaultTableModel modelToDisplay) {
        FilterableTable table = new FilterableTable();
        table.setModel((TableModel)modelToDisplay);
        table.setAutoResizeMode(0);
        table.setEditable(false);
        table.setColumnControlVisible(false);
        table.setColumnSelectionAllowed(true);
        for (int index = 0; index < modelToDisplay.getColumnCount(); ++index) {
            Class<?> clazz = modelToDisplay.getColumnClass(index);
            String className = clazz.getName().toUpperCase();
            LOGGER.info("Classname: " + className);
            RowHighlightRenderer rendererDelegate = new RowHighlightRenderer(table.getDefaultRenderer(clazz));
            if (className.contains("CLOB")) {
                TableCellEditor editorDelegate = table.getDefaultEditor(clazz);
                ClobTableCellRenderer clobRenderer = new ClobTableCellRenderer(rendererDelegate);
                ClobTableCellEditor clobEditor = new ClobTableCellEditor(editorDelegate);
                table.setDefaultRenderer(clazz, (TableCellRenderer)clobRenderer);
                table.setDefaultEditor(clazz, (TableCellEditor)clobEditor);
                continue;
            }
            if (className.contains("TIME")) {
                DateTableCellRenderer dateRenderer = new DateTableCellRenderer(rendererDelegate);
                table.setDefaultRenderer(clazz, (TableCellRenderer)dateRenderer);
                continue;
            }
            if (className.contains("DECIMAL")) {
                DecimalTableCellRenderer decimalRenderer = new DecimalTableCellRenderer(rendererDelegate);
                table.setDefaultRenderer(clazz, (TableCellRenderer)decimalRenderer);
                continue;
            }
            table.setDefaultRenderer(clazz, (TableCellRenderer)rendererDelegate);
        }
        JScrollPane scroll = new JScrollPane((Component)table);
        scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        return scroll;
    }

    @Override
    public void configAdded(DbConfig config) {
        this.getCmbConfig().addItem(config.name);
    }

    @Override
    public void configRemoved(DbConfig config) {
        this.getCmbConfig().removeItem(config.name);
    }

    public void loadFile(File file) {
        this.setLastUsedDirectory(file.getAbsolutePath());
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = br.readLine();
            }
            this.setQueryText(sb.toString());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error while reading the file:\n" + ex.getMessage(), "Error", 0);
        }
    }

    public void saveFile(File saveFile) {
        int confirm;
        String lastDir = saveFile.getAbsolutePath();
        this.setLastUsedDirectory(lastDir);
        if (saveFile.exists() && (confirm = JOptionPane.showConfirmDialog(this, "File exists. Overwrite ?", "Confirm...", 0)) != 0) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(saveFile));){
            bw.write(this.getTxtQuery().getText());
            bw.flush();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error while writing to the file:\n" + ex.getMessage(), "Error", 0);
        }
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
        this.getLblBatchMode().setText(this.getBatchModeStatusText());
    }

    public void updateRibbon() {
        RibbonTab ribbonTab = MainWindow.getInstance().getRibbon().setSelectedRibbonTab("Editor");
        ribbonTab.updateDisplay();
    }
}

