/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import net.hironico.minisql.ui.CopyAllAction;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class ClobTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ClobTableCellEditor.class.getName());
    private Object editedValue;
    private JPanel pnl = null;
    private JLabel label = null;
    private JButton button = null;
    private RTextScrollPane scrollClobViewer = null;
    private RSyntaxTextArea txtClobViewer = null;
    private JToolBar toolbarClobViewer = null;
    private JTextField txtSearchClobViewer = null;
    private JPanel pnlClobViewer = null;
    private JDialog dialogClobViewer = null;
    private TableCellEditor editorDelegate;
    private JTable parentTable = null;

    public ClobTableCellEditor(TableCellEditor delegate) {
        this.editorDelegate = delegate;
        this.initialize();
    }

    protected void initialize() {
        this.getPanel();
    }

    protected JPanel getPanel() {
        if (this.pnl == null) {
            this.pnl = new JPanel();
            this.pnl.setBorder(BorderFactory.createEmptyBorder());
            this.pnl.setLayout(new FlowLayout(2, 0, 0));
            this.pnl.add(this.getLabel());
            this.pnl.add(this.getButton());
        }
        return this.pnl;
    }

    protected JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createEmptyBorder());
            this.label.setOpaque(false);
        }
        return this.label;
    }

    private JScrollPane getScrollClobViewer() {
        if (this.scrollClobViewer == null) {
            this.scrollClobViewer = new RTextScrollPane((RTextArea)this.getTxtClobViewer());
            this.scrollClobViewer.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.scrollClobViewer;
    }

    private RSyntaxTextArea getTxtClobViewer() {
        if (this.txtClobViewer == null) {
            this.txtClobViewer = new RSyntaxTextArea();
            this.txtClobViewer.setBorder(BorderFactory.createEmptyBorder());
            this.txtClobViewer.setEditable(false);
            this.txtClobViewer.setBackground(new Color(238, 243, 250));
        }
        return this.txtClobViewer;
    }

    private JToolBar getToolbarClobViewer() {
        if (this.toolbarClobViewer == null) {
            this.toolbarClobViewer = new JToolBar();
            this.toolbarClobViewer.setFloatable(false);
            CopyAllAction copyAllAction = new CopyAllAction((JTextComponent)this.getTxtClobViewer());
            copyAllAction.putValue("SwingLargeIconKey", null);
            this.toolbarClobViewer.add((Action)((Object)copyAllAction));
            this.toolbarClobViewer.addSeparator();
            this.toolbarClobViewer.add(new JLabel("Hightlight: "));
            this.toolbarClobViewer.add(this.getTxtSearchClobViewer());
        }
        return this.toolbarClobViewer;
    }

    private JTextField getTxtSearchClobViewer() {
        if (this.txtSearchClobViewer == null) {
            this.txtSearchClobViewer = new JTextField();
            this.txtSearchClobViewer.setBorder(BorderFactory.createEmptyBorder());
            this.txtSearchClobViewer.addActionListener(evt -> {
                try {
                    String word = this.getTxtSearchClobViewer().getText();
                    Highlighter h = this.txtClobViewer.getHighlighter();
                    h.removeAllHighlights();
                    if (word == null || "".equals(word)) {
                        Rectangle rect = this.getTxtClobViewer().modelToView(0);
                        this.getScrollClobViewer().scrollRectToVisible(rect);
                        return;
                    }
                    Document doc = this.txtClobViewer.getDocument();
                    String fullText = doc.getText(0, doc.getLength());
                    DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.RED);
                    int pos = 0;
                    int firstOccurencePos = -1;
                    while ((pos = fullText.indexOf(word, pos)) >= 0) {
                        if (firstOccurencePos == -1) {
                            firstOccurencePos = pos;
                        }
                        h.addHighlight(pos, pos + word.length(), painter);
                        pos += word.length();
                    }
                    if (firstOccurencePos >= 0) {
                        this.getTxtClobViewer().setCaretPosition(firstOccurencePos);
                        Rectangle rect = this.getTxtClobViewer().modelToView(firstOccurencePos);
                        this.getScrollClobViewer().scrollRectToVisible(rect);
                    }
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.SEVERE, "Problem while highlighting things in CLOB viewer.", ex);
                }
            });
        }
        return this.txtSearchClobViewer;
    }

    private JPanel getPnlClobViewer() {
        if (this.pnlClobViewer == null) {
            this.pnlClobViewer = new JPanel();
            this.pnlClobViewer.setLayout(new BorderLayout());
            this.pnlClobViewer.add((Component)this.getToolbarClobViewer(), "North");
            this.pnlClobViewer.add((Component)this.getScrollClobViewer(), "Center");
        }
        return this.pnlClobViewer;
    }

    private JDialog getDialogClobViewer(Component parent) {
        if (this.dialogClobViewer == null) {
            this.dialogClobViewer = new JDialog((Window)null, "CLOB viewer...");
            this.dialogClobViewer.setModal(true);
            this.dialogClobViewer.getContentPane().add(this.getPnlClobViewer());
            this.dialogClobViewer.setDefaultCloseOperation(2);
            this.dialogClobViewer.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    ClobTableCellEditor.this.stopCellEditing();
                }

                @Override
                public void windowClosing(WindowEvent evt) {
                    LOGGER.info("Window closing.");
                }
            });
        }
        int width = 240;
        int height = 350;
        int x = (int)parent.getLocationOnScreen().getX();
        int y = (int)parent.getLocationOnScreen().getY();
        this.dialogClobViewer.setSize(width, height);
        this.dialogClobViewer.setLocationRelativeTo(parent);
        this.dialogClobViewer.setLocation(x + 10, y + 10);
        this.dialogClobViewer.toFront();
        this.dialogClobViewer.requestFocus();
        return this.dialogClobViewer;
    }

    protected JButton getButton() {
        if (this.button == null) {
            this.button = new JButton();
            this.button.setText("...");
            this.button.setBorderPainted(false);
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.addActionListener(evt -> {
                try {
                    String txt = (String)this.editedValue;
                    if (txt == null) {
                        LOGGER.fine("CLOB Edited value is null.");
                        return;
                    }
                    txt = txt.replace('\u001e', '\n');
                    txt = txt.replace('\u001f', '\'');
                    this.getTxtClobViewer().setText(txt);
                    this.getTxtClobViewer().setCaretPosition(0);
                    this.getTxtSearchClobViewer().setText("");
                    JDialog dlg = this.getDialogClobViewer(this.parentTable.getParent().getParent());
                    dlg.setSize(this.parentTable.getParent().getWidth() / 2, dlg.getHeight());
                    dlg.setVisible(true);
                    dlg.toFront();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Error while getting the CLOB value into readable format.");
                    LOGGER.log(Level.SEVERE, "Cannot display CLOB value.", ex);
                }
            });
        }
        return this.button;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editedValue = value;
        this.parentTable = table;
        Class<?> clazz = table.getModel().getColumnClass(column);
        if (clazz.getName().toLowerCase().endsWith("clob")) {
            try {
                String txt = value == null ? "<NULL>" : "<CLOB>";
                this.getLabel().setText(txt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Color bg = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.getPanel().setBackground(bg);
            Color fg = isSelected ? table.getSelectionForeground() : table.getForeground();
            this.getLabel().setForeground(fg);
            return this.getPanel();
        }
        LOGGER.warning("Using delegate editor ...");
        return this.editorDelegate.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editedValue;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }
}

