/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.hironico.common.swing.image.ImageIconUtils;
import net.hironico.minisql.model.SQLObject;
import net.hironico.minisql.model.SQLObjectTypeEnum;
import net.hironico.minisql.model.SQLTable;
import net.hironico.minisql.ui.visualdb.DbColorScheme;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDGraphScene;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class DBGraphScene
extends VMDGraphScene {
    private static final Logger LOGGER = Logger.getLogger(DBGraphScene.class.getName());
    protected ImageIcon iconTable;
    private final List<SQLTable> displayedTableList = new ArrayList<SQLTable>();
    private final Map<String, String> nodeColors = new HashMap<String, String>();

    public DBGraphScene() {
        String fullIconName = "/icons/png_64/icons8_data_sheet_64px.png";
        this.iconTable = ImageIconUtils.createImageIcon((String)fullIconName, (String)"");
        if (this.iconTable == null) {
            LOGGER.severe(String.format("Cannot load icon : %s", fullIconName));
            return;
        }
        this.iconTable = ImageIconUtils.getScaledImage((ImageIcon)this.iconTable, (int)16, (int)16);
    }

    public List<SQLTable> getDisplayedTableList() {
        return this.displayedTableList;
    }

    public void cleanUpScene() {
        LOGGER.finer("Cleanup scene...");
        ArrayList myNodes = new ArrayList(this.getNodes());
        for (String nodeName : myNodes) {
            this.removeNode(nodeName);
        }
        LOGGER.finer("Cleanup scene complete.");
    }

    public void createScene(List<SQLTable> tableList) {
        if (this.getView() == null) {
            this.createView();
        }
        tableList.forEach(table -> {
            if (!this.displayedTableList.contains(table)) {
                this.displayedTableList.add((SQLTable)table);
            }
        });
        Point dropPoint = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(dropPoint, this.getView());
        AtomicInteger coordX = new AtomicInteger(dropPoint.x);
        AtomicInteger coordY = new AtomicInteger(dropPoint.y);
        Runnable run = () -> {
            this.displayedTableList.forEach(table -> {
                String nodeId = this.createNode(coordX.get(), coordY.get(), (SQLObject)table);
                if (nodeId != null) {
                    HashMap pinByCategories = new HashMap();
                    table.getColumns().forEach(column -> {
                        String pinId = String.format("%s.%s.%s", table.schemaName, table.name, column.name);
                        VMDPinWidget pinWidget = (VMDPinWidget)this.addPin(nodeId, pinId);
                        String name = String.format("%s : %s", column.name, column.getTypeString());
                        pinWidget.setProperties(name, null);
                        if (column.isPrimaryKey.booleanValue()) {
                            List pkPinList = pinByCategories.getOrDefault("Primary keys", new ArrayList());
                            pkPinList.add(pinWidget);
                            pinByCategories.putIfAbsent("Primary keys", pkPinList);
                        } else {
                            List pkPinList = pinByCategories.getOrDefault("Columns", new ArrayList());
                            pkPinList.add(pinWidget);
                            pinByCategories.putIfAbsent("Columns", pkPinList);
                        }
                    });
                    VMDNodeWidget nodeWidget = (VMDNodeWidget)this.findWidget(nodeId);
                    nodeWidget.sortPins(pinByCategories);
                    coordX.addAndGet(100);
                    coordY.addAndGet(100);
                }
            });
            this.displayedTableList.forEach(table -> table.getForeignKeys().values().forEach(fkList -> fkList.forEach(fk -> {
                String sourcePinId = String.format("%s.%s.%s", fk.fkSchemaName, fk.fkTableName, fk.fkColumnName);
                String targetPinId = String.format("%s.%s.%s", fk.pkSchemaName, fk.pkTableName, fk.pkColumnName);
                this.createEdge(sourcePinId, targetPinId);
            })));
            this.revalidate();
            this.validate();
            this.repaint();
        };
        SwingUtilities.invokeLater(run);
    }

    private String createNode(int x, int y, SQLObject sqlObject) {
        String nodeId = String.format("%s.%s", sqlObject.schemaName, sqlObject.name);
        if (this.getNodes().contains(nodeId)) {
            LOGGER.warning(String.format("Scene already contains %s", nodeId));
            return null;
        }
        this.nodeColors.put(nodeId, sqlObject.color);
        VMDNodeWidget widget = (VMDNodeWidget)this.addNode(nodeId);
        widget.setPreferredLocation(new Point(x, y));
        Image image = switch (sqlObject.type) {
            case SQLObjectTypeEnum.TABLE, SQLObjectTypeEnum.VIEW -> {
                if (this.iconTable == null) {
                    yield null;
                }
                yield this.iconTable.getImage();
            }
            default -> null;
        };
        widget.setNodeProperties(image, sqlObject.name, sqlObject.type.toString(), null);
        return nodeId;
    }

    private void createEdge(String sourcePinID, String targetPinID) {
        String edgeIDStr = String.format("%s<->%s", sourcePinID, targetPinID);
        if (this.getEdges().contains(edgeIDStr)) {
            LOGGER.warning(String.format("This edge already exists %s", edgeIDStr));
            this.removeEdge(edgeIDStr);
        }
        if (!this.getPins().contains(sourcePinID)) {
            LOGGER.warning(String.format("Source pin is not found: %s", sourcePinID));
            return;
        }
        if (!this.getPins().contains(targetPinID)) {
            LOGGER.warning(String.format("Target pin is not found: %s", targetPinID));
            return;
        }
        LOGGER.info(String.format("Creating edge: %s", edgeIDStr));
        this.addEdge(edgeIDStr);
        this.setEdgeSource(edgeIDStr, sourcePinID);
        this.setEdgeTarget(edgeIDStr, targetPinID);
    }

    public void zoomMinus() {
        double newZoomFactor = this.getZoomFactor() * 0.9;
        this.setZoomFactor(newZoomFactor);
    }

    public void zoomPlus() {
        double newZoomFactor = this.getZoomFactor() * 1.1;
        this.setZoomFactor(newZoomFactor);
    }

    public void zoomOriginal() {
        this.setZoomFactor(1.0);
    }

    protected Widget attachNodeWidget(String node) {
        LOGGER.info("Attaching node: " + node);
        String colorCode = this.nodeColors.get(node);
        VMDColorScheme colorScheme = colorCode == null ? VMDFactory.getOriginalScheme() : new DbColorScheme(colorCode);
        return this.attachNodeWidget(node, colorScheme);
    }

    protected Widget attachNodeWidget(String node, VMDColorScheme scheme) {
        VMDNodeWidget widget = new VMDNodeWidget((Scene)this, scheme);
        Widget mainLayer = (Widget)this.getChildren().get(1);
        mainLayer.addChild((Widget)widget);
        widget.getHeader().getActions().addAction(this.createObjectHoverAction());
        widget.getActions().addAction(this.createSelectAction());
        widget.getActions().addAction(ActionFactory.createMoveAction());
        return widget;
    }
}

