/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLTable;

public class SQLTableLoaderThread
implements Callable<List<SQLTable>> {
    private static final Logger LOGGER = Logger.getLogger(SQLTableLoaderThread.class.getName());
    private List<SQLTable> tablesListToDisplay = null;
    private final DbConfig dbConfig;

    public SQLTableLoaderThread(List<SQLTable> tableList, DbConfig dbConfig) {
        this.tablesListToDisplay = tableList;
        this.dbConfig = dbConfig;
    }

    @Override
    public List<SQLTable> call() {
        for (SQLTable table : this.tablesListToDisplay) {
            try {
                LOGGER.info("Loading table columns for: " + table.name);
                table.loadMetaData(this.dbConfig);
                table.color = this.dbConfig.color;
            }
            catch (SQLException sqle) {
                LOGGER.log(Level.SEVERE, sqle.getMessage(), sqle);
            }
        }
        return this.tablesListToDisplay;
    }
}

