/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.hironico.common.utils.XMLFile;
import net.hironico.minisql.DbConfig;

@JsonRootName(value="config")
@JacksonXmlRootElement(localName="config")
@JsonIgnoreProperties(ignoreUnknown=true)
public class DbConfigFile {
    private static final Logger LOGGER = Logger.getLogger(DbConfigFile.class.getName());
    protected static List<DbConfig> all = new ArrayList<DbConfig>();
    protected static Boolean decoratedWindow = Boolean.FALSE;
    protected static List<String> driverJarPaths = new ArrayList<String>();
    private static final List<DbConfigFileListener> listeners = new ArrayList<DbConfigFileListener>();
    private static final DbConfigFile instance = new DbConfigFile();

    private DbConfigFile() {
    }

    public static DbConfigFile getInstance() {
        return instance;
    }

    public static void addListener(DbConfigFileListener listener) {
        if (listeners.contains(listener)) {
            return;
        }
        listeners.add(listener);
    }

    public void removeListener(DbConfigFileListener listener) {
        listeners.remove(listener);
    }

    private static void fireConfigAdded(DbConfig config) {
        SwingUtilities.invokeLater(() -> listeners.forEach(listener -> listener.configAdded(config)));
    }

    private static void fireConfigRemoved(DbConfig config) {
        SwingUtilities.invokeLater(() -> listeners.forEach(listener -> listener.configRemoved(config)));
    }

    public static void addConfig(String name) {
        DbConfigFile.addConfig(name, "", "", "");
    }

    private static void addConfig(String name, String url, String user, String password) {
        DbConfig cfg = new DbConfig();
        cfg.jdbcUrl = url;
        cfg.user = user;
        cfg.password = password;
        cfg.name = name;
        all.add(cfg);
        DbConfigFile.fireConfigAdded(cfg);
    }

    public static DbConfig duplicate(String src, String dest) {
        try {
            DbConfig srcCfg = DbConfigFile.getConfig(src);
            if (srcCfg == null) {
                return null;
            }
            DbConfig newCfg = (DbConfig)srcCfg.clone();
            newCfg.name = dest;
            all.add(newCfg);
            DbConfigFile.fireConfigAdded(newCfg);
            return newCfg;
        }
        catch (CloneNotSupportedException ex) {
            LOGGER.log(Level.SEVERE, "Cannot clone db config.", ex);
            return null;
        }
    }

    public static synchronized DbConfig getConfig(String name) {
        for (DbConfig cfg : all) {
            if (!cfg.name.equals(name)) continue;
            return cfg;
        }
        return null;
    }

    public static void removeConfig(String name) {
        DbConfig cfg = DbConfigFile.getConfig(name);
        all.remove(cfg);
        DbConfigFile.fireConfigRemoved(cfg);
    }

    public static Collection<String> getConfigNames() {
        ArrayList<String> lst = new ArrayList<String>();
        for (DbConfig cfg : all) {
            lst.add(cfg.name);
        }
        Collections.sort(lst);
        return lst;
    }

    @JsonProperty(value="dbConfigList")
    @JacksonXmlElementWrapper(localName="db-config-list")
    @JacksonXmlProperty(localName="db-config")
    public List<DbConfig> getAllConfigs() {
        return all;
    }

    public void setAllConfigs(List<DbConfig> configs) {
        LOGGER.info("Setting db config list: " + configs.size() + " configs.");
        all = configs;
    }

    @JsonProperty(value="decorated-window")
    @JacksonXmlProperty(localName="decorated-window")
    public Boolean getDecoratedWindow() {
        return decoratedWindow;
    }

    public void setDecoratedWindow(Boolean decoratedWindow) {
        DbConfigFile.decoratedWindow = decoratedWindow == null ? Boolean.FALSE : decoratedWindow;
    }

    @JsonProperty(value="driverJarPaths")
    @JacksonXmlElementWrapper(localName="driver-jar-paths")
    @JacksonXmlProperty(localName="driver-jar-path")
    public List<String> getDriverJarPaths() {
        return driverJarPaths;
    }

    public void setDriverJarPaths(List<String> driverJarPaths) {
        DbConfigFile.driverJarPaths = driverJarPaths == null ? new ArrayList() : driverJarPaths;
        LOGGER.info("Loaded " + DbConfigFile.driverJarPaths.size() + " driver JAR paths.");
    }

    public void addDriverJarPath(String path) {
        if (path != null && !driverJarPaths.contains(path)) {
            driverJarPaths.add(path);
        }
    }

    public void removeDriverJarPath(String path) {
        driverJarPaths.remove(path);
    }

    public static File getConfigFile() {
        return new File(System.getProperty("user.home") + File.separator + "minisql-config.xml");
    }

    public static synchronized void saveConfig() throws Exception {
        File configFile = DbConfigFile.getConfigFile();
        LOGGER.info("Saving config into " + configFile.getAbsolutePath());
        XMLFile.saveAs((File)configFile, (Object)new DbConfigFile());
        LOGGER.info("Successfully saved config.");
    }

    public static synchronized void loadConfig() throws Exception {
        File configFile = DbConfigFile.getConfigFile();
        LOGGER.info("Loading config from: " + configFile.getAbsolutePath());
        if (!configFile.exists()) {
            throw new FileNotFoundException("Config file does not exists. " + configFile.getAbsolutePath());
        }
        FileInputStream fis = new FileInputStream(configFile);
        DbConfigFile.loadConfig(fis);
    }

    public static synchronized void loadConfig(InputStream in) throws IOException {
        XMLFile.load((InputStream)in, DbConfigFile.class);
        StringBuffer allNames = new StringBuffer();
        all.forEach(cfg -> allNames.append(" ").append(cfg.name));
        LOGGER.info("Found: " + all.size() + " DB configurations: " + String.valueOf(allNames));
        DbConfigFile.loadAllDriverJars();
    }

    private static void loadAllDriverJars() {
        if (driverJarPaths == null || driverJarPaths.isEmpty()) {
            LOGGER.info("No driver JAR paths configured");
            return;
        }
        LOGGER.info("Loading " + driverJarPaths.size() + " driver JAR(s) from configuration...");
        for (String jarPath : driverJarPaths) {
            try {
                File jarFile = new File(jarPath);
                if (!jarFile.exists()) {
                    LOGGER.warning("Driver JAR file not found: " + jarPath);
                    continue;
                }
                DbConfigFile.loadDriverJar(jarFile);
                LOGGER.info("Successfully loaded driver JAR: " + jarFile.getName());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to load driver JAR: " + jarPath, ex);
            }
        }
    }

    private static void loadDriverJar(File jarFile) throws Exception {
        try {
            Class<?> driverConfigPanelClass = Class.forName("net.hironico.minisql.ui.config.DriverConfigPanel");
            Method method = driverConfigPanelClass.getDeclaredMethod("loadDriverJarStatic", File.class);
            method.setAccessible(true);
            method.invoke(null, jarFile);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("DriverConfigPanel class not found, cannot load driver JARs");
            throw e;
        }
    }

    public static interface DbConfigFileListener {
        public void configAdded(DbConfig var1);

        public void configRemoved(DbConfig var1);
    }
}

