/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ctrl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLObjectTypeEnum;

public class ObjectListCallable
implements Callable<List<String[]>>,
Supplier<List<String[]>> {
    private static final Logger LOGGER = Logger.getLogger(ObjectListCallable.class.getName());
    private final String schemaName;
    private final DbConfig configToUse;
    private final SQLObjectTypeEnum objectFilter;

    public ObjectListCallable(DbConfig configToUse, String schemaName) {
        this(configToUse, schemaName, null);
    }

    public ObjectListCallable(DbConfig configToUse, String schemaName, SQLObjectTypeEnum objectFilter) {
        this.configToUse = configToUse;
        this.schemaName = schemaName;
        this.objectFilter = objectFilter;
    }

    private void getTablesMetaData(DatabaseMetaData metaData, List<String[]> result) throws SQLException {
        List<String> types = this.getTableTypesNames(metaData);
        ResultSet rs = metaData.getTables(null, this.schemaName, null, types == null ? null : types.toArray(new String[0]));
        while (rs.next()) {
            CharSequence[] row = new String[]{rs.getString(2), rs.getString(3), rs.getString(4)};
            LOGGER.fine("Table found: " + String.join((CharSequence)" ; ", row));
            result.add((String[])row);
        }
        rs.close();
    }

    private List<String> getTableTypesNames(DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        if (this.objectFilter == null) {
            return null;
        }
        ResultSet rsTypes = metaData.getTableTypes();
        String objectFilterStr = this.objectFilter.toString();
        while (rsTypes.next()) {
            String theType = rsTypes.getString(1).toUpperCase();
            if (!theType.contains(objectFilterStr)) continue;
            types.add(theType);
        }
        rsTypes.close();
        return types;
    }

    private void getProceduresMetaData(DatabaseMetaData metaData, List<String[]> result) throws SQLException {
        ResultSet rs = metaData.getProcedures(null, this.schemaName, null);
        while (rs.next()) {
            CharSequence[] row = new String[]{rs.getString(2), rs.getString(3), SQLObjectTypeEnum.PROCEDURE.toString()};
            LOGGER.fine("Procedure found: " + String.join((CharSequence)" ; ", row));
            result.add((String[])row);
        }
        rs.close();
    }

    private void getSequencesMetaData(Connection con, List<String[]> result) throws SQLException {
        if (this.configToUse.jdbcUrl.contains("oracle")) {
            LOGGER.info("Loading sequences ...");
            String sql = String.format("SELECT s.sequence_name FROM all_sequences s WHERE s.sequence_owner = '%s' ORDER BY s.sequence_name", this.schemaName);
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                CharSequence[] row = new String[]{this.schemaName, rs.getString(1), SQLObjectTypeEnum.SEQUENCE.toString()};
                LOGGER.fine("Sequence found: " + String.join((CharSequence)" ; ", row));
                result.add((String[])row);
            }
        }
    }

    private void getEnumsMetaData(Connection con, List<String[]> result) throws SQLException {
        if (this.configToUse.jdbcUrl.contains("postgres")) {
            LOGGER.info("Loading enums ...");
            String sql = null;
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("net/hironico/minisql/metadata/postgresql/pg_get_enums.sql");){
                assert (is != null);
                sql = new String(is.readAllBytes());
                sql = sql.replace("?SCHEMA?", this.schemaName);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Cannot load the postgresql query for listing enums.", ex);
            }
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                CharSequence[] row = new String[]{this.schemaName, rs.getString(1), SQLObjectTypeEnum.ENUM.toString()};
                LOGGER.fine("Enum found: " + String.join((CharSequence)" ; ", row));
                result.add((String[])row);
            }
        }
    }

    private void getFunctionsMetaData(Connection con, List<String[]> result) throws SQLException {
        if (this.configToUse.jdbcUrl.contains("postgres")) {
            LOGGER.fine("Loading Postgresql functions...");
            String sql = null;
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("net/hironico/minisql/metadata/postgresql/pg_get_functions.sql");){
                assert (is != null);
                sql = new String(is.readAllBytes());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Cannot load the postgresql query for listing functions.", ex);
            }
            if (sql != null) {
                Statement stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    if (!rs.getString("schema").equalsIgnoreCase(this.schemaName)) continue;
                    CharSequence[] row = new String[]{this.schemaName, rs.getString("name"), SQLObjectTypeEnum.FUNCTION.toString()};
                    LOGGER.fine("Function found: " + String.join((CharSequence)" ; ", row));
                    result.add((String[])row);
                }
            }
        }
    }

    @Override
    public List<String[]> call() {
        if (this.schemaName == null) {
            LOGGER.severe("Cannot get object list for null schema.");
            return null;
        }
        if (this.configToUse == null) {
            LOGGER.severe("Config to use is null. Cannot get object list.");
            return null;
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        try (Connection con = this.configToUse.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            if (this.objectFilter == null || SQLObjectTypeEnum.isTableOrView(this.objectFilter) || this.objectFilter == SQLObjectTypeEnum.SEQUENCE) {
                this.getTablesMetaData(metaData, result);
            }
            if (this.objectFilter == null || this.objectFilter == SQLObjectTypeEnum.PROCEDURE) {
                this.getProceduresMetaData(metaData, result);
            }
            if (this.objectFilter == null || this.objectFilter == SQLObjectTypeEnum.SEQUENCE) {
                this.getSequencesMetaData(con, result);
            }
            if (this.objectFilter == null || this.objectFilter == SQLObjectTypeEnum.FUNCTION) {
                this.getFunctionsMetaData(con, result);
            }
            if (this.objectFilter == null || this.objectFilter == SQLObjectTypeEnum.ENUM) {
                this.getEnumsMetaData(con, result);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Error while getting the object list.", t);
            String[] row = new String[]{"Error while getting the object list. See log.", t.getMessage(), ""};
            result.add(row);
        }
        return result;
    }

    @Override
    public List<String[]> get() {
        return this.call();
    }
}

