/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLColumn;
import net.hironico.minisql.model.SQLObject;
import net.hironico.minisql.model.SQLObjectTypeEnum;
import net.hironico.minisql.model.SQLTableForeignKey;

public class SQLTable
extends SQLObject {
    private static final Logger LOGGER = Logger.getLogger(SQLTable.class.getName());
    protected final List<SQLColumn> columns = new ArrayList<SQLColumn>();
    protected final Map<String, List<SQLTableForeignKey>> foreignKeys = new HashMap<String, List<SQLTableForeignKey>>();

    public SQLTable(String schema, String name) {
        this.name = name;
        this.schemaName = schema;
        this.type = SQLObjectTypeEnum.TABLE;
    }

    public List<SQLColumn> getColumns() {
        return this.columns;
    }

    public Map<String, List<SQLTableForeignKey>> getForeignKeys() {
        return this.foreignKeys;
    }

    public String getDDLAddColumn(SQLColumn col) {
        String sql = "ALTER TABLE %s.%s ADD %s %s %s %s";
        String nullable = col.nullable != false ? "NULL" : "NOT NULL";
        String defaultValue = col.defaultValue != null && !"".equals(col.defaultValue) ? "DEFAULT " + col.defaultValue : "";
        Object typeName = SQLTable.getCompatibleType(col);
        if (col.size != null && !col.typeName.startsWith("TIME") && !col.typeName.startsWith("DATE")) {
            typeName = (String)typeName + "(" + col.size;
            typeName = col.scale != null && !col.typeName.contains("CHAR") ? (String)typeName + ", " + col.scale + ") " : (String)typeName + ") ";
        }
        return String.format(sql, this.schemaName, this.name, col.name, typeName, nullable, defaultValue);
    }

    public boolean addColumn(SQLColumn col, DbConfig dbConfig) {
        if (col == null || dbConfig == null) {
            return false;
        }
        String sql = this.getDDLAddColumn(col);
        try {
            LOGGER.info("Executing: " + sql);
            return this.executeUpdate(sql, dbConfig) > 0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Problem while adding column.", ex);
            return false;
        }
    }

    private String getDDLDropColumn(SQLColumn col) {
        String sql = "ALTER TABLE %s.%s DROP %s";
        return String.format(sql, this.schemaName, this.name, col.name);
    }

    public boolean dropColumn(SQLColumn col, DbConfig dbConfig) {
        if (col == null || dbConfig == null) {
            return false;
        }
        String sql = this.getDDLDropColumn(col);
        try {
            return this.executeUpdate(sql, dbConfig) > 0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Problem while dropping column.", ex);
            return false;
        }
    }

    private String getDDLRenameColumn(SQLColumn source, String newName) {
        String sql = "ALTER TABLE %s.%s RENAME %s TO %s";
        return String.format(sql, this.schemaName, this.name, source.name, newName);
    }

    public boolean renameColumn(SQLColumn source, String newName, DbConfig dbConfig) {
        if (source == null || newName == null || "".equals(newName) || dbConfig == null) {
            return false;
        }
        String sql = this.getDDLRenameColumn(source, newName);
        try {
            return this.executeUpdate(sql, dbConfig) > 0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Problem while renaming column " + source.name + " -> " + newName, ex);
            return false;
        }
    }

    private String getDDLColumnCopy(SQLColumn source, SQLColumn target) {
        String sql = "UPDATE %s.%s SET %s = %s";
        return String.format(sql, this.schemaName, this.name, target.name, source.name);
    }

    public boolean columnCopy(SQLColumn source, SQLColumn target, DbConfig dbConfig) {
        if (source == null || target == null || dbConfig == null) {
            return false;
        }
        String sql = this.getDDLColumnCopy(source, target);
        try {
            return this.executeUpdate(sql, dbConfig) > 0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Problem while copying data to column " + String.valueOf(source) + " -> " + String.valueOf(target), ex);
            return false;
        }
    }

    @Override
    public String getDDLDrop() {
        return String.format("DROP TABLE %s.%s", this.schemaName, this.name);
    }

    public boolean drop(DbConfig dbConfig) {
        String sql = this.getDDLDrop();
        LOGGER.warning(sql);
        try {
            return this.executeUpdate(sql, dbConfig) > 0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Problem while dropping table.", ex);
            return false;
        }
    }

    @Override
    public String getDDLCreate() {
        Object sql = "CREATE TABLE %s.%s (\n";
        sql = String.format((String)sql, this.schemaName, this.name);
        int index = 0;
        for (SQLColumn col : this.columns) {
            col.typeName = SQLTable.getCompatibleType(col);
            Object colStr = String.format("%s %s", col.name, col.typeName);
            if (index > 0) {
                colStr = ",\n    " + (String)colStr;
            }
            if (col.size != null && !col.typeName.startsWith("TIME") && !col.typeName.startsWith("DATE")) {
                colStr = (String)colStr + "(" + col.size;
                colStr = col.scale != null && !col.typeName.contains("CHAR") ? (String)colStr + ", " + col.scale + ") " : (String)colStr + ") ";
            }
            colStr = (String)colStr + (col.nullable != false ? " NULL " : " NOT NULL");
            if (col.defaultValue != null && !"".equals(col.defaultValue)) {
                colStr = (String)colStr + " DEFAULT " + col.defaultValue;
            }
            sql = (String)sql + (String)colStr;
            ++index;
        }
        sql = (String)sql + ")";
        return sql;
    }

    public boolean create(DbConfig dbConfig) {
        if (this.columns.isEmpty()) {
            LOGGER.severe(String.format("Cannot create table %s.%s since the columns are undefined or empty.", this.schemaName, this.name));
            return false;
        }
        String sql = this.getDDLCreate();
        LOGGER.warning(sql);
        try {
            this.executeUpdate(sql, dbConfig);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Problem while creating table.", ex);
            return false;
        }
        return true;
    }

    public void alterColumn(SQLColumn target, DbConfig dbConfig) throws SQLException {
        Object sql = "ALTER TABLE %s MODIFY %s %s";
        if (target.defaultValue != null && !"".equals(target.defaultValue)) {
            sql = (String)sql + " DEFAULT " + target.defaultValue;
        }
        sql = (String)sql + (target.nullable != false ? " NULL " : " NOT NULL ");
        sql = String.format((String)sql, this.name, target.name, SQLTable.getCompatibleType(target));
        LOGGER.warning((String)sql);
        try (Connection con = dbConfig.getConnection();
             Statement stmt = con.createStatement();){
            stmt.executeUpdate((String)sql);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        this.loadMetaData(dbConfig);
    }

    public void loadMetaData(DbConfig dbConfig) throws SQLException {
        try (Connection con = dbConfig.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            this.loadColumnsMetaData(metaData);
            this.loadForeignKey(metaData);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public void loadColumnsMetaData(DatabaseMetaData metaData) throws SQLException, IOException {
        this.columns.clear();
        try (ResultSet resultSet = metaData.getColumns(null, this.schemaName, this.name, null);
             ResultSet resultSetPK = metaData.getPrimaryKeys(null, this.schemaName, this.name);){
            HashSet<String> pkColumnNames = new HashSet<String>();
            while (resultSetPK.next()) {
                String columnName = resultSetPK.getString("COLUMN_NAME");
                pkColumnNames.add(columnName);
            }
            while (resultSet.next()) {
                SQLColumn column = new SQLColumn();
                column.name = resultSet.getString(4);
                column.typeName = resultSet.getString(6);
                column.size = resultSet.getInt(7);
                column.scale = resultSet.getInt(9);
                column.defaultValue = "";
                Reader reader = resultSet.getCharacterStream(13);
                if (reader != null) {
                    BufferedReader bufReader = new BufferedReader(reader);
                    String line = bufReader.readLine();
                    while (line != null) {
                        column.defaultValue = column.defaultValue + line + "\n";
                        line = bufReader.readLine();
                    }
                    reader.close();
                }
                column.nullable = "YES".equalsIgnoreCase(resultSet.getString(18));
                column.autoIncrement = "YES".equalsIgnoreCase(resultSet.getString(23));
                column.isPrimaryKey = pkColumnNames.contains(column.name);
                this.columns.add(column);
            }
        }
    }

    public void loadForeignKey(DatabaseMetaData metaData) throws SQLException {
        ResultSet rsFK = metaData.getImportedKeys(null, this.schemaName, this.name);
        while (rsFK.next()) {
            String fkName = rsFK.getString("FK_NAME");
            if (fkName == null) {
                fkName = String.join((CharSequence)"_", rsFK.getString("PKTABLE_NAME"), rsFK.getString("FKTABLE_NAME"));
            }
            SQLTableForeignKey fk = new SQLTableForeignKey(fkName);
            fk.fkSchemaName = rsFK.getString("FKTABLE_SCHEM");
            fk.fkTableName = rsFK.getString("FKTABLE_NAME");
            fk.fkColumnName = rsFK.getString("FKCOLUMN_NAME");
            fk.pkSchemaName = rsFK.getString("PKTABLE_SCHEM");
            fk.pkTableName = rsFK.getString("PKTABLE_NAME");
            fk.pkColumnName = rsFK.getString("PKCOLUMN_NAME");
            fk.deleteRule = rsFK.getString("DELETE_RULE");
            fk.updateRule = rsFK.getString("UPDATE_RULE");
            fk.kewSeq = rsFK.getInt("KEY_SEQ");
            List fkList = this.foreignKeys.getOrDefault(fk.name, new ArrayList());
            this.foreignKeys.putIfAbsent(fk.name, fkList);
            fkList.add(fk);
        }
        rsFK.close();
    }
}

