/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.parser.postgresql;

import java.util.List;
import net.hironico.minisql.parser.postgresql.LexerDispatchingErrorListener;
import net.hironico.minisql.parser.postgresql.ParserDispatchingErrorListener;
import net.hironico.minisql.parser.postgresql.PostgreSQLLexer;
import net.hironico.minisql.parser.postgresql.PostgreSQLParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class PostgreSQLParserBase
extends Parser {
    public PostgreSQLParserBase(TokenStream input) {
        super(input);
    }

    ParserRuleContext GetParsedSqlTree(String script, int line) {
        PostgreSQLParser ph = this.getPostgreSQLParser(script);
        PostgreSQLParser.RootContext result = ph.root();
        return result;
    }

    public void ParseRoutineBody(PostgreSQLParser.Createfunc_opt_listContext _localctx) {
        String lang = null;
        for (Object coi : _localctx.createfunc_opt_item()) {
            if (coi.LANGUAGE() == null || coi.nonreservedword_or_sconst() == null || coi.nonreservedword_or_sconst().nonreservedword() == null || coi.nonreservedword_or_sconst().nonreservedword().identifier() == null || coi.nonreservedword_or_sconst().nonreservedword().identifier().Identifier() == null) continue;
            lang = coi.nonreservedword_or_sconst().nonreservedword().identifier().Identifier().getText();
            break;
        }
        if (null == lang) {
            return;
        }
        PostgreSQLParser.Createfunc_opt_itemContext func_as = null;
        for (PostgreSQLParser.Createfunc_opt_itemContext a : _localctx.createfunc_opt_item()) {
            if (a.func_as() == null) continue;
            func_as = a;
            break;
        }
        if (func_as != null) {
            String txt = this.GetRoutineBodyString(func_as.func_as().sconst(0));
            PostgreSQLParser ph = this.getPostgreSQLParser(txt);
            switch (lang) {
                case "plpgsql": {
                    func_as.func_as().Definition = ph.plsqlroot();
                    break;
                }
                case "sql": {
                    func_as.func_as().Definition = ph.root();
                }
            }
        }
    }

    private String TrimQuotes(String s) {
        return s == null || s.isEmpty() ? s : s.substring(1, s.length() - 1);
    }

    public String unquote(String s) {
        int slength = s.length();
        StringBuilder r = new StringBuilder(slength);
        for (int i = 0; i < slength; ++i) {
            Character c = Character.valueOf(s.charAt(i));
            r.append(c);
            if (c.charValue() != '\'' || i >= slength - 1 || s.charAt(i + 1) != '\'') continue;
            ++i;
        }
        return r.toString();
    }

    public String GetRoutineBodyString(PostgreSQLParser.SconstContext rule) {
        PostgreSQLParser.AnysconstContext anysconst = rule.anysconst();
        TerminalNode StringConstant = anysconst.StringConstant();
        if (null != StringConstant) {
            return this.unquote(this.TrimQuotes(StringConstant.getText()));
        }
        TerminalNode UnicodeEscapeStringConstant = anysconst.UnicodeEscapeStringConstant();
        if (null != UnicodeEscapeStringConstant) {
            return this.TrimQuotes(UnicodeEscapeStringConstant.getText());
        }
        TerminalNode EscapeStringConstant = anysconst.EscapeStringConstant();
        if (null != EscapeStringConstant) {
            return this.TrimQuotes(EscapeStringConstant.getText());
        }
        Object result = "";
        List<TerminalNode> dollartext = anysconst.DollarText();
        for (TerminalNode s : dollartext) {
            result = (String)result + s.getText();
        }
        return result;
    }

    public PostgreSQLParser getPostgreSQLParser(String script) {
        CodePointCharStream charStream = CharStreams.fromString((String)script);
        PostgreSQLLexer lexer = new PostgreSQLLexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PostgreSQLParser parser = new PostgreSQLParser((TokenStream)tokens);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        LexerDispatchingErrorListener listener_lexer = new LexerDispatchingErrorListener((Lexer)((CommonTokenStream)this.getInputStream()).getTokenSource());
        ParserDispatchingErrorListener listener_parser = new ParserDispatchingErrorListener(this);
        lexer.addErrorListener(listener_lexer);
        parser.addErrorListener(listener_parser);
        return parser;
    }
}

