/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import net.hironico.common.swing.JSplitPaneNoDivider;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;
import net.hironico.common.swing.ribbon.Ribbon;
import net.hironico.common.swing.ribbon.RibbonGroup;
import net.hironico.common.swing.ribbon.RibbonTab;
import net.hironico.common.swing.ribbon.RibbonWindowUI;
import net.hironico.common.swing.tabbedpane.CloseableTabComponent;
import net.hironico.common.swing.tabbedpane.JTabbedPaneNoContentSeparator;
import net.hironico.minisql.App;
import net.hironico.minisql.DbConfigFile;
import net.hironico.minisql.ui.ExitAction;
import net.hironico.minisql.ui.ShowLogAction;
import net.hironico.minisql.ui.ShowQueryPanelAction;
import net.hironico.minisql.ui.batch.BatchPanel;
import net.hironico.minisql.ui.batch.action.NewBatchAction;
import net.hironico.minisql.ui.batch.ribbon.BatchRibbonTab;
import net.hironico.minisql.ui.config.ShowConfigPanelAction;
import net.hironico.minisql.ui.dbexplorer.SchemaExplorerPanel;
import net.hironico.minisql.ui.dbexplorer.ribbon.DbExplorerRibbonTab;
import net.hironico.minisql.ui.editor.QueryPanel;
import net.hironico.minisql.ui.editor.ribbon.EditorRibbonTab;
import net.hironico.minisql.ui.editor.ribbon.FileRibbonGroup;
import net.hironico.minisql.ui.history.QueryHistoryPanel;
import net.hironico.minisql.ui.visualdb.VisualDbPanel;
import net.hironico.minisql.ui.visualdb.action.NewVisualDbTabAction;
import net.hironico.minisql.ui.visualdb.ribbon.VisualDbRibbonTab;

public class MainWindow
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(MainWindow.class.getName());
    public static final ExecutorService executorService = Executors.newFixedThreadPool(4);
    public static final Map<String, AbstractRibbonAction> appActions = new HashMap<String, AbstractRibbonAction>();
    private static final MainWindow instance = new MainWindow();
    private Ribbon ribbon = null;
    private RibbonTab homeRibbonTab = null;
    private RibbonTab editorRibbonTab = null;
    private RibbonGroup fileRibbonGroup = null;
    private RibbonGroup systemRibbonGroup = null;
    private RibbonGroup toolsRibbonGroup = null;
    private RibbonTab explorerRibbonTab = null;
    private RibbonTab visualDbRibbonTab = null;
    private RibbonTab batchRibbonTab = null;
    private JSplitPaneNoDivider splitMain = null;
    private JTabbedPaneNoContentSeparator tabExplorer = null;
    private SchemaExplorerPanel schemaExplorerPanel = null;
    private JTabbedPaneNoContentSeparator tabEditors = null;
    private JSplitPaneNoDivider splitEditor = null;
    private JTabbedPaneNoContentSeparator tabTools = null;
    private QueryHistoryPanel pnlHistory = null;
    private JPanel pnlStatusBar = null;
    private JLabel lblConnectionStatus = null;

    private MainWindow() {
        super("MiniSQL");
        this.initActions();
        this.initialize();
    }

    public static MainWindow getInstance() {
        return instance;
    }

    private void initialize() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MainWindow.this.setSplitSizes();
            }
        });
        this.addWindowStateListener(evt -> {
            int state = evt.getNewState();
            if ((state & 6) == 6) {
                this.setSplitSizes();
            } else if ((state & 2) != 0) {
                this.setSplitSizes();
            }
        });
        this.setMinimumSize(new Dimension(1024, 768));
        this.setPreferredSize(new Dimension(1280, 1024));
        this.setExtendedState(6);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                try {
                    LOGGER.info("Saving config file...");
                    DbConfigFile.saveConfig();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Unable to save config file.", ex);
                }
                System.exit(0);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        if (DbConfigFile.getInstance().getDecoratedWindow().booleanValue()) {
            this.setUndecorated(true);
            this.getRootPane().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.WHITE));
            RibbonWindowUI ribbonWinUI = new RibbonWindowUI();
            JLayer<Ribbon> ribbonWithWinIcons = new JLayer<Ribbon>(this.getRibbon(), (LayerUI<Ribbon>)ribbonWinUI);
            ribbonWithWinIcons.setLayerEventMask(48L);
            this.getContentPane().add(ribbonWithWinIcons, "First");
        } else {
            this.getContentPane().add((Component)this.getRibbon(), "First");
        }
        this.getContentPane().add((Component)this.getSplitMain(), "Center");
        this.getContentPane().add((Component)this.getStatusBar(), "Last");
    }

    private void setSplitSizes() {
        SwingUtilities.invokeLater(() -> {
            try {
                Thread.sleep(50L);
                Dimension size = MainWindow.getInstance().getSize();
                this.getSplitMain().setDividerLocation(size.width / 4);
                size = this.getSplitMain().getRightComponent().getSize();
                this.getSplitEditor().setDividerLocation(size.width * 5 / 6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void addAction(AbstractRibbonAction action) {
        if (action.getValue("Name") == null) {
            LOGGER.warning("Action has no name: " + action.getClass().getName());
        } else if (appActions.get((String)action.getValue("Name")) != null) {
            LOGGER.warning("There is already an action named: " + String.valueOf(action.getValue("Name")) + " defined.");
        } else {
            appActions.put((String)action.getValue("Name"), action);
        }
    }

    private void initActions() {
        appActions.clear();
        this.addAction(new ShowConfigPanelAction());
        this.addAction(new ExitAction());
        this.addAction(new ShowQueryPanelAction());
    }

    public Ribbon getRibbon() {
        if (this.ribbon == null) {
            this.ribbon = new Ribbon();
            this.ribbon.setOpaque(true);
            this.ribbon.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
            this.ribbon.addRibbonTab(this.getHomeRibbonTab());
            this.ribbon.addRibbonTab(this.getExplorerRibbonTab());
            this.ribbon.addRibbonTab(this.getEditorRibbonTab());
            this.ribbon.addRibbonTab(this.getVisualDbRibbonTab());
            this.ribbon.addRibbonTab(this.getBatchRibbonTab());
        }
        return this.ribbon;
    }

    private RibbonTab getExplorerRibbonTab() {
        if (this.explorerRibbonTab == null) {
            this.explorerRibbonTab = new DbExplorerRibbonTab();
        }
        return this.explorerRibbonTab;
    }

    private RibbonTab getVisualDbRibbonTab() {
        if (this.visualDbRibbonTab == null) {
            this.visualDbRibbonTab = new VisualDbRibbonTab();
        }
        return this.visualDbRibbonTab;
    }

    private RibbonTab getHomeRibbonTab() {
        if (this.homeRibbonTab == null) {
            this.homeRibbonTab = new RibbonTab("Home");
            this.homeRibbonTab.addGroup(this.getFileRibbonGroup());
            this.homeRibbonTab.addGroup(this.getToolsRibbonGroup());
            this.homeRibbonTab.addGroup(this.getSystemRibbonGroup());
        }
        return this.homeRibbonTab;
    }

    private RibbonTab getEditorRibbonTab() {
        if (this.editorRibbonTab == null) {
            this.editorRibbonTab = new EditorRibbonTab();
        }
        return this.editorRibbonTab;
    }

    private RibbonTab getBatchRibbonTab() {
        if (this.batchRibbonTab == null) {
            this.batchRibbonTab = new BatchRibbonTab();
        }
        return this.batchRibbonTab;
    }

    private RibbonGroup getFileRibbonGroup() {
        if (this.fileRibbonGroup == null) {
            this.fileRibbonGroup = new FileRibbonGroup();
        }
        return this.fileRibbonGroup;
    }

    private RibbonGroup getToolsRibbonGroup() {
        if (this.toolsRibbonGroup == null) {
            this.toolsRibbonGroup = new RibbonGroup("Tools");
            this.toolsRibbonGroup.addButton((AbstractRibbonAction)new NewVisualDbTabAction(), 3);
            this.toolsRibbonGroup.addButton((AbstractRibbonAction)new NewBatchAction(), 3);
        }
        return this.toolsRibbonGroup;
    }

    private RibbonGroup getSystemRibbonGroup() {
        if (this.systemRibbonGroup == null) {
            this.systemRibbonGroup = new RibbonGroup("System");
            this.systemRibbonGroup.addButton(appActions.get("Config"), 3);
            this.systemRibbonGroup.addButton((AbstractRibbonAction)new ShowLogAction(), 3);
            this.systemRibbonGroup.addButton(appActions.get("Exit"), 3);
        }
        return this.systemRibbonGroup;
    }

    private JPanel getStatusBar() {
        if (this.pnlStatusBar == null) {
            this.pnlStatusBar = new JPanel();
            this.pnlStatusBar.setOpaque(true);
            this.pnlStatusBar.setBackground(Color.WHITE);
            this.pnlStatusBar.setLayout(new BorderLayout());
            this.pnlStatusBar.add((Component)this.getLblConnectionStatus(), "West");
            this.pnlStatusBar.add((Component)new JLabel("version " + App.getVersion()), "East");
        }
        return this.pnlStatusBar;
    }

    private JLabel getLblConnectionStatus() {
        if (this.lblConnectionStatus == null) {
            this.lblConnectionStatus = new JLabel();
            this.lblConnectionStatus.setText("Welcome to MiniSQL by Hironico.com");
        }
        return this.lblConnectionStatus;
    }

    private JSplitPaneNoDivider getSplitMain() {
        if (this.splitMain == null) {
            this.splitMain = new JSplitPaneNoDivider();
            this.splitMain.setLeftComponent((Component)this.getTabExplorer());
            this.splitMain.setRightComponent((Component)this.getSplitEditor());
            this.splitMain.setDividerSize(7);
            this.splitMain.setDividerLocation(0.15);
            this.splitMain.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.splitMain;
    }

    private JTabbedPaneNoContentSeparator getTabExplorer() {
        if (this.tabExplorer == null) {
            this.tabExplorer = new JTabbedPaneNoContentSeparator();
            this.tabExplorer.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.tabExplorer.addTab("Explorer", (Component)((Object)this.getSchemaExplorerPanel()));
        }
        return this.tabExplorer;
    }

    public SchemaExplorerPanel getSchemaExplorerPanel() {
        if (this.schemaExplorerPanel == null) {
            this.schemaExplorerPanel = new SchemaExplorerPanel();
        }
        return this.schemaExplorerPanel;
    }

    private JSplitPaneNoDivider getSplitEditor() {
        if (this.splitEditor == null) {
            this.splitEditor = new JSplitPaneNoDivider();
            this.splitEditor.setLeftComponent((Component)this.getTabEditors());
            this.splitEditor.setRightComponent((Component)this.getTabTools());
            this.splitEditor.setDividerSize(7);
            this.splitEditor.setDividerLocation(0.75);
            this.splitEditor.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.splitEditor;
    }

    private JTabbedPaneNoContentSeparator getTabTools() {
        if (this.tabTools == null) {
            this.tabTools = new JTabbedPaneNoContentSeparator();
            this.tabTools.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            this.tabTools.addTab("History", (Component)((Object)this.getPnlHistory()));
        }
        return this.tabTools;
    }

    private QueryHistoryPanel getPnlHistory() {
        if (this.pnlHistory == null) {
            this.pnlHistory = new QueryHistoryPanel();
        }
        return this.pnlHistory;
    }

    private JTabbedPaneNoContentSeparator getTabEditors() {
        if (this.tabEditors == null) {
            this.tabEditors = new JTabbedPaneNoContentSeparator();
            this.tabEditors.addTab("SQL query", (Component)((Object)new QueryPanel()));
            this.tabEditors.addChangeListener(evt -> {
                Component comp = this.tabEditors.getWrappedSelectedComponent();
                if (comp instanceof QueryPanel) {
                    QueryPanel queryPanel = (QueryPanel)((Object)comp);
                    queryPanel.updateRibbon();
                }
                if (comp instanceof BatchPanel) {
                    BatchPanel batchPanel = (BatchPanel)((Object)((Object)comp));
                    batchPanel.updateRibbon();
                }
                if (comp instanceof VisualDbPanel) {
                    VisualDbPanel visualDbPanel = (VisualDbPanel)((Object)((Object)comp));
                    visualDbPanel.updateRibbon();
                }
            });
        }
        return this.tabEditors;
    }

    public boolean hasOneEditorNamed(String title) {
        for (int index = 0; index < this.getTabEditors().getTabCount(); ++index) {
            if (!title.equalsIgnoreCase(this.getTabEditors().getTitleAt(index))) continue;
            return true;
        }
        return false;
    }

    public void setSelectedEditor(String title) {
        for (int index = 0; index < this.getTabEditors().getTabCount(); ++index) {
            if (!title.equalsIgnoreCase(this.getTabEditors().getTitleAt(index))) continue;
            this.getTabEditors().setSelectedIndex(index);
            return;
        }
    }

    public void addNewEditorTab(JComponent comp, String title) {
        Runnable run = () -> {
            JTabbedPaneNoContentSeparator tabResults = this.getTabEditors();
            tabResults.addTab(title, (Component)comp);
            tabResults.setSelectedIndex(tabResults.getTabCount() - 1);
            tabResults.setTabComponentAt(tabResults.getTabCount() - 1, (Component)new CloseableTabComponent((JTabbedPane)tabResults, title));
            if (comp instanceof QueryPanel) {
                QueryPanel queryPanel = (QueryPanel)((Object)comp);
                queryPanel.updateRibbon();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void removeCurrentEditorTab() {
        int selectedIndex = this.getTabEditors().getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.getTabEditors().removeTabAt(selectedIndex);
    }

    public void setEditorTabTitle(JComponent comp, String title) {
        int count = this.getTabEditors().getTabCount();
        for (int index = 0; index < count; ++index) {
            Component myComp = this.getTabEditors().getComponentAt(index);
            if (!myComp.equals(comp)) continue;
            Component tc = this.getTabEditors().getTabComponentAt(index);
            CloseableTabComponent ctc = (CloseableTabComponent)tc;
            ctc.setTitle(title);
            return;
        }
    }

    public Component getCurrentEditorTabComponent() {
        return this.getTabEditors().getWrappedSelectedComponent();
    }

    public int getEditorTabIndexOf(String title, boolean autoSelect) {
        for (int index = 0; index < this.getTabEditors().getTabCount(); ++index) {
            if (!title.equals(this.getTabEditors().getTitleAt(index))) continue;
            if (autoSelect) {
                this.getTabEditors().setSelectedIndex(index);
            }
            return index;
        }
        return -1;
    }
}

