/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.tree.TreePath;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLResultSetTableModel;
import net.hironico.minisql.ui.batch.BatchFileNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

class BatchFileTreeTableModel
extends DefaultTreeTableModel {
    private static final Logger LOG = Logger.getLogger(BatchFileTreeTableModel.class.getName());
    private final Class<?>[] columnClasses = new Class[]{String.class, JButton.class, JButton.class, String.class, String.class};
    private DbConfig dbConfig = null;

    public BatchFileTreeTableModel() {
        super((TreeTableNode)new DefaultMutableTreeTableNode((Object)"ROOT"), Arrays.asList("FileName", "Edit", "Run", "Result", "Duration"));
    }

    public Class<?> getColumnClass(int col) {
        return this.columnClasses[col];
    }

    public boolean isCellEditable(Object node, int column) {
        DefaultMutableTreeTableNode treeNode = (DefaultMutableTreeTableNode)node;
        Object object = treeNode.getUserObject();
        if (!(object instanceof BatchFileNode)) {
            return false;
        }
        BatchFileNode fileNode = (BatchFileNode)object;
        if (fileNode.isDirectory()) {
            return false;
        }
        return column == 1 || column == 2;
    }

    public Object getValueAt(Object node, int col) {
        DefaultMutableTreeTableNode treeNode = (DefaultMutableTreeTableNode)node;
        Object object = treeNode.getUserObject();
        if (!(object instanceof BatchFileNode)) {
            return null;
        }
        BatchFileNode fileNode = (BatchFileNode)object;
        return switch (col) {
            case 0 -> fileNode.getFileName();
            case 1 -> {
                if (fileNode.isDirectory()) {
                    yield null;
                }
                yield "Edit";
            }
            case 2 -> {
                if (fileNode.isDirectory()) {
                    yield null;
                }
                yield "Run";
            }
            case 3 -> {
                if (fileNode.isDirectory()) {
                    yield "";
                }
                yield fileNode.getResult();
            }
            case 4 -> {
                if (fileNode.isDirectory()) {
                    yield "";
                }
                yield String.format("%d ms", fileNode.getDuration());
            }
            default -> null;
        };
    }

    public void setValueAt(Object value, Object node, int column) {
        DefaultMutableTreeTableNode treeNode = (DefaultMutableTreeTableNode)node;
        Object object = treeNode.getUserObject();
        if (!(object instanceof BatchFileNode)) {
            return;
        }
        BatchFileNode fileNode = (BatchFileNode)object;
        if (column == 3) {
            fileNode.setResult((String)value);
            ArrayList<DefaultMutableTreeTableNode> parentPath = new ArrayList<DefaultMutableTreeTableNode>();
            DefaultMutableTreeTableNode currentNode = treeNode;
            parentPath.add(0, currentNode);
            while (currentNode.getParent() != null) {
                currentNode = (DefaultMutableTreeTableNode)currentNode.getParent();
                parentPath.add(0, currentNode);
            }
            TreePath tp = new TreePath(parentPath);
            this.modelSupport.fireChildChanged(tp, column, node);
        }
    }

    public void clear() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        while (root.getChildCount() > 0) {
            this.removeNodeFromParent((MutableTreeTableNode)((DefaultMutableTreeTableNode)root.getChildAt(0)));
        }
    }

    public void resetResults() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeTableNode folderNode = (DefaultMutableTreeTableNode)root.getChildAt(i);
            for (int j = 0; j < folderNode.getChildCount(); ++j) {
                BatchFileNode batchFileNode;
                DefaultMutableTreeTableNode fileNode = (DefaultMutableTreeTableNode)folderNode.getChildAt(j);
                Object object = fileNode.getUserObject();
                if (!(object instanceof BatchFileNode) || (batchFileNode = (BatchFileNode)object).isDirectory()) continue;
                this.setValueAt("", fileNode, 3);
                this.setValueAt("", fileNode, 4);
                batchFileNode.setResult("");
                batchFileNode.setStarted(0L);
                batchFileNode.setEnded(0L);
            }
        }
    }

    public void addFile(File file) {
        DefaultMutableTreeTableNode dirNode = this.findFolderNode(file);
        BatchFileNode batchFileNode = new BatchFileNode(file);
        this.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)batchFileNode), (MutableTreeTableNode)dirNode, dirNode.getChildCount());
    }

    private DefaultMutableTreeTableNode findFolderNode(File file) {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        for (int index = 0; index < root.getChildCount(); ++index) {
            DefaultMutableTreeTableNode dirNode = (DefaultMutableTreeTableNode)root.getChildAt(index);
            BatchFileNode fileNode = (BatchFileNode)dirNode.getUserObject();
            if (!fileNode.getFile().equals(file.getParentFile())) continue;
            return dirNode;
        }
        DefaultMutableTreeTableNode dirNode = new DefaultMutableTreeTableNode();
        dirNode.setUserObject((Object)new BatchFileNode(file.getParentFile()));
        this.insertNodeInto((MutableTreeTableNode)dirNode, (MutableTreeTableNode)root, root.getChildCount());
        return dirNode;
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DbConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public void runAll() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeTableNode folderNode = (DefaultMutableTreeTableNode)root.getChildAt(i);
            for (int j = 0; j < folderNode.getChildCount(); ++j) {
                BatchFileNode batchFileNode;
                DefaultMutableTreeTableNode fileNode = (DefaultMutableTreeTableNode)folderNode.getChildAt(j);
                Object object = fileNode.getUserObject();
                if (!(object instanceof BatchFileNode) || (batchFileNode = (BatchFileNode)object).isDirectory()) continue;
                TreePath tp = new TreePath(this.getPathToRoot((TreeTableNode)fileNode));
                batchFileNode.setResult("Wait...");
                this.modelSupport.firePathChanged(tp);
                Future<List<SQLResultSetTableModel>> fut = batchFileNode.run(this.getDbConfig());
                this.updateWhenFinished(fut, batchFileNode, tp);
            }
        }
    }

    public void updateWhenFinished(Future<List<SQLResultSetTableModel>> fut, BatchFileNode batchFileNode, TreePath pathToRoot) {
        Thread thread = new Thread(() -> {
            try {
                if (fut != null) {
                    List results = (List)fut.get();
                    batchFileNode.setEnded(System.currentTimeMillis());
                    String strResult = String.format("OK. %d results.", results.size());
                    batchFileNode.setResult(strResult);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.log(Level.SEVERE, "ERROR while running batch of SQL:", e);
                batchFileNode.setResult(String.format("ERROR: %s", e.getMessage()));
            }
            finally {
                this.modelSupport.fireTreeStructureChanged(pathToRoot);
            }
        });
        thread.start();
    }
}

