/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.config;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.hironico.common.swing.JRoundedPanel;
import net.hironico.minisql.ui.config.DbConfigPanel;
import net.hironico.minisql.ui.config.DriverConfigPanel;
import net.hironico.minisql.ui.config.GeneralConfigPanel;
import org.jdesktop.swingx.JXTree;

public class ConfigPanel
extends JRoundedPanel {
    private JXTree treeMenu = null;
    private JScrollPane scrollMenu = null;
    private CardLayout cardLayout = null;
    private JPanel mainPanel = null;
    private final String CARD_GENERAL = "General";
    private final String CARD_CONNECTIONS = "Connections";
    private final String CARD_DRIVERS = "Drivers";
    private GeneralConfigPanel generalConfigPanel = null;
    private DbConfigPanel dbConfigPanel = null;
    private DriverConfigPanel driverConfigPanel = null;

    public ConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setBackground(JRoundedPanel.LIGHT_BLUE_COLOR);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 0));
        this.add(this.getScrollMenu(), "West");
        this.add(this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.cardLayout = new CardLayout(5, 5);
            this.mainPanel.setLayout(this.cardLayout);
            this.mainPanel.add((Component)this.getGeneralConfigPanel(), "General");
            this.mainPanel.add((Component)this.getDbConfigPanel(), "Connections");
            this.mainPanel.add((Component)this.getDriverConfigPanel(), "Drivers");
        }
        return this.mainPanel;
    }

    private JScrollPane getScrollMenu() {
        if (this.scrollMenu == null) {
            this.scrollMenu = new JScrollPane((Component)this.getTreeMenu());
        }
        return this.scrollMenu;
    }

    private JXTree getTreeMenu() {
        if (this.treeMenu == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            DefaultMutableTreeNode general = new DefaultMutableTreeNode("General");
            DefaultMutableTreeNode connections = new DefaultMutableTreeNode("Connections");
            DefaultMutableTreeNode drivers = new DefaultMutableTreeNode("Drivers");
            root.add(general);
            root.add(connections);
            root.add(drivers);
            this.treeMenu = new JXTree((TreeNode)root);
            this.treeMenu.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.treeMenu.setRootVisible(false);
            this.treeMenu.getSelectionModel().setSelectionPath(new TreePath(general.getPath()));
            this.treeMenu.addTreeSelectionListener(e -> {
                TreePath tp = this.getTreeMenu().getSelectionPath();
                if (tp == null) {
                    return;
                }
                if (this.cardLayout == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
                String cardName = (String)node.getUserObject();
                this.cardLayout.show(this.getMainPanel(), cardName);
            });
        }
        return this.treeMenu;
    }

    private GeneralConfigPanel getGeneralConfigPanel() {
        if (this.generalConfigPanel == null) {
            this.generalConfigPanel = new GeneralConfigPanel();
        }
        return this.generalConfigPanel;
    }

    private DbConfigPanel getDbConfigPanel() {
        if (this.dbConfigPanel == null) {
            this.dbConfigPanel = new DbConfigPanel();
        }
        return this.dbConfigPanel;
    }

    private DriverConfigPanel getDriverConfigPanel() {
        if (this.driverConfigPanel == null) {
            this.driverConfigPanel = new DriverConfigPanel();
        }
        return this.driverConfigPanel;
    }
}

