/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.hironico.minisql.DbConfigFile;

public class DriverConfigPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(DriverConfigPanel.class.getName());
    private static URLClassLoader driverClassLoader = null;
    private DefaultListModel<String> driverListModel;
    private JList<String> driverList;
    private JButton btnBrowse;
    private JButton btnRemove;
    private JButton btnAddToClasspath;
    private JLabel lblStatus;

    public DriverConfigPanel() {
        this.initialize();
        this.loadDriversFromConfig();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel titlePanel = new JPanel(new FlowLayout(0));
        JLabel lblTitle = new JLabel("JDBC Driver JAR Files");
        lblTitle.setFont(lblTitle.getFont().deriveFont(1, 14.0f));
        titlePanel.add(lblTitle);
        this.add((Component)titlePanel, "North");
        this.driverListModel = new DefaultListModel();
        this.driverList = new JList<String>(this.driverListModel);
        this.driverList.setSelectionMode(0);
        this.driverList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.driverList);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.btnBrowse = new JButton("Browse...");
        this.btnBrowse.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.btnBrowse.addActionListener(e -> this.browseForDriver());
        this.btnRemove = new JButton("Remove");
        this.btnRemove.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.btnRemove.addActionListener(e -> this.removeSelectedDriver());
        this.btnRemove.setEnabled(false);
        this.btnAddToClasspath = new JButton("Add to Classpath");
        this.btnAddToClasspath.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.btnAddToClasspath.addActionListener(e -> this.addSelectedToClasspath());
        this.btnAddToClasspath.setEnabled(false);
        buttonPanel.add(this.btnBrowse);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(this.btnRemove);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(this.btnAddToClasspath);
        buttonPanel.add(Box.createVerticalGlue());
        this.add((Component)buttonPanel, "East");
        JPanel statusPanel = new JPanel(new FlowLayout(0));
        this.lblStatus = new JLabel(" ");
        this.lblStatus.setForeground(Color.BLUE);
        statusPanel.add(this.lblStatus);
        this.add((Component)statusPanel, "South");
        this.driverList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean hasSelection = !this.driverList.isSelectionEmpty();
                this.btnRemove.setEnabled(hasSelection);
                this.btnAddToClasspath.setEnabled(hasSelection);
            }
        });
    }

    private void loadDriversFromConfig() {
        this.driverListModel.clear();
        List<String> drivers = DbConfigFile.getInstance().getDriverJarPaths();
        if (drivers != null) {
            for (String driver : drivers) {
                this.driverListModel.addElement(driver);
            }
        }
    }

    private void browseForDriver() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select JDBC Driver JAR File");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JAR Files (*.jar)", "jar");
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(this) == 0) {
            File[] selectedFiles;
            for (File file : selectedFiles = chooser.getSelectedFiles()) {
                String path = file.getAbsolutePath();
                if (!this.driverListModel.contains(path)) {
                    this.driverListModel.addElement(path);
                    DbConfigFile.getInstance().addDriverJarPath(path);
                    this.setStatus("Added: " + file.getName());
                    LOGGER.info("Added driver JAR: " + path);
                    continue;
                }
                this.setStatus("Already in list: " + file.getName());
            }
            try {
                DbConfigFile.saveConfig();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to save configuration", ex);
                this.setStatus("Error saving configuration", Color.RED);
            }
        }
    }

    private void removeSelectedDriver() {
        int result;
        String selectedDriver = this.driverList.getSelectedValue();
        if (selectedDriver != null && (result = JOptionPane.showConfirmDialog(this, "Remove driver from configuration?\n" + selectedDriver, "Confirm Removal", 0)) == 0) {
            this.driverListModel.removeElement(selectedDriver);
            DbConfigFile.getInstance().removeDriverJarPath(selectedDriver);
            this.setStatus("Removed: " + new File(selectedDriver).getName());
            LOGGER.info("Removed driver JAR: " + selectedDriver);
            try {
                DbConfigFile.saveConfig();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to save configuration", ex);
                this.setStatus("Error saving configuration", Color.RED);
            }
        }
    }

    private void addSelectedToClasspath() {
        String selectedDriver = this.driverList.getSelectedValue();
        if (selectedDriver != null) {
            File jarFile = new File(selectedDriver);
            if (!jarFile.exists()) {
                this.setStatus("File not found: " + jarFile.getName(), Color.RED);
                JOptionPane.showMessageDialog(this, "JAR file not found:\n" + selectedDriver, "File Not Found", 0);
                return;
            }
            try {
                this.addJarToClasspath(jarFile);
                this.setStatus("Successfully added to classpath: " + jarFile.getName(), new Color(0, 128, 0));
                LOGGER.info("Added to classpath: " + selectedDriver);
                JOptionPane.showMessageDialog(this, "Driver JAR successfully added to classpath:\n" + jarFile.getName() + "\n\nNote: The driver will be available for new connections.", "Success", 1);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to add JAR to classpath", ex);
                this.setStatus("Error loading JAR: " + ex.getMessage(), Color.RED);
                JOptionPane.showMessageDialog(this, "Failed to add JAR to classpath:\n" + ex.getMessage(), "Error", 0);
            }
        }
    }

    private static void loadDriverJarStatic(File jarFile) throws Exception {
        DriverConfigPanel.addJarToClasspathStatic(jarFile);
    }

    private void addJarToClasspath(File jarFile) throws Exception {
        DriverConfigPanel.addJarToClasspathStatic(jarFile);
    }

    private static void addJarToClasspathStatic(File jarFile) throws Exception {
        URL jarUrl = jarFile.toURI().toURL();
        if (driverClassLoader == null) {
            driverClassLoader = new URLClassLoader(new URL[]{jarUrl}, ClassLoader.getSystemClassLoader());
            LOGGER.info("Created new driver class loader with: " + jarFile.getName());
        } else {
            URL[] existingUrls = driverClassLoader.getURLs();
            URL[] newUrls = new URL[existingUrls.length + 1];
            System.arraycopy(existingUrls, 0, newUrls, 0, existingUrls.length);
            newUrls[existingUrls.length] = jarUrl;
            try {
                driverClassLoader.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not close old class loader", e);
            }
            driverClassLoader = new URLClassLoader(newUrls, ClassLoader.getSystemClassLoader());
            LOGGER.info("Extended driver class loader with: " + jarFile.getName() + " (now contains " + newUrls.length + " JARs)");
        }
        Thread.currentThread().setContextClassLoader(driverClassLoader);
        DriverConfigPanel.loadJdbcDriversFromJar(jarFile);
    }

    private static void loadJdbcDriversFromJar(File jarFile) {
        try {
            String[] commonDrivers = new String[]{"org.postgresql.Driver", "com.mysql.jdbc.Driver", "com.mysql.cj.jdbc.Driver", "oracle.jdbc.driver.OracleDriver", "oracle.jdbc.OracleDriver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.mariadb.jdbc.Driver", "org.h2.Driver", "org.sqlite.JDBC", "net.sourceforge.jtds.jdbc.Driver"};
            int loadedCount = 0;
            for (String driverClass : commonDrivers) {
                try {
                    Class<?> driver = Class.forName(driverClass, true, driverClassLoader);
                    LOGGER.info("Successfully loaded JDBC driver: " + driverClass);
                    ++loadedCount;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (loadedCount > 0) {
                LOGGER.info("Loaded " + loadedCount + " JDBC driver(s) from " + jarFile.getName());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while trying to load JDBC drivers from JAR", e);
        }
    }

    public static ClassLoader getDriverClassLoader() {
        return driverClassLoader != null ? driverClassLoader : ClassLoader.getSystemClassLoader();
    }

    private void setStatus(String message) {
        this.setStatus(message, Color.BLUE);
    }

    private void setStatus(String message, Color color) {
        this.lblStatus.setText(message);
        this.lblStatus.setForeground(color);
    }
}

