/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ClobTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static Logger LOGGER = Logger.getLogger(ClobTableCellRenderer.class.getName());
    private TableCellRenderer rendererDelegate;
    private JLabel label = null;
    private JButton button = null;

    public ClobTableCellRenderer(TableCellRenderer rendererDelegate) {
        this.rendererDelegate = rendererDelegate;
        this.initialize();
    }

    protected void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new FlowLayout(2, 0, 0));
        this.add(this.getLabel());
        this.add(this.getButton());
    }

    protected JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createEmptyBorder());
            this.label.setOpaque(false);
        }
        return this.label;
    }

    protected JButton getButton() {
        if (this.button == null) {
            this.button = new JButton();
            this.button.setText("...");
            this.button.setBorderPainted(false);
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LOGGER.info("Action listener from renderer !");
                }
            });
        }
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component delegateComp = this.rendererDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Class<?> clazz = table.getModel().getColumnClass(column);
        if (clazz.getName().toLowerCase().endsWith("clob")) {
            String txt = value == null ? "<NULL>" : "<CLOB>";
            this.getLabel().setText(txt);
            Color bg = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.setBackground(bg);
            Color fg = isSelected ? table.getSelectionForeground() : table.getForeground();
            this.getLabel().setForeground(fg);
            return this;
        }
        LOGGER.warning("Using delegate renderer...");
        return delegateComp;
    }
}

