/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.renderer;

import java.awt.Component;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DateTableCellRenderer
implements TableCellRenderer {
    private final DateTimeFormatter formatter;
    private final TableCellRenderer delegate;

    public DateTableCellRenderer(TableCellRenderer delegate) {
        this(delegate, "yyyy-MM-dd HH:mm:ss");
    }

    public DateTableCellRenderer(TableCellRenderer delegate, String dateTimePattern) {
        this.delegate = delegate;
        this.formatter = DateTimeFormatter.ofPattern(dateTimePattern);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Date) {
            Timestamp valueDate = (Timestamp)value;
            LocalDateTime dt = LocalDateTime.ofInstant(valueDate.toInstant(), ZoneId.of("Europe/Zurich"));
            return this.delegate.getTableCellRendererComponent(table, dt.format(this.formatter), isSelected, hasFocus, row, column);
        }
        return this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

