/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.DbConfigFile;
import net.hironico.minisql.model.SQLObject;
import net.hironico.minisql.model.SQLTable;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.visualdb.DBGraphScene;
import net.hironico.minisql.ui.visualdb.VisualDbPanel;
import org.jdesktop.swingx.JXTreeTable;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;

public class SQLObjectMoveHandler
extends TransferHandler {
    private final Logger LOGGER = Logger.getLogger(SQLObjectMoveHandler.class.getName());
    private final DataFlavor objectArrayFlavor = new DataFlavor(SQLTable[].class, "Array of SQLTable objects");
    private VisualDbPanel dbPanel;

    public static SQLObjectMoveHandler createFor(JXTreeTable treeTable) {
        SQLObjectMoveHandler handler = new SQLObjectMoveHandler();
        treeTable.setTransferHandler((TransferHandler)handler);
        return handler;
    }

    public static SQLObjectMoveHandler createFor(VisualDbPanel dbPanel, final DBGraphScene scene) {
        final SQLObjectMoveHandler handler = new SQLObjectMoveHandler();
        handler.dbPanel = dbPanel;
        AcceptProvider ap = new AcceptProvider(){

            public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
                TransferHandler.TransferSupport support = new TransferHandler.TransferSupport((Component)scene.getView(), transferable);
                return handler.canImport(support) ? ConnectorState.ACCEPT : ConnectorState.REJECT;
            }

            public void accept(Widget widget, Point point, Transferable transferable) {
                TransferHandler.TransferSupport support = new TransferHandler.TransferSupport((Component)scene.getView(), transferable);
                handler.importData(support);
            }
        };
        scene.getActions().addAction(ActionFactory.createAcceptAction((AcceptProvider)ap));
        return handler;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return info.isDataFlavorSupported(this.objectArrayFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Transferable t = transferSupport.getTransferable();
        boolean success = false;
        try {
            String dbConfigName = MainWindow.getInstance().getSchemaExplorerPanel().getSelectedConnectionName();
            DbConfig dbConfig = DbConfigFile.getConfig(dbConfigName);
            SQLObject[] importedData = (SQLObject[])t.getTransferData(this.objectArrayFlavor);
            this.dbPanel.addSQLObjects(Arrays.asList(importedData), dbConfig);
            success = true;
        }
        catch (UnsupportedFlavorException | IOException e) {
            this.LOGGER.log(Level.SEVERE, "Cannot drag n drop SQL Tables to VisualDbPanel", e);
        }
        return success;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public Transferable createTransferable(JComponent source) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] df = new DataFlavor[]{SQLObjectMoveHandler.this.objectArrayFlavor};
                return df;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return true;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                List<SQLObject> objList = MainWindow.getInstance().getSchemaExplorerPanel().getAllSelectedSQLObjects();
                return objList.toArray(new SQLObject[0]);
            }
        };
    }
}

