/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.hironico.common.swing.JRoundedPanel;
import net.hironico.common.swing.ribbon.RibbonTab;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLObject;
import net.hironico.minisql.model.SQLObjectTypeEnum;
import net.hironico.minisql.model.SQLTable;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.visualdb.DBGraphScene;
import net.hironico.minisql.ui.visualdb.SQLObjectMoveHandler;
import net.hironico.minisql.ui.visualdb.SQLTableLoaderThread;
import net.hironico.minisql.ui.visualdb.SatelliteUI;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class VisualDbPanel
extends JRoundedPanel {
    private static final Logger LOGGER = Logger.getLogger(VisualDbPanel.class.getName());
    private final DBGraphScene graphScene = new DBGraphScene();
    private JXLayer<JComponent> sceneLayer;
    private SatelliteUI satelliteUI;

    public VisualDbPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(JRoundedPanel.LIGHT_BLUE_COLOR);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollScene = new JScrollPane();
        scrollScene.setVerticalScrollBarPolicy(22);
        scrollScene.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        JComponent sceneView = this.graphScene.createView();
        sceneView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                MainWindow.getInstance().getRibbon().setSelectedRibbonTab("Visual Db");
            }
        });
        scrollScene.setViewportView(sceneView);
        this.satelliteUI = new SatelliteUI(this.graphScene);
        this.satelliteUI.setSatellitevisible(true);
        this.sceneLayer = new JXLayer((Component)scrollScene, (LayerUI)this.satelliteUI);
        this.add((Component)this.sceneLayer, "Center");
        SQLObjectMoveHandler.createFor(this, this.graphScene);
    }

    public void addSQLObjects(List<SQLObject> sqlObjects, DbConfig dbConfig) {
        List<SQLTable> tables = sqlObjects.stream().filter(o -> o.type == SQLObjectTypeEnum.TABLE).map(o -> new SQLTable(o.schemaName, o.name)).collect(Collectors.toList());
        this.addSQLTables(tables, dbConfig);
    }

    public void addSQLTables(List<SQLTable> tables, DbConfig dbConfig) {
        SQLTableLoaderThread loaderThread = new SQLTableLoaderThread(tables, dbConfig);
        Future<List<SQLTable>> fut = MainWindow.executorService.submit(loaderThread);
        try {
            this.graphScene.createScene(fut.get());
            this.graphScene.revalidate();
            this.graphScene.validate();
        }
        catch (InterruptedException | ExecutionException ie) {
            LOGGER.log(Level.SEVERE, "Cannot add SQL tables to scene.", ie);
        }
    }

    public DBGraphScene getGraphScene() {
        return this.graphScene;
    }

    public void repaint() {
        super.repaint();
        if (this.sceneLayer != null) {
            this.sceneLayer.repaint();
        }
    }

    public void showNavigation() {
        this.satelliteUI.setSatellitevisible(true);
    }

    public void updateRibbon() {
        RibbonTab ribbonTab = MainWindow.getInstance().getRibbon().setSelectedRibbonTab("Visual Db");
        ribbonTab.updateDisplay();
    }
}

