/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import mondrian.olap.MondrianDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.MondrianSchemaValidator;

public abstract class AbstractMondrianSchemaValidatorTestBase {
    protected MondrianDef.Schema schema;
    protected Connection conn;
    protected Mockery context;
    protected DatabaseMetaData meta;
    protected ResultSet rsSalesFact1997PrimaryKeys;
    protected ResultSet rsSalesFact1997ForeignKey;
    protected ResultSet rsStorePrimaryKeys;
    protected ResultSet rsCount;
    protected Statement stmt;
    protected MondrianSchemaValidator v1;
    protected MondrianSchemaValidator v2;
    protected MondrianSchemaValidator v3;
    protected MondrianSchemaValidator v4;
    protected MondrianSchemaValidator v5;
    protected static final Log logger = LogFactory.getLog(AbstractMondrianSchemaValidatorTestBase.class);

    public void setUp() throws Exception {
        this.context = new JUnit4Mockery();
        this.schema = this.loadSchema("/FoodMart.xml");
        if (null == this.schema) {
            throw new RuntimeException("unable to load schema from file");
        }
        this.conn = (Connection)this.context.mock(Connection.class);
        this.meta = (DatabaseMetaData)this.context.mock(DatabaseMetaData.class);
        this.rsSalesFact1997PrimaryKeys = (ResultSet)this.context.mock(ResultSet.class, "rsSalesFact1997PrimaryKeys");
        this.rsStorePrimaryKeys = (ResultSet)this.context.mock(ResultSet.class, "rsStorePrimaryKeys");
        this.rsSalesFact1997ForeignKey = (ResultSet)this.context.mock(ResultSet.class, "rsSalesFact1997ForeignKey");
        this.stmt = (Statement)this.context.mock(Statement.class, "stmt");
        this.rsCount = (ResultSet)this.context.mock(ResultSet.class, "rsCount");
        this.v1 = (MondrianSchemaValidator)this.context.mock(MondrianSchemaValidator.class, "v1");
        this.v2 = (MondrianSchemaValidator)this.context.mock(MondrianSchemaValidator.class, "v2");
        this.v3 = (MondrianSchemaValidator)this.context.mock(MondrianSchemaValidator.class, "v3");
        this.v4 = (MondrianSchemaValidator)this.context.mock(MondrianSchemaValidator.class, "v4");
        this.v5 = (MondrianSchemaValidator)this.context.mock(MondrianSchemaValidator.class, "v5");
    }

    protected MondrianDef.Schema loadSchema(String classpathRelativePath) {
        try {
            InputStream is;
            Parser xmlParser = XOMUtil.createDefaultParser();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("creating InputStream from " + classpathRelativePath));
            }
            if (null == (is = this.getClass().getResourceAsStream(classpathRelativePath))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(classpathRelativePath + " not found"));
                }
                return null;
            }
            return new MondrianDef.Schema(xmlParser.parse(is));
        }
        catch (XOMException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred; returning null", (Throwable)e);
            }
            return null;
        }
    }

    protected boolean isMessagePresent(List<ValidationMessage> messages, ValidationMessage.Type type, String ... substrings) {
        for (ValidationMessage message : messages) {
            if (message.getType() != type) continue;
            for (String substring : substrings) {
                if (message.getMessage().contains(substring)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected MondrianDef.Cube getCubeByName(String name) {
        for (MondrianDef.Cube cube : this.schema.cubes) {
            if (!cube.name.equals(name)) continue;
            return cube;
        }
        return null;
    }
}

