/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.AbstractMondrianSchemaValidatorTestBase;
import org.pentaho.aggdes.model.mondrian.validate.CubePkValidator;

@RunWith(value=JMock.class)
public class CubePkValidatorTest
extends AbstractMondrianSchemaValidatorTestBase {
    private static final Log logger = LogFactory.getLog(CubePkValidatorTest.class);
    CubePkValidator bean = new CubePkValidator();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testMissingPKOnFact() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(CubePkValidatorTest.this.conn)).getMetaData();
                this.will(1.returnValue((Object)CubePkValidatorTest.this.meta));
                ((DatabaseMetaData)this.allowing(CubePkValidatorTest.this.meta)).getPrimaryKeys(null, null, "sales_fact_1997");
                this.will(1.returnValue((Object)CubePkValidatorTest.this.rsSalesFact1997PrimaryKeys));
                ((ResultSet)this.one(CubePkValidatorTest.this.rsSalesFact1997PrimaryKeys)).next();
                this.will(1.returnValue((Object)true));
                ((DatabaseMetaData)this.allowing(CubePkValidatorTest.this.meta)).getPrimaryKeys((String)this.with(1.any(String.class)), (String)this.with(1.any(String.class)), (String)this.with(1.any(String.class)));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.OK, "sales_fact_1997", "primary key"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
    }

    @Test
    public void testOKPKOnFact() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(CubePkValidatorTest.this.conn)).getMetaData();
                this.will(2.returnValue((Object)CubePkValidatorTest.this.meta));
                ((DatabaseMetaData)this.allowing(CubePkValidatorTest.this.meta)).getPrimaryKeys(null, null, "sales_fact_1997");
                this.will(2.returnValue((Object)CubePkValidatorTest.this.rsSalesFact1997PrimaryKeys));
                ((ResultSet)this.one(CubePkValidatorTest.this.rsSalesFact1997PrimaryKeys)).next();
                this.will(2.returnValue((Object)false));
                ((DatabaseMetaData)this.allowing(CubePkValidatorTest.this.meta)).getPrimaryKeys((String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.ERROR, "sales_fact_1997", "primary key"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
    }
}

