/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.AbstractMondrianSchemaValidatorTestBase;
import org.pentaho.aggdes.model.mondrian.validate.DimensionFkValidator;

@RunWith(value=JMock.class)
public class DimensionFkValidatorTest
extends AbstractMondrianSchemaValidatorTestBase {
    private static final Log logger = LogFactory.getLog(DimensionFkValidatorTest.class);
    private DimensionFkValidator bean = new DimensionFkValidator();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testNullableFalseCheckUsingMetaData() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(DimensionFkValidatorTest.this.conn)).getMetaData();
                this.will(1.returnValue((Object)DimensionFkValidatorTest.this.meta));
                ((DatabaseMetaData)this.allowing(DimensionFkValidatorTest.this.meta)).getColumns((String)this.with(1.aNull(String.class)), (String)this.with(1.aNull(String.class)), (String)this.with(1.equal((Object)"sales_fact_1997")), (String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey)).next();
                this.will(1.returnValue((Object)true));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey)).getString("IS_NULLABLE");
                this.will(1.returnValue((Object)"NO"));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.OK, "Sales", "sales_fact_1997", "store_id"));
    }

    @Test
    public void testNullableTrueCheckUsingMetaData() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(DimensionFkValidatorTest.this.conn)).getMetaData();
                this.will(2.returnValue((Object)DimensionFkValidatorTest.this.meta));
                ((Connection)this.allowing(DimensionFkValidatorTest.this.conn)).createStatement();
                this.will(2.returnValue((Object)DimensionFkValidatorTest.this.stmt));
                ((Statement)this.allowing(DimensionFkValidatorTest.this.stmt)).executeQuery((String)this.with(2.any(String.class)));
                this.will(2.returnValue((Object)DimensionFkValidatorTest.this.rsCount));
                ((Statement)this.allowing(DimensionFkValidatorTest.this.stmt)).close();
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsCount)).next();
                this.will(2.returnValue((Object)true));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsCount)).getLong("null_count");
                this.will(2.returnValue((Object)0L));
                ((DatabaseMetaData)this.allowing(DimensionFkValidatorTest.this.meta)).getColumns((String)this.with(2.aNull(String.class)), (String)this.with(2.aNull(String.class)), (String)this.with(2.equal((Object)"sales_fact_1997")), (String)this.with(2.any(String.class)));
                this.will(2.returnValue((Object)DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey)).next();
                this.will(2.returnValue((Object)true));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey)).getString("IS_NULLABLE");
                this.will(2.returnValue((Object)"YES"));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.OK, "Sales", "sales_fact_1997", "store_id"));
    }

    @Test
    public void testNullableTrueCheckUsingResultSet() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(DimensionFkValidatorTest.this.conn)).getMetaData();
                this.will(3.returnValue((Object)DimensionFkValidatorTest.this.meta));
                ((Connection)this.allowing(DimensionFkValidatorTest.this.conn)).createStatement();
                this.will(3.returnValue((Object)DimensionFkValidatorTest.this.stmt));
                ((Statement)this.allowing(DimensionFkValidatorTest.this.stmt)).executeQuery((String)this.with(3.any(String.class)));
                this.will(3.returnValue((Object)DimensionFkValidatorTest.this.rsCount));
                ((Statement)this.allowing(DimensionFkValidatorTest.this.stmt)).close();
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsCount)).next();
                this.will(3.returnValue((Object)true));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsCount)).getLong("null_count");
                this.will(3.returnValue((Object)14L));
                ((DatabaseMetaData)this.allowing(DimensionFkValidatorTest.this.meta)).getColumns((String)this.with(3.aNull(String.class)), (String)this.with(3.aNull(String.class)), (String)this.with(3.equal((Object)"sales_fact_1997")), (String)this.with(3.any(String.class)));
                this.will(3.returnValue((Object)DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey)).next();
                this.will(3.returnValue((Object)true));
                ((ResultSet)this.allowing(DimensionFkValidatorTest.this.rsSalesFact1997ForeignKey)).getString("IS_NULLABLE");
                this.will(3.returnValue((Object)"YES"));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.ERROR, "Sales", "sales_fact_1997", "store_id"));
    }
}

