/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.AbstractMondrianSchemaValidatorTestBase;
import org.pentaho.aggdes.model.mondrian.validate.HierarchyPkValidator;

@RunWith(value=JMock.class)
public class HierarchyPkValidatorTest
extends AbstractMondrianSchemaValidatorTestBase {
    private static final Log logger = LogFactory.getLog(HierarchyPkValidatorTest.class);
    private HierarchyPkValidator bean = new HierarchyPkValidator();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testMissingPkOnHierarchy() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(HierarchyPkValidatorTest.this.conn)).getMetaData();
                this.will(1.returnValue((Object)HierarchyPkValidatorTest.this.meta));
                ((DatabaseMetaData)this.allowing(HierarchyPkValidatorTest.this.meta)).getPrimaryKeys(null, null, "store");
                this.will(1.returnValue((Object)HierarchyPkValidatorTest.this.rsStorePrimaryKeys));
                ((ResultSet)this.allowing(HierarchyPkValidatorTest.this.rsStorePrimaryKeys)).next();
                this.will(1.returnValue((Object)false));
                ((DatabaseMetaData)this.allowing(HierarchyPkValidatorTest.this.meta)).getPrimaryKeys((String)this.with(1.any(String.class)), (String)this.with(1.any(String.class)), (String)this.with(1.any(String.class)));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.ERROR, "store", "primary key"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
    }

    @Test
    public void testOkPkOnHierarchy() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.one(HierarchyPkValidatorTest.this.conn)).getMetaData();
                this.will(2.returnValue((Object)HierarchyPkValidatorTest.this.meta));
                ((DatabaseMetaData)this.allowing(HierarchyPkValidatorTest.this.meta)).getPrimaryKeys(null, null, "store");
                this.will(2.returnValue((Object)HierarchyPkValidatorTest.this.rsStorePrimaryKeys));
                ((ResultSet)this.allowing(HierarchyPkValidatorTest.this.rsStorePrimaryKeys)).next();
                this.will(2.returnValue((Object)true));
                ((DatabaseMetaData)this.allowing(HierarchyPkValidatorTest.this.meta)).getPrimaryKeys((String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)));
            }
        });
        List messages = this.bean.validateCube(this.schema, this.getCubeByName("Sales"), this.conn);
        Assert.assertTrue((boolean)this.isMessagePresent(messages, ValidationMessage.Type.OK, "store", "primary key"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got " + messages.size() + " message(s): " + messages));
        }
    }
}

