/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.pentaho.aggdes.Main;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.ResultHandler;

public class AggDesignerMainTest
extends TestCase {
    public void testUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        Main.main((String[])new String[0]);
        String results = baos.toString();
        AggDesignerMainTest.assertTrue((results.indexOf("Usage: java") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
    }

    public void testInvalidParam() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        Main.main((String[])new String[]{"--loaderClass", "org.pentaho.aggdes.test.algorithm.impl.SchemaLoaderStub", "--loaderParam", "cube", "Sales", "--algorithmClass", "org.pentaho.aggdes.test.algorithm.impl.AlgorithmStub", "--algorithmParam", "notValidParam1", "not_yet_validated", "--resultClass", "org.pentaho.aggdes.output.impl.ResultHandlerImpl", "--resultParam", "notValidParam2", "not_yet_validated"});
        String results = baos.toString();
        AggDesignerMainTest.assertTrue((results.indexOf("Unknown parameter 'notValidParam1'") >= 0 ? 1 : 0) != 0);
        AggDesignerMainTest.assertTrue((results.indexOf("execTime (INTEGER) Description") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
    }

    public void testMissingLoaderComponent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        Main.main((String[])new String[]{"--algorithmClass", "org.pentaho.aggdes.test.algorithm.impl.AlgorithmStub", "--algorithmParam", "notValidParam1", "not_yet_validated", "--resultClass", "org.pentaho.aggdes.output.impl.ResultHandlerImpl", "--resultParam", "notValidParam2", "not_yet_validated"});
        String results = baos.toString();
        AggDesignerMainTest.assertTrue((results.indexOf("Missing required component. Please specify '--loaderClass' argument") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
    }

    public void testMissingAlgorithmComponent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        Main.main((String[])new String[]{"--loaderClass", "org.pentaho.aggdes.test.algorithm.impl.SchemaLoaderStub", "--loaderParam", "cube", "Sales", "--resultClass", "org.pentaho.aggdes.output.impl.ResultHandlerImpl", "--resultParam", "notValidParam2", "not_yet_validated"});
        String results = baos.toString();
        AggDesignerMainTest.assertTrue((results.indexOf("Missing required component. Please specify '--algorithmClass' argument") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
    }

    public void testMissingResultComponent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        Main.main((String[])new String[]{"--loaderClass", "org.pentaho.aggdes.test.algorithm.impl.SchemaLoaderStub", "--loaderParam", "cube", "Sales", "--algorithmClass", "org.pentaho.aggdes.test.algorithm.impl.AlgorithmStub"});
        String results = baos.toString();
        AggDesignerMainTest.assertTrue((results.indexOf("Missing required component. Please specify '--resultClass' argument") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
    }

    public void testRunAlgo() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        Main.main((String[])new String[]{"--loaderClass", "org.pentaho.aggdes.test.algorithm.impl.SchemaLoaderStub", "--loaderParam", "cube", "Sales", "--algorithmClass", "org.pentaho.aggdes.test.algorithm.impl.AlgorithmStub", "--resultClass", "org.pentaho.aggdes.test.AggDesignerMainTest$ResultHandlerStub"});
        String results = baos.toString();
        AggDesignerMainTest.assertTrue((results.indexOf("ResultHandlerStub handle called") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
    }

    public void testArgumentUtils() {
        ComponentStub component = new ComponentStub();
        HashMap<String, String> rawParams = new HashMap<String, String>();
        Map params = ArgumentUtils.validateParameters((Component)component, rawParams);
        AggDesignerMainTest.assertEquals((int)params.size(), (int)0);
        rawParams.clear();
        rawParams.put("integer", "2");
        params = ArgumentUtils.validateParameters((Component)component, rawParams);
        AggDesignerMainTest.assertEquals((int)params.size(), (int)1);
        AggDesignerMainTest.assertEquals(params.get(component.getParameters().get(1)), (Object)2);
        try {
            rawParams.clear();
            rawParams.put("integer", "x");
            ArgumentUtils.validateParameters((Component)component, rawParams);
            AggDesignerMainTest.fail();
        }
        catch (ArgumentUtils.ValidationException e) {
            AggDesignerMainTest.assertEquals((String)e.getMessage(), (String)"Cannot convert parameter 'integer' to integer");
        }
        rawParams.clear();
        rawParams.put("double", "2.1");
        params = ArgumentUtils.validateParameters((Component)component, rawParams);
        AggDesignerMainTest.assertEquals((int)params.size(), (int)1);
        AggDesignerMainTest.assertEquals(params.get(component.getParameters().get(2)), (Object)2.1);
        try {
            rawParams.clear();
            rawParams.put("double", "x");
            ArgumentUtils.validateParameters((Component)component, rawParams);
            AggDesignerMainTest.fail();
        }
        catch (ArgumentUtils.ValidationException e) {
            AggDesignerMainTest.assertEquals((String)e.getMessage(), (String)"Cannot convert parameter 'double' to double");
        }
        rawParams.clear();
        rawParams.put("boolean", "true");
        params = ArgumentUtils.validateParameters((Component)component, rawParams);
        AggDesignerMainTest.assertEquals((int)params.size(), (int)1);
        AggDesignerMainTest.assertEquals(params.get(component.getParameters().get(3)), (Object)true);
        rawParams.clear();
        rawParams.put("boolean", "x");
        params = ArgumentUtils.validateParameters((Component)component, rawParams);
        AggDesignerMainTest.assertEquals((int)params.size(), (int)1);
        AggDesignerMainTest.assertEquals(params.get(component.getParameters().get(3)), (Object)false);
        Parameter required = new Parameter(){

            public String getDescription() {
                return "Description";
            }

            public String getName() {
                return "required";
            }

            public Parameter.Type getType() {
                return Parameter.Type.BOOLEAN;
            }

            public boolean isRequired() {
                return true;
            }
        };
        component.getParameters().add(required);
        rawParams.clear();
        rawParams.put("required", "true");
        params = ArgumentUtils.validateParameters((Component)component, rawParams);
        AggDesignerMainTest.assertEquals((int)params.size(), (int)1);
        AggDesignerMainTest.assertEquals(params.get(required), (Object)Boolean.TRUE);
        try {
            rawParams.clear();
            ArgumentUtils.validateParameters((Component)component, rawParams);
            AggDesignerMainTest.fail();
        }
        catch (ArgumentUtils.ValidationException e) {
            AggDesignerMainTest.assertEquals((String)e.getMessage(), (String)"Missing value for required parameter 'required' of component ComponentStub");
        }
    }

    static class ComponentStub
    implements Component {
        List<Parameter> parameters;

        public ComponentStub() {
            Parameter string = new Parameter(){

                public String getDescription() {
                    return "Description";
                }

                public String getName() {
                    return "string";
                }

                public Parameter.Type getType() {
                    return Parameter.Type.STRING;
                }

                public boolean isRequired() {
                    return false;
                }
            };
            Parameter integer = new Parameter(){

                public String getDescription() {
                    return "Description";
                }

                public String getName() {
                    return "integer";
                }

                public Parameter.Type getType() {
                    return Parameter.Type.INTEGER;
                }

                public boolean isRequired() {
                    return false;
                }
            };
            Parameter doub = new Parameter(){

                public String getDescription() {
                    return "Description";
                }

                public String getName() {
                    return "double";
                }

                public Parameter.Type getType() {
                    return Parameter.Type.DOUBLE;
                }

                public boolean isRequired() {
                    return false;
                }
            };
            Parameter bool = new Parameter(){

                public String getDescription() {
                    return "Description";
                }

                public String getName() {
                    return "boolean";
                }

                public Parameter.Type getType() {
                    return Parameter.Type.BOOLEAN;
                }

                public boolean isRequired() {
                    return false;
                }
            };
            ArrayList<Parameter> list = new ArrayList<Parameter>();
            list.add(string);
            list.add(integer);
            list.add(doub);
            list.add(bool);
            this.parameters = list;
        }

        public String getName() {
            return "ComponentStub";
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }
    }

    public static class ResultHandlerStub
    implements ResultHandler {
        public void handle(Map<Parameter, Object> parameterValues, Schema schema, Result result) {
            System.out.println("ResultHandlerStub handle called");
        }

        public String getName() {
            return null;
        }

        public List<Parameter> getParameters() {
            return Collections.EMPTY_LIST;
        }
    }
}

