/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import mondrian.olap.MondrianException;
import org.junit.Ignore;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dimension;
import org.pentaho.aggdes.model.Hierarchy;
import org.pentaho.aggdes.model.Level;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.StatisticsProvider;
import org.pentaho.aggdes.model.Table;
import org.pentaho.aggdes.model.mondrian.Messages;
import org.pentaho.aggdes.model.mondrian.MondrianAttribute;
import org.pentaho.aggdes.model.mondrian.MondrianSchema;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.model.mondrian.MondrianTable;
import org.pentaho.aggdes.test.util.TestUtils;

public class MondrianSchemaLoaderTest
extends TestCase {
    protected String connectString;

    public void setUp() throws Exception {
        System.out.println("SETUP");
        this.connectString = TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString", (Object[])new Object[]{TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.provider", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.jdbc", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.username", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.password", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.catalog", (Object[])new Object[0])});
        TestUtils.registerDriver((String)TestUtils.getTestProperty((String)"test.jdbc.driver.classpath", (Object[])new Object[0]), (String)TestUtils.getTestProperty((String)"test.jdbc.driver.classname", (Object[])new Object[0]));
    }

    public void testFoodmartLoading() {
        MondrianSchemaLoader loader = new MondrianSchemaLoader();
        HashMap parameterValues = new HashMap();
        System.out.println("CONN STR: " + this.connectString);
        parameterValues.put(loader.getParameters().get(0), this.connectString);
        parameterValues.put(loader.getParameters().get(1), "Sales");
    }

    public void testInvalidConnectStringParameter() {
        try {
            MondrianSchemaLoader loader = new MondrianSchemaLoader();
            HashMap parameterValues = new HashMap();
            parameterValues.put(loader.getParameters().get(0), "badconnstr");
            loader.createSchema(parameterValues);
            MondrianSchemaLoaderTest.fail();
        }
        catch (MondrianException e) {
            MondrianSchemaLoaderTest.assertEquals((String)"Mondrian Error:Internal error: Connect string 'badconnstr=; Catalog='null'' must contain either 'Jdbc' or 'DataSource'", (String)e.getMessage());
        }
    }

    @Ignore
    public void _testInvalidCubeParameter() {
        try {
            MondrianSchemaLoader loader = new MondrianSchemaLoader();
            HashMap parameterValues = new HashMap();
            parameterValues.put(loader.getParameters().get(0), this.connectString);
            parameterValues.put(loader.getParameters().get(1), "InvalidCube");
            loader.createSchema(parameterValues);
            MondrianSchemaLoaderTest.fail();
        }
        catch (MondrianException e) {
            MondrianSchemaLoaderTest.assertEquals((String)e.getMessage(), (String)"Mondrian Error:MDX cube 'InvalidCube' not found");
        }
    }

    @Ignore
    public void _testMondrianSchemaModel() throws Exception {
        MondrianSchemaLoader loader = new MondrianSchemaLoader();
        HashMap parameterValues = new HashMap();
        System.out.println("CONN STR: " + this.connectString);
        parameterValues.put(loader.getParameters().get(0), this.connectString);
        parameterValues.put(loader.getParameters().get(1), "Sales");
        Schema schema = loader.createSchema(parameterValues);
        MondrianSchemaLoaderTest.assertTrue((boolean)(schema instanceof MondrianSchema));
        MondrianSchema mondrianSchema = (MondrianSchema)schema;
        MondrianSchemaLoaderTest.assertNotNull((Object)mondrianSchema.getDatabaseMetaData());
        MondrianSchemaLoaderTest.assertEquals((int)7, (int)schema.getMeasures().size());
        MondrianSchemaLoaderTest.assertEquals((String)"sales_fact_1997.Unit Sales", (String)((Measure)schema.getMeasures().get(0)).getLabel());
        MondrianSchemaLoaderTest.assertEquals((String)"sales_fact_1997.fact_count", (String)((Measure)schema.getMeasures().get(6)).getLabel());
        MondrianSchemaLoaderTest.assertEquals((boolean)((Measure)schema.getMeasures().get(0)).isDistinct(), (boolean)false);
        MondrianSchemaLoaderTest.assertEquals((Object)((Measure)schema.getMeasures().get(0)).getTable(), schema.getTables().get(0));
        MondrianSchemaLoaderTest.assertEquals((Object)((Measure)schema.getMeasures().get(0)).estimateSpace(), (Object)4.0);
        MondrianSchemaLoaderTest.assertEquals((Object)((Measure)schema.getMeasures().get(0)).getAncestorAttributes(), null);
        MondrianSchemaLoaderTest.assertEquals((int)8, (int)schema.getTables().size());
        MondrianSchemaLoaderTest.assertEquals((String)"sales_fact_1997", (String)((Table)schema.getTables().get(0)).getLabel());
        MondrianSchemaLoaderTest.assertEquals((Object)((Table)schema.getTables().get(1)).getParent(), schema.getTables().get(0));
        MondrianSchemaLoaderTest.assertTrue((boolean)(schema.getTables().get(0) instanceof MondrianTable));
        MondrianSchemaLoaderTest.assertNotNull((Object)((MondrianTable)schema.getTables().get(0)).getStarTable());
        MondrianSchemaLoaderTest.assertEquals((int)27, (int)schema.getAttributes().size());
        MondrianSchemaLoaderTest.assertEquals((String)"[store].[Store Country]", (String)((Attribute)schema.getAttributes().get(0)).getLabel());
        MondrianSchemaLoaderTest.assertEquals((Object)((Attribute)schema.getAttributes().get(0)).getTable(), schema.getTables().get(1));
        MondrianSchemaLoaderTest.assertTrue((boolean)(schema.getAttributes().get(0) instanceof MondrianAttribute));
        MondrianSchemaLoaderTest.assertEquals((Object)((MondrianAttribute)schema.getAttributes().get(0)).getDistinctValueCount(), (Object)3.0);
        MondrianSchemaLoaderTest.assertEquals((Object)((MondrianAttribute)schema.getAttributes().get(0)).estimateSpace(), (Object)20.0);
        MondrianSchemaLoaderTest.assertEquals((int)((Attribute)schema.getAttributes().get(3)).getAncestorAttributes().size(), (int)3);
        MondrianSchemaLoaderTest.assertEquals((String)((Attribute)((Attribute)schema.getAttributes().get(22)).getAncestorAttributes().get(0)).getLabel(), (String)"[customer].[Country]");
        MondrianSchemaLoaderTest.assertEquals((String)((Dimension)schema.getDimensions().get(1)).getName(), (String)"Store Size in SQFT");
        MondrianSchemaLoaderTest.assertEquals((String)((Hierarchy)((Dimension)schema.getDimensions().get(0)).getHierarchies().get(0)).getName(), (String)"Store");
        MondrianSchemaLoaderTest.assertEquals((String)((Level)((Hierarchy)((Dimension)schema.getDimensions().get(2)).getHierarchies().get(0)).getLevels().get(1)).getName(), (String)"Store Type");
        MondrianSchemaLoaderTest.assertEquals(schema.getAttributes().get(7), (Object)((Level)((Hierarchy)((Dimension)schema.getDimensions().get(3)).getHierarchies().get(0)).getLevels().get(1)).getAttribute());
    }

    public void testMessages() {
        MondrianSchemaLoaderTest.assertEquals((String)Messages.getString((String)"MondrianSchemaLoader.ERROR_0001_MONDRIAN_DEPENDENCY_ERROR"), (String)"The version of mondrian on the classpath is incompatible with this version of aggregate designer.");
        MondrianSchemaLoaderTest.assertEquals((String)Messages.getString((String)"INVALID_STR"), (String)"!INVALID_STR!");
        MondrianSchemaLoaderTest.assertEquals((String)Messages.getString((String)"INVALID_STR", (Object[])new Object[]{"a", "b"}), (String)"!INVALID_STR!");
    }

    @Ignore
    public void _testMondrianStatisticsProvider() {
        MondrianSchemaLoader loader = new MondrianSchemaLoader();
        HashMap parameterValues = new HashMap();
        System.out.println("CONN STR: " + this.connectString);
        parameterValues.put(loader.getParameters().get(0), this.connectString);
        parameterValues.put(loader.getParameters().get(1), "Sales");
        Schema schema = loader.createSchema(parameterValues);
        StatisticsProvider statsProvider = schema.getStatisticsProvider();
        MondrianSchemaLoaderTest.assertNotNull((Object)statsProvider);
        MondrianSchemaLoaderTest.assertEquals((Object)statsProvider.getFactRowCount(), (Object)86837.0);
        ArrayList attributes = new ArrayList();
        attributes.add(schema.getAttributes().get(0));
        MondrianSchemaLoaderTest.assertEquals((Object)statsProvider.getRowCount(attributes), (Object)3.0);
        MondrianSchemaLoaderTest.assertEquals((Object)statsProvider.getLoadTime(attributes), (Object)3.8555688E7);
        MondrianSchemaLoaderTest.assertEquals((Object)statsProvider.getSpace(attributes), (Object)20.0);
    }
}

