/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.impl.AggregateTableOutput;
import org.pentaho.aggdes.output.impl.AggregateTableOutputFactory;
import org.pentaho.aggdes.output.impl.MondrianSchemaGenerator;
import org.pentaho.aggdes.test.util.TestAggregate;
import org.pentaho.aggdes.test.util.TestResult;
import org.pentaho.aggdes.test.util.TestUtils;

public class MondrianSchemaOutputTest
extends TestCase {
    protected String connectString;

    public void setUp() throws Exception {
        System.out.println("SETUP");
        this.connectString = TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString", (Object[])new Object[]{TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.provider", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.jdbc", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.username", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.password", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.catalog", (Object[])new Object[0])});
        System.out.println(this.connectString);
        TestUtils.registerDriver((String)TestUtils.getTestProperty((String)"test.jdbc.driver.classpath", (Object[])new Object[0]), (String)TestUtils.getTestProperty((String)"test.jdbc.driver.classname", (Object[])new Object[0]));
    }

    public void testDummy() {
    }

    @Ignore
    public void _testBasicSchemaGen() {
        MondrianSchemaLoader loader = new MondrianSchemaLoader();
        HashMap parameterValues = new HashMap();
        System.out.println("CONN STR: " + this.connectString);
        parameterValues.put(loader.getParameters().get(0), this.connectString);
        parameterValues.put(loader.getParameters().get(1), "Sales");
        Schema schema = loader.createSchema(parameterValues);
        TestResult result = new TestResult();
        TestAggregate aggregate = new TestAggregate();
        aggregate.setCandidateTableName("table_01");
        aggregate.addAttribute((Attribute)schema.getAttributes().get(3));
        aggregate.addAttribute((Attribute)schema.getAttributes().get(12));
        for (Measure measure : schema.getMeasures()) {
            aggregate.addMeasure(measure);
        }
        result.addAggregate((Aggregate)aggregate);
        MondrianSchemaGenerator generator = new MondrianSchemaGenerator();
        Class[] clazzes = generator.getSupportedOutputClasses();
        MondrianSchemaOutputTest.assertEquals((int)clazzes.length, (int)1);
        MondrianSchemaOutputTest.assertEquals((Object)clazzes[0], AggregateTableOutput.class);
        AggregateTableOutput aggTableOutput = new AggregateTableOutput(null);
        MondrianSchemaOutputTest.assertTrue((boolean)generator.canGenerate(schema, (Output)aggTableOutput));
        AggregateTableOutputFactory factory = new AggregateTableOutputFactory();
        MondrianSchemaOutputTest.assertEquals((Object)factory.getOutputClass(), AggregateTableOutput.class);
        MondrianSchemaOutputTest.assertTrue((boolean)factory.canCreateOutput(schema));
        AggregateTableOutput.ColumnOutput colOutput = new AggregateTableOutput.ColumnOutput(null, null);
        MondrianSchemaOutputTest.assertNull((Object)colOutput.getName());
        MondrianSchemaOutputTest.assertNull((Object)colOutput.getAttribute());
        colOutput.setName("testName");
        MondrianSchemaOutputTest.assertEquals((String)colOutput.getName(), (String)"testName");
        colOutput.setAttribute((Attribute)schema.getAttributes().get(3));
        MondrianSchemaOutputTest.assertEquals((Object)colOutput.getAttribute(), schema.getAttributes().get(3));
        AggregateTableOutput output = factory.createOutput(schema, (Aggregate)aggregate);
        String results = generator.generate(schema, (Output)output);
        MondrianSchemaOutputTest.assertEquals((String)TestUtils.fold((String)"<AggName name=\"table_01\">\n\t<AggFactCount column=\"sales_fact_1997_fact_count\">\n\t</AggFactCount>\n\t<AggMeasure column=\"sales_fact_1997_Unit_Sales\" name=\"[Measures].[Unit Sales]\">\n\t</AggMeasure>\n\t<AggMeasure column=\"sales_fact_1997_Store_Cost\" name=\"[Measures].[Store Cost]\">\n\t</AggMeasure>\n\t<AggMeasure column=\"sales_fact_1997_Store_Sales\" name=\"[Measures].[Store Sales]\">\n\t</AggMeasure>\n\t<AggMeasure column=\"sales_fact_1997_Sales_Count\" name=\"[Measures].[Sales Count]\">\n\t</AggMeasure>\n\t<AggMeasure column=\"sales_fact_1997_Customer_Count\" name=\"[Measures].[Customer Count]\">\n\t</AggMeasure>\n\t<AggMeasure column=\"sales_fact_1997_Promotion_Sale\" name=\"[Measures].[Promotion Sales]\">\n\t</AggMeasure>\n\t<AggLevel column=\"store_Store_Name\" name=\"[Store].[Store Name]\">\n\t</AggLevel>\n\t<AggLevel column=\"product_class_Product_Departme\" name=\"[Product].[Product Department]\">\n\t</AggLevel>\n</AggName>\n"), (String)results);
        TestAggregate aggregate2 = new TestAggregate();
        aggregate2.setCandidateTableName("table_02");
        aggregate2.addAttribute((Attribute)schema.getAttributes().get(4));
        aggregate2.addAttribute((Attribute)schema.getAttributes().get(13));
        for (Measure measure : schema.getMeasures()) {
            aggregate2.addMeasure(measure);
        }
        ArrayList<TestAggregate> aggregates = new ArrayList<TestAggregate>();
        aggregates.add(aggregate);
        aggregates.add(aggregate2);
        List outputs = factory.createOutputs(schema, aggregates);
        String schemaOutput = generator.generateFull(schema, outputs);
        MondrianSchemaOutputTest.assertTrue((schemaOutput.indexOf("<AggName name=\"table_01\">") >= 0 ? 1 : 0) != 0);
        MondrianSchemaOutputTest.assertTrue((schemaOutput.indexOf("<AggName name=\"table_02\">") >= 0 ? 1 : 0) != 0);
    }
}

