/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import org.pentaho.aggdes.algorithm.impl.Cost;
import org.pentaho.aggdes.algorithm.impl.MonteCarloLatticeImpl;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.test.algorithm.impl.SchemaStub;
import org.pentaho.aggdes.util.BitSetPlus;

public class MonteCarloLatticeImplTest
extends TestCase {
    public void testLatticeImpl() {
        SchemaStub schema = new SchemaStub();
        MonteCarloLatticeImpl lattice = new MonteCarloLatticeImpl((Schema)schema);
        Cost cost = new Cost();
        AggregateImpl aggImpl = lattice.chooseAggregate(300000.0, 1.0, cost);
        MonteCarloLatticeImplTest.assertEquals((int)2, (int)aggImpl.getAttributes().size());
        lattice.materialize(aggImpl);
        aggImpl = lattice.chooseAggregate(300000.0, 1.0, cost);
        MonteCarloLatticeImplTest.assertEquals((int)2, (int)aggImpl.getAttributes().size());
        lattice.materialize(aggImpl);
        aggImpl = lattice.chooseAggregate(300000.0, 1.0, cost);
        MonteCarloLatticeImplTest.assertEquals((int)2, (int)aggImpl.getAttributes().size());
        lattice = new MonteCarloLatticeImpl((Schema)schema);
        BitSetPlus bsp = new BitSetPlus(3);
        bsp.set(0);
        AggregateImpl aggregate1 = new AggregateImpl((Schema)schema, bsp);
        Algorithm.CostBenefit cb = lattice.costBenefitOf(aggregate1);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getLoadTime(), (Object)1000.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getRowCount(), (Object)10.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getSpace(), (Object)10000.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getSavedQueryRowCount(), (Object)330.0);
        bsp = new BitSetPlus(3);
        bsp.set(1);
        AggregateImpl aggregate2 = new AggregateImpl((Schema)schema, bsp);
        cb = lattice.costBenefitOf(aggregate2);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getLoadTime(), (Object)1000.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getRowCount(), (Object)10.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getSpace(), (Object)10000.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getSavedQueryRowCount(), (Object)330.0);
        bsp = new BitSetPlus(3);
        bsp.set(0);
        bsp.set(2);
        AggregateImpl aggregate3 = new AggregateImpl((Schema)schema, bsp);
        cb = lattice.costBenefitOf(aggregate3);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getLoadTime(), (Object)1000.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getRowCount(), (Object)100.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getSpace(), (Object)100000.0);
        MonteCarloLatticeImplTest.assertEquals((Object)cb.getSavedQueryRowCount(), (Object)149.99999999999997);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cb.describe(pw);
        MonteCarloLatticeImplTest.assertTrue((sw.toString().indexOf("used by 16% of queries") >= 0 ? 1 : 0) != 0);
    }
}

