/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.CreateScriptGenerator;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.OutputFactory;
import org.pentaho.aggdes.output.OutputValidationException;
import org.pentaho.aggdes.output.PopulateScriptGenerator;
import org.pentaho.aggdes.output.impl.OutputServiceImpl;
import org.pentaho.aggdes.test.algorithm.impl.AggregateStub;
import org.pentaho.aggdes.test.algorithm.impl.SchemaStub;

public class OutputServiceImplTest
extends TestCase {
    public void testInit() throws OutputValidationException {
        SchemaStub schema = new SchemaStub();
        OutputServiceImpl outputServiceImpl = new OutputServiceImpl();
        outputServiceImpl.getOutputFactories().clear();
        outputServiceImpl.getArtifactGenerators().clear();
        OutputFactoryTestImpl outputFactoryTestImpl = new OutputFactoryTestImpl();
        outputServiceImpl.getOutputFactories().add(outputFactoryTestImpl);
        AggregateStub aggregate = new AggregateStub();
        outputFactoryTestImpl.canCreate = true;
        Output output = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        OutputServiceImplTest.assertEquals((Object)((OutputTestImpl)output).getSchema(), null);
        outputServiceImpl.init((Schema)schema);
        output = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        OutputServiceImplTest.assertEquals((Object)((OutputTestImpl)output).getSchema(), (Object)schema);
        outputServiceImpl = new OutputServiceImpl((Schema)schema);
        outputServiceImpl.getOutputFactories().clear();
        outputServiceImpl.getArtifactGenerators().clear();
        outputServiceImpl.getOutputFactories().add(outputFactoryTestImpl);
        output = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        OutputServiceImplTest.assertEquals((Object)((OutputTestImpl)output).getSchema(), (Object)schema);
    }

    public void testGenerateDefaultOutput() throws OutputValidationException {
        SchemaStub schema = new SchemaStub();
        OutputServiceImpl outputServiceImpl = new OutputServiceImpl();
        outputServiceImpl.getOutputFactories().clear();
        outputServiceImpl.getArtifactGenerators().clear();
        OutputFactoryTestImpl outputFactoryTestImpl = new OutputFactoryTestImpl();
        ArrayList<OutputFactoryTestImpl> outputFactories = new ArrayList<OutputFactoryTestImpl>();
        outputFactories.add(outputFactoryTestImpl);
        outputServiceImpl.setOutputFactories(outputFactories);
        AggregateStub aggregate = new AggregateStub();
        outputFactoryTestImpl.canCreate = true;
        Output output = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        OutputServiceImplTest.assertTrue((boolean)(output instanceof OutputTestImpl));
        outputFactoryTestImpl.canCreate = false;
        try {
            outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate Output Factory.") >= 0 ? 1 : 0) != 0);
        }
        try {
            outputServiceImpl.generateDefaultOutput(null);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("No Aggregate Provided.") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGenerateArtifact() throws OutputValidationException {
        SchemaStub schema = new SchemaStub();
        OutputServiceImpl outputServiceImpl = new OutputServiceImpl();
        outputServiceImpl.getOutputFactories().clear();
        outputServiceImpl.getArtifactGenerators().clear();
        OutputFactoryTestImpl outputFactoryTestImpl = new OutputFactoryTestImpl();
        outputServiceImpl.getOutputFactories().add(outputFactoryTestImpl);
        ArtifactGeneratorTestImpl artgen = new ArtifactGeneratorTestImpl();
        ArrayList<ArtifactGeneratorTestImpl> artgens = new ArrayList<ArtifactGeneratorTestImpl>();
        artgens.add(artgen);
        outputServiceImpl.setArtifactGenerators(artgens);
        AggregateStub aggregate = new AggregateStub();
        outputFactoryTestImpl.canCreate = true;
        artgen.canGenerate = true;
        Output output = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        ((OutputTestImpl)output).uniqueName = "output-01";
        String results = outputServiceImpl.getArtifact(output, CreateScriptGenerator.class);
        OutputServiceImplTest.assertEquals((String)"generated output-01", (String)results);
        ((OutputTestImpl)output).uniqueName = "output-02";
        results = outputServiceImpl.getArtifact(output, ArtifactGeneratorTestImpl.class);
        OutputServiceImplTest.assertEquals((String)"generated output-02", (String)results);
        try {
            outputServiceImpl.getArtifact(output, null);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertEquals((String)"No Generator Provided", (String)e.getMessage());
        }
        try {
            outputServiceImpl.getArtifact(null, ArtifactGeneratorTestImpl.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertEquals((String)"No Output Provided", (String)e.getMessage());
        }
        try {
            outputServiceImpl.getArtifact(null, null);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertEquals((String)"No Output Provided", (String)e.getMessage());
        }
        try {
            outputServiceImpl.getArtifact(output, PopulateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate generator of type interface org.pentaho.aggdes.output.PopulateScriptGenerator") >= 0 ? 1 : 0) != 0);
        }
        try {
            outputServiceImpl.getArtifact((Output)new SecondOutputTestImpl((Schema)schema, (Aggregate)aggregate), CreateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate generator of type interface org.pentaho.aggdes.output.CreateScriptGenerator") >= 0 ? 1 : 0) != 0);
        }
        artgen.canGenerate = false;
        try {
            outputServiceImpl.getArtifact(output, CreateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate generator of type interface org.pentaho.aggdes.output.CreateScriptGenerator") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGenerateFullArtifact() throws OutputValidationException {
        SchemaStub schema = new SchemaStub();
        OutputServiceImpl outputServiceImpl = new OutputServiceImpl();
        outputServiceImpl.getOutputFactories().clear();
        outputServiceImpl.getArtifactGenerators().clear();
        OutputFactoryTestImpl outputFactoryTestImpl = new OutputFactoryTestImpl();
        outputServiceImpl.getOutputFactories().add(outputFactoryTestImpl);
        ArtifactGeneratorTestImpl artgen = new ArtifactGeneratorTestImpl();
        outputServiceImpl.getArtifactGenerators().add(artgen);
        AggregateStub aggregate = new AggregateStub();
        outputFactoryTestImpl.canCreate = true;
        artgen.canGenerate = true;
        ArrayList<Output> outputs = new ArrayList<Output>();
        Output output1 = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        outputs.add(output1);
        Output output2 = outputServiceImpl.generateDefaultOutput((Aggregate)aggregate);
        outputs.add(output2);
        ((OutputTestImpl)output1).uniqueName = "output-01";
        ((OutputTestImpl)output2).uniqueName = "output-02";
        String results = outputServiceImpl.getFullArtifact(outputs, CreateScriptGenerator.class);
        OutputServiceImplTest.assertEquals((String)"generated output-01\ngenerated output-02\n", (String)results);
        ((OutputTestImpl)output1).uniqueName = "output-03";
        ((OutputTestImpl)output2).uniqueName = "output-04";
        results = outputServiceImpl.getFullArtifact(outputs, ArtifactGeneratorTestImpl.class);
        OutputServiceImplTest.assertEquals((String)"generated output-03\ngenerated output-04\n", (String)results);
        try {
            outputServiceImpl.getFullArtifact(outputs, null);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertEquals((String)"No Generator Provided", (String)e.getMessage());
        }
        try {
            outputServiceImpl.getFullArtifact(null, ArtifactGeneratorTestImpl.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertEquals((String)"No Output Provided", (String)e.getMessage());
        }
        try {
            outputServiceImpl.getArtifact(null, null);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertEquals((String)"No Output Provided", (String)e.getMessage());
        }
        try {
            outputServiceImpl.getFullArtifact(outputs, PopulateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate generator of type interface org.pentaho.aggdes.output.PopulateScriptGenerator") >= 0 ? 1 : 0) != 0);
        }
        ArrayList<SecondOutputTestImpl> secondOutputs = new ArrayList<SecondOutputTestImpl>();
        secondOutputs.add(new SecondOutputTestImpl((Schema)schema, (Aggregate)aggregate));
        try {
            outputServiceImpl.getFullArtifact(secondOutputs, CreateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate generator of type interface org.pentaho.aggdes.output.CreateScriptGenerator") >= 0 ? 1 : 0) != 0);
        }
        artgen.canGenerate = false;
        try {
            outputServiceImpl.getFullArtifact(outputs, CreateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Failed to locate generator of type interface org.pentaho.aggdes.output.CreateScriptGenerator") >= 0 ? 1 : 0) != 0);
        }
        artgen.canGenerate = false;
        outputServiceImpl.getArtifactGenerators().add(new SmartArtifactGeneratorTestImpl());
        outputs.add(new SecondOutputTestImpl(null, null));
        try {
            outputServiceImpl.getFullArtifact(outputs, CreateScriptGenerator.class);
            OutputServiceImplTest.fail();
        }
        catch (OutputValidationException e) {
            OutputServiceImplTest.assertTrue((e.getMessage().indexOf("Generator org.pentaho.aggdes.test.OutputServiceImplTest$SmartArtifactGeneratorTestImpl cannot generate output") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testClassList() {
        OutputServiceImpl outputServiceImpl = new OutputServiceImpl();
        outputServiceImpl.getOutputFactories().clear();
        outputServiceImpl.getArtifactGenerators().clear();
        ArtifactGeneratorTestImpl artgen = new ArtifactGeneratorTestImpl();
        outputServiceImpl.getArtifactGenerators().add(artgen);
        Class[] classes = outputServiceImpl.getSupportedArtifactGeneratorClasses();
        OutputServiceImplTest.assertNotNull((Object)classes);
        OutputServiceImplTest.assertEquals((int)classes.length, (int)0);
        OutputFactoryTestImpl outputFactoryTestImpl = new OutputFactoryTestImpl();
        outputServiceImpl.getOutputFactories().add(outputFactoryTestImpl);
        classes = outputServiceImpl.getSupportedArtifactGeneratorClasses();
        OutputServiceImplTest.assertNotNull((Object)classes);
        OutputServiceImplTest.assertEquals((int)classes.length, (int)0);
        outputFactoryTestImpl.canCreate = true;
        classes = outputServiceImpl.getSupportedArtifactGeneratorClasses();
        OutputServiceImplTest.assertNotNull((Object)classes);
        OutputServiceImplTest.assertEquals((int)classes.length, (int)1);
        OutputServiceImplTest.assertEquals((Object)classes[0], ArtifactGeneratorTestImpl.class);
        artgen.classes = new Class[]{String.class};
        classes = outputServiceImpl.getSupportedArtifactGeneratorClasses();
        OutputServiceImplTest.assertNotNull((Object)classes);
        OutputServiceImplTest.assertEquals((int)classes.length, (int)0);
    }

    public static class SmartArtifactGeneratorTestImpl
    implements CreateScriptGenerator {
        public Class[] classes = new Class[]{OutputTestImpl.class};

        public boolean canGenerate(Schema schema, Output output) {
            return output instanceof OutputTestImpl;
        }

        public String generate(Schema schema, Output output) {
            return "generated " + ((OutputTestImpl)output).uniqueName;
        }

        public String generateFull(Schema schema, List<? extends Output> outputs) {
            StringBuilder sb = new StringBuilder();
            for (Output output : outputs) {
                sb.append(this.generate(schema, output)).append("\n");
            }
            return sb.toString();
        }

        public Class[] getSupportedOutputClasses() {
            return this.classes;
        }
    }

    public static class ArtifactGeneratorTestImpl
    implements CreateScriptGenerator {
        public boolean canGenerate = false;
        public Class[] classes = new Class[]{OutputTestImpl.class};

        public boolean canGenerate(Schema schema, Output output) {
            return this.canGenerate;
        }

        public String generate(Schema schema, Output output) {
            return "generated " + ((OutputTestImpl)output).uniqueName;
        }

        public String generateFull(Schema schema, List<? extends Output> outputs) {
            StringBuilder sb = new StringBuilder();
            for (Output output : outputs) {
                sb.append(this.generate(schema, output)).append("\n");
            }
            return sb.toString();
        }

        public Class[] getSupportedOutputClasses() {
            return this.classes;
        }
    }

    public static class OutputFactoryTestImpl
    implements OutputFactory {
        boolean canCreate = false;

        public boolean canCreateOutput(Schema schema) {
            return this.canCreate;
        }

        public Output createOutput(Schema schema, Aggregate aggregate) {
            return new OutputTestImpl(schema, aggregate);
        }

        public Class<? extends Output> getOutputClass() {
            return OutputTestImpl.class;
        }

        public List<Output> createOutputs(Schema schema, List<Aggregate> aggregates) {
            ArrayList<Output> outputs = new ArrayList<Output>();
            for (Aggregate aggregate : aggregates) {
                outputs.add(this.createOutput(schema, aggregate));
            }
            return outputs;
        }
    }

    public static class SecondOutputTestImpl
    implements Output {
        public Schema schema;
        public Aggregate aggregate;
        public String uniqueName = "output-00";

        public SecondOutputTestImpl(Schema schema, Aggregate aggregate) {
            this.schema = schema;
            this.aggregate = aggregate;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }
    }

    public static class OutputTestImpl
    implements Output {
        public Schema schema;
        public Aggregate aggregate;
        public String uniqueName = "output-00";

        public OutputTestImpl(Schema schema, Aggregate aggregate) {
            this.schema = schema;
            this.aggregate = aggregate;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }
    }
}

