/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import junit.framework.TestCase;
import mondrian.olap.DriverManager;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.aggdes.model.ssas.ConversionUtil;
import org.pentaho.aggdes.test.util.TestUtils;

public class SsasToMondrianTest
extends TestCase {
    @BeforeClass
    public static void setUpDriver() throws Exception {
        TestUtils.registerDriver((String)TestUtils.getTestProperty((String)"test.jdbc.driver.classpath", (Object[])new Object[0]), (String)TestUtils.getTestProperty((String)"test.jdbc.driver.classname", (Object[])new Object[0]));
    }

    @AfterClass
    public static void tearDownDriver() throws Exception {
        TestUtils.deregisterDriver((String)TestUtils.getTestProperty((String)"test.jdbc.driver.classpath", (Object[])new Object[0]), (String)TestUtils.getTestProperty((String)"test.jdbc.driver.classname", (Object[])new Object[0]));
    }

    @Test
    public void testSchemaConversion() throws Exception {
        List docs = ConversionUtil.generateMondrianDocsFromSSASSchema((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/combined_ssas.xml"));
        PrintWriter pw = new PrintWriter(new FileWriter("output_foodmart.xml"));
        pw.println(((Document)docs.get(0)).asXML());
        pw.close();
        pw = new PrintWriter(new FileWriter("output_adventureworks.xml"));
        pw.println(((Document)docs.get(1)).asXML());
        pw.close();
    }

    @Test
    public void testSSASMgmtXmlaExportConversion() throws Exception {
        List docs = ConversionUtil.generateMondrianDocsFromSSASSchema((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/ssas-dump-via-mgmt-studio-xmla.xml"));
        PrintWriter pw = new PrintWriter(new FileWriter("output_foodmart_export.xml"));
        pw.println(((Document)docs.get(0)).asXML());
        pw.close();
    }

    @Test
    public void loadConvertedSchemaInMondrian() throws Exception {
        File tmpFile = File.createTempFile("output_foodmart_", ".xml");
        List docs = ConversionUtil.generateMondrianDocsFromSSASSchema((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/analysis_server_output.xml"));
        FileUtils.writeStringToFile((File)tmpFile, (String)((Document)docs.get(0)).asXML());
        String connectString = TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString", (Object[])new Object[]{TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.provider", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.jdbc", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.username", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.password", (Object[])new Object[0]), tmpFile.getPath()});
        DriverManager.getConnection((String)connectString, null).getSchema();
    }

    @Test
    public void checkConvertedSchema() throws Exception {
        List docs = ConversionUtil.generateMondrianDocsFromSSASSchema((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/ssas-dump-via-mgmt-studio-click.xml"));
        Document schemaDoc = (Document)docs.get(0);
        System.out.println(((Document)docs.get(0)).asXML());
        SsasToMondrianTest.assertNotNull((Object)schemaDoc.selectSingleNode("/Schema"));
        SsasToMondrianTest.assertTrue((schemaDoc.selectNodes("/Schema/Cube").size() > 0 ? 1 : 0) != 0);
        SsasToMondrianTest.assertNotNull((Object)schemaDoc.selectSingleNode("/Schema/Cube[@name='Internet Sales']"));
    }
}

