/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import mondrian.spi.Dialect;
import org.junit.Ignore;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.mondrian.MondrianDialect;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.impl.AggregateTableOutput;
import org.pentaho.aggdes.output.impl.CreateTableGenerator;
import org.pentaho.aggdes.output.impl.PopulateTableGenerator;
import org.pentaho.aggdes.output.impl.ResultHandlerImpl;
import org.pentaho.aggdes.test.util.TestAggregate;
import org.pentaho.aggdes.test.util.TestResult;
import org.pentaho.aggdes.test.util.TestUtils;

public class TableGeneratorTest
extends TestCase {
    protected String connectString;

    public void setUp() throws Exception {
        System.out.println("SETUP");
        this.connectString = TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString", (Object[])new Object[]{TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.provider", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.jdbc", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.username", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.password", (Object[])new Object[0]), TestUtils.getTestProperty((String)"test.mondrian.foodmart.connectString.catalog", (Object[])new Object[0])});
        System.out.println(this.connectString);
        TestUtils.registerDriver((String)TestUtils.getTestProperty((String)"test.jdbc.driver.classpath", (Object[])new Object[0]), (String)TestUtils.getTestProperty((String)"test.jdbc.driver.classname", (Object[])new Object[0]));
    }

    @Ignore
    public void _testBasicTableGen() {
        String expectedResults;
        MondrianSchemaLoader loader = new MondrianSchemaLoader();
        HashMap parameterValues = new HashMap();
        System.out.println("CONN STR: " + this.connectString);
        parameterValues.put(loader.getParameters().get(0), this.connectString);
        parameterValues.put(loader.getParameters().get(1), "Sales");
        Schema schema = loader.createSchema(parameterValues);
        TestResult result = new TestResult();
        TestAggregate aggregate = new TestAggregate();
        aggregate.addAttribute((Attribute)schema.getAttributes().get(3));
        aggregate.addAttribute((Attribute)schema.getAttributes().get(12));
        for (Measure measure : schema.getMeasures()) {
            aggregate.addMeasure(measure);
        }
        result.addAggregate((Aggregate)aggregate);
        AggregateTableOutput output = new AggregateTableOutput((Aggregate)aggregate);
        output.setTableName("table_01");
        output.setCatalogName("cat_01");
        output.setSchemaName("schema_01");
        TableGeneratorTest.assertEquals((String)output.getTableName(), (String)"table_01");
        TableGeneratorTest.assertEquals((String)output.getCatalogName(), (String)"cat_01");
        TableGeneratorTest.assertEquals((String)output.getSchemaName(), (String)"schema_01");
        output.setCatalogName(null);
        output.setSchemaName(null);
        output.getColumnOutputs().add(new AggregateTableOutput.ColumnOutput("column_01", (Attribute)aggregate.getAttributes().get(0)));
        output.getColumnOutputs().add(new AggregateTableOutput.ColumnOutput("column_02", (Attribute)aggregate.getAttributes().get(1)));
        int n = 1;
        for (Measure measure : aggregate.getMeasures()) {
            output.getColumnOutputs().add(new AggregateTableOutput.ColumnOutput("measure_0" + n, (Attribute)measure));
            ++n;
        }
        ArrayList<AggregateTableOutput> outputs = new ArrayList<AggregateTableOutput>();
        outputs.add(output);
        CreateTableGenerator createGenerator = new CreateTableGenerator();
        Class[] clazzes = createGenerator.getSupportedOutputClasses();
        TableGeneratorTest.assertEquals((int)clazzes.length, (int)1);
        TableGeneratorTest.assertEquals((Object)clazzes[0], AggregateTableOutput.class);
        AggregateTableOutput aggTableOutput = new AggregateTableOutput(null);
        TableGeneratorTest.assertTrue((boolean)createGenerator.canGenerate(schema, (Output)aggTableOutput));
        if (((MondrianDialect)schema.getDialect()).getMondrianDialect().getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            expectedResults = TestUtils.fold((String)"-- Aggregate table table_01\n-- Estimated 0 rows, 0 bytes\nCREATE TABLE \"table_01\" (\n    \"column_01\" VARCHAR2(30),\n    \"column_02\" VARCHAR2(60),\n    \"measure_01\" DECIMAL(10,4),\n    \"measure_02\" DECIMAL(10,4),\n    \"measure_03\" DECIMAL(10,4),\n    \"measure_04\" INTEGER,\n    \"measure_05\" INTEGER,\n    \"measure_06\" DECIMAL(10,4),\n    \"measure_07\" INTEGER);\n");
            TableGeneratorTest.assertEquals((String)expectedResults, (String)createGenerator.generate(schema, (Output)output));
            TableGeneratorTest.assertEquals((String)expectedResults, (String)createGenerator.generateFull(schema, outputs));
        } else if (((MondrianDialect)schema.getDialect()).getMondrianDialect().getDatabaseProduct() == Dialect.DatabaseProduct.MYSQL) {
            expectedResults = TestUtils.fold((String)"-- Aggregate table table_01\n-- Estimated 0 rows, 0 bytes\nCREATE TABLE `table_01` (\n    `column_01` VARCHAR(30),\n    `column_02` VARCHAR(30),\n    `measure_01` DOUBLE,\n    `measure_02` DOUBLE,\n    `measure_03` DOUBLE,\n    `measure_04` INTEGER,\n    `measure_05` INTEGER,\n    `measure_06` DOUBLE,\n    `measure_07` INTEGER);\n");
            TableGeneratorTest.assertEquals((String)expectedResults, (String)createGenerator.generate(schema, (Output)output));
        }
        PopulateTableGenerator popGenerator = new PopulateTableGenerator();
        clazzes = popGenerator.getSupportedOutputClasses();
        TableGeneratorTest.assertEquals((int)clazzes.length, (int)1);
        TableGeneratorTest.assertEquals((Object)clazzes[0], AggregateTableOutput.class);
        aggTableOutput = new AggregateTableOutput(null);
        TableGeneratorTest.assertTrue((boolean)popGenerator.canGenerate(schema, (Output)aggTableOutput));
        if (((MondrianDialect)schema.getDialect()).getMondrianDialect().getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            TableGeneratorTest.assertEquals((String)TestUtils.fold((String)"-- Populate aggregate table table_01\nINSERT INTO \"table_01\" (\n    \"column_01\",\n    \"column_02\",\n    \"measure_01\")\nselect \n    \"store\".\"store_name\" as \"column_01\", \n    \"product_class\".\"product_family\" as \"column_02\", \n    sum(\"sales_fact_1997\".\"unit_sales\") as \"measure_01\", \n    sum(\"sales_fact_1997\".\"store_cost\") as \"measure_02\", \n    sum(\"sales_fact_1997\".\"store_sales\") as \"measure_03\", \n    count(\"sales_fact_1997\".\"product_id\") as \"measure_04\", \n    count(distinct \"sales_fact_1997\".\"customer_id\") as \"measure_05\", \n    sum((case when \"sales_fact_1997\".\"promotion_id\" = 0 then 0 else \"sales_fact_1997\".\"store_sales\" end)) as \"measure_06\", \n    count(*) as \"measure_07\"\nfrom \n    \"sales_fact_1997\" \"sales_fact_1997\", \n    \"store\" \"store\", \n    \"product_class\" \"product_class\",\n    \"product\" \"product\"\nwhere \n    \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \n    \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \n    \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\ngroup by \n    \"store\".\"store_name\", \n    \"product_class\".\"product_family\";\n"), (String)popGenerator.generate(schema, (Output)output));
        } else if (((MondrianDialect)schema.getDialect()).getMondrianDialect().getDatabaseProduct() == Dialect.DatabaseProduct.MYSQL) {
            TableGeneratorTest.assertEquals((String)TestUtils.fold((String)"-- Populate aggregate table table_01\nINSERT INTO `table_01` (\n    `column_01`,\n    `column_02`,\n    `measure_01`,\n    `measure_02`,\n    `measure_03`,\n    `measure_04`,\n    `measure_05`,\n    `measure_06`,\n    `measure_07`)\nselect\n    `store`.`store_name` as `column_01`,\n    `product_class`.`product_department` as `column_02`,\n    sum(`sales_fact_1997`.`unit_sales`) as `measure_01`,\n    sum(`sales_fact_1997`.`store_cost`) as `measure_02`,\n    sum(`sales_fact_1997`.`store_sales`) as `measure_03`,\n    count(`sales_fact_1997`.`product_id`) as `measure_04`,\n    count(distinct `sales_fact_1997`.`customer_id`) as `measure_05`,\n    sum((case when `sales_fact_1997`.`promotion_id` = 0 then 0 else `sales_fact_1997`.`store_sales` end)) as `measure_06`,\n    count(*) as `measure_07`\nfrom\n    `sales_fact_1997` as `sales_fact_1997`,\n    `store` as `store`,\n    `product_class` as `product_class`,\n    `product` as `product`\nwhere\n    `sales_fact_1997`.`store_id` = `store`.`store_id`\nand\n    `sales_fact_1997`.`product_id` = `product`.`product_id`\nand\n    `product`.`product_class_id` = `product_class`.`product_class_id`\ngroup by\n    `store`.`store_name`,\n    `product_class`.`product_department`;\n"), (String)popGenerator.generate(schema, (Output)output));
        }
    }

    public void testDummy() {
    }

    @Ignore
    public void _testResultHandlerImpl() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        PrintStream orig = System.out;
        System.setOut(pw);
        MondrianSchemaLoader loader = new MondrianSchemaLoader();
        HashMap parameterValues = new HashMap();
        System.out.println("CONN STR: " + this.connectString);
        parameterValues.put(loader.getParameters().get(0), this.connectString);
        parameterValues.put(loader.getParameters().get(1), "Sales");
        Schema schema = loader.createSchema(parameterValues);
        TestResult result = new TestResult();
        TestAggregate aggregate = new TestAggregate();
        aggregate.setCandidateTableName("candidate_01");
        aggregate.addAttribute((Attribute)schema.getAttributes().get(3));
        aggregate.addAttribute((Attribute)schema.getAttributes().get(12));
        for (Measure measure : schema.getMeasures()) {
            aggregate.addMeasure(measure);
        }
        result.addAggregate((Aggregate)aggregate);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        TableGeneratorTest.assertEquals((String)resultHandler.getName(), (String)"ResultHandlerImpl");
        TableGeneratorTest.assertEquals((int)resultHandler.getParameters().size(), (int)8);
        TableGeneratorTest.assertEquals((boolean)((Parameter)resultHandler.getParameters().get(0)).isRequired(), (boolean)false);
        TableGeneratorTest.assertEquals((Object)((Parameter)resultHandler.getParameters().get(0)).getType(), (Object)Parameter.Type.BOOLEAN);
        TableGeneratorTest.assertEquals((String)((Parameter)resultHandler.getParameters().get(0)).getDescription(), (String)"Whether to output CREATE TABLE statements.");
        TableGeneratorTest.assertEquals((String)((Parameter)resultHandler.getParameters().get(0)).getName(), (String)"tables");
        HashMap params = new HashMap();
        params.put(resultHandler.getParameters().get(0), true);
        params.put(resultHandler.getParameters().get(4), true);
        params.put(resultHandler.getParameters().get(6), true);
        resultHandler.handle(params, schema, (Result)result);
        String results = baos.toString();
        TableGeneratorTest.assertTrue((results.indexOf("CREATE TABLE") >= 0 ? 1 : 0) != 0);
        TableGeneratorTest.assertTrue((results.indexOf("INSERT INTO") >= 0 ? 1 : 0) != 0);
        TableGeneratorTest.assertTrue((results.indexOf("<Schema") >= 0 ? 1 : 0) != 0);
        System.setOut(orig);
        File outputFile = new File("resulthandlerimpl_output.txt");
        if (outputFile.exists()) {
            outputFile.delete();
        }
        params.clear();
        params.put(resultHandler.getParameters().get(0), true);
        params.put(resultHandler.getParameters().get(1), "resulthandlerimpl_output.txt");
        resultHandler.handle(params, schema, (Result)result);
        TableGeneratorTest.assertTrue((boolean)outputFile.exists());
    }

    public String genJava(String str) {
        return str.replace("\"", "\\\"").replace("\n", "\\n\" + \n\"");
    }
}

