/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import mondrian.olap.MondrianDef;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.model.mondrian.validate.MondrianSchemaValidator;

public class ValidationMondrianSchemaLoaderTest
extends TestCase {
    private static final Log logger = LogFactory.getLog(ValidationMondrianSchemaLoaderTest.class);
    public static boolean myValidatorCalled;
    public static boolean myValidator2Called;
    private MondrianSchemaLoader bean = new MondrianSchemaLoader();
    private Map<Parameter, Object> parameterValues;
    private File tmpFile;

    @Before
    public void setUp() throws Exception {
        this.tmpFile = File.createTempFile("FoodMart", ".xml");
        FileOutputStream out = new FileOutputStream(this.tmpFile);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/FoodMart.xml");
        IOUtils.copy((InputStream)in, (OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        this.parameterValues = new HashMap<Parameter, Object>();
        this.parameterValues.put((Parameter)MondrianSchemaLoader.MondrianSchemaLoaderParameter.cube, "Sales");
        this.parameterValues.put((Parameter)MondrianSchemaLoader.MondrianSchemaLoaderParameter.connectString, "Provider=Mondrian;JdbcDrivers=org.hsqldb.jdbcDriver;Jdbc=jdbc:hsqldb:mem:test;JdbcUser=sa;JdbcPassword=;Catalog=file:" + this.tmpFile.getAbsolutePath());
        myValidatorCalled = false;
        myValidator2Called = false;
    }

    @After
    public void tearDown() throws Exception {
        this.parameterValues = null;
        if (null != this.tmpFile && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }

    @Test
    public void testValidateSchemaNoValidators() {
        this.parameterValues.put((Parameter)MondrianSchemaLoader.MondrianSchemaLoaderParameter.validators, null);
        List messages = this.bean.validateSchema(this.parameterValues);
        logger.debug((Object)("got messages: " + messages));
        ValidationMondrianSchemaLoaderTest.assertTrue((boolean)messages.isEmpty());
    }

    @Test
    public void testValidateSchemaOneValidator() {
        this.parameterValues.put((Parameter)MondrianSchemaLoader.MondrianSchemaLoaderParameter.validators, "org.pentaho.aggdes.test.ValidationMondrianSchemaLoaderTest$MyValidator");
        List messages = this.bean.validateSchema(this.parameterValues);
        logger.debug((Object)("got messages: " + messages));
        ValidationMondrianSchemaLoaderTest.assertTrue((boolean)myValidatorCalled);
    }

    @Test
    public void testValidateSchemaTwoValidators() {
        this.parameterValues.put((Parameter)MondrianSchemaLoader.MondrianSchemaLoaderParameter.validators, "org.pentaho.aggdes.test.ValidationMondrianSchemaLoaderTest$MyValidator,org.pentaho.aggdes.test.ValidationMondrianSchemaLoaderTest$MyValidator2");
        List messages = this.bean.validateSchema(this.parameterValues);
        logger.debug((Object)("got messages: " + messages));
        ValidationMondrianSchemaLoaderTest.assertTrue((boolean)myValidatorCalled);
        ValidationMondrianSchemaLoaderTest.assertTrue((boolean)myValidator2Called);
    }

    @Test
    public void testValidationMessage() {
        ValidationMessage ok = new ValidationMessage(ValidationMessage.Type.OK, "ok");
        ValidationMessage error = new ValidationMessage(ValidationMessage.Type.ERROR, "error");
        ValidationMessage warning1 = new ValidationMessage(ValidationMessage.Type.WARNING, "warning");
        ValidationMessage warning2 = new ValidationMessage(ValidationMessage.Type.WARNING, "warning2");
        ValidationMessage warning3 = new ValidationMessage(ValidationMessage.Type.WARNING, "warning");
        ValidationMondrianSchemaLoaderTest.assertEquals((String)ok.getMessage(), (String)"ok");
        ValidationMondrianSchemaLoaderTest.assertEquals((Object)ok.getType(), (Object)ValidationMessage.Type.OK);
        ValidationMondrianSchemaLoaderTest.assertEquals((String)ok.toString(), (String)"ValidationMessage[type=OK,message=\"ok\"]");
        ValidationMondrianSchemaLoaderTest.assertEquals((int)ok.compareTo(error), (int)1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)ok.compareTo(warning1), (int)1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)warning1.compareTo(error), (int)1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)warning1.compareTo(ok), (int)-1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)error.compareTo(ok), (int)-1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)error.compareTo(warning1), (int)-1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)warning1.compareTo(warning2), (int)-1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)warning2.compareTo(warning1), (int)1);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)warning1.compareTo(warning3), (int)0);
        ValidationMondrianSchemaLoaderTest.assertEquals((int)warning3.compareTo(warning1), (int)0);
    }

    public static class MyValidator2
    implements MondrianSchemaValidator {
        public List<ValidationMessage> validateCube(MondrianDef.Schema schema, MondrianDef.Cube cube, Connection conn) {
            myValidator2Called = true;
            return Collections.emptyList();
        }
    }

    public static class MyValidator
    implements MondrianSchemaValidator {
        public List<ValidationMessage> validateCube(MondrianDef.Schema schema, MondrianDef.Cube cube, Connection conn) {
            myValidatorCalled = true;
            return Collections.emptyList();
        }
    }
}

