/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.Progress;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.SchemaLoader;
import org.pentaho.aggdes.output.ResultHandler;

public class Main {
    private final PrintWriter pw = new PrintWriter(System.out);
    private final String[] args;
    private SchemaLoader loader;
    private Algorithm algorithm;
    private ResultHandler resultHandler;
    private final Map<String, String> loaderRawParams = new LinkedHashMap<String, String>();
    private final Map<String, String> algorithmRawParams = new LinkedHashMap<String, String>();
    private final Map<String, String> resultHandlerRawParams = new LinkedHashMap<String, String>();

    private Main(String[] args) {
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Main main = new Main(args);
        try {
            main.run();
        }
        finally {
            main.pw.flush();
        }
    }

    private void usage(Component component) {
        this.pw.println("Usage: java " + Main.class.getName());
        this.pw.println("  --help");
        this.pw.println("  --loaderClass <class>");
        this.pw.println("  [ --loaderParam <name> <value> ]...");
        this.pw.println("  --algorithmClass <class>");
        this.pw.println("  [ --algorithmParam <name> <value> ]...");
        this.pw.println("  --resultClass <class>");
        this.pw.println("  [ --resultParam <name> <value> ]...");
        if (component != null) {
            this.pw.println();
            this.pw.println("Parameters for component " + component.getName() + " are:");
            for (Parameter parameter : component.getParameters()) {
                String desc = "  " + parameter.getName() + " (" + parameter.getType() + (parameter.isRequired() ? ", required" : "") + ") " + parameter.getDescription();
                this.pw.println(desc);
            }
        }
    }

    private void parseArgs() {
        assert (this.loader == null);
        assert (this.algorithm == null);
        assert (this.loaderRawParams.isEmpty());
        assert (this.algorithmRawParams.isEmpty());
        ListIterator<String> argIter = Arrays.asList(this.args).listIterator();
        while (argIter.hasNext()) {
            String arg = argIter.next();
            if (arg.equals("--loaderClass")) {
                this.loader = this.readComponentClass(argIter, SchemaLoader.class);
                continue;
            }
            if (arg.equals("--loaderParam")) {
                this.readParam(arg, argIter, this.loaderRawParams, (Component)this.loader);
                continue;
            }
            if (arg.equals("--algorithmClass")) {
                this.algorithm = this.readComponentClass(argIter, Algorithm.class);
                continue;
            }
            if (arg.equals("--algorithmParam")) {
                this.readParam(arg, argIter, this.algorithmRawParams, (Component)this.algorithm);
                continue;
            }
            if (arg.equals("--resultClass")) {
                this.resultHandler = this.readComponentClass(argIter, ResultHandler.class);
                continue;
            }
            if (arg.equals("--resultParam")) {
                this.readParam(arg, argIter, this.resultHandlerRawParams, this.resultHandler);
                continue;
            }
            throw new ArgumentUtils.ValidationException(null, "Unknown parameter '" + arg + "'");
        }
        if (this.loader == null) {
            throw new ArgumentUtils.ValidationException(null, "Missing required component. Please specify '--loaderClass' argument");
        }
        if (this.algorithm == null) {
            throw new ArgumentUtils.ValidationException(null, "Missing required component. Please specify '--algorithmClass' argument");
        }
        if (this.resultHandler == null) {
            throw new ArgumentUtils.ValidationException(null, "Missing required component. Please specify '--resultClass' argument");
        }
    }

    private void readParam(String argName, ListIterator<String> argIter, Map<String, String> params, Component component) {
        if (argIter.hasNext()) {
            String paramName = argIter.next();
            if (argIter.hasNext()) {
                String paramValue = argIter.next();
                params.put(paramName, paramValue);
                return;
            }
        }
        throw new ArgumentUtils.ValidationException(component, "Expected arguments <name> <value> following " + argName);
    }

    private <T> T readComponentClass(ListIterator<String> argIter, Class<T> iface) {
        if (!argIter.hasNext()) {
            throw new ArgumentUtils.ValidationException(null, "Expected argument <className>");
        }
        String arg = argIter.next();
        try {
            Class<?> clazz = Class.forName(arg);
            if (!iface.isAssignableFrom(clazz)) {
                throw new ArgumentUtils.ValidationException(null, "Class '" + arg + "' does not implement required interface '" + iface.getName() + "'");
            }
            Object o = clazz.newInstance();
            return iface.cast(o);
        }
        catch (ClassNotFoundException e) {
            throw new ArgumentUtils.ValidationException(null, "Class '" + arg + "' not found");
        }
        catch (IllegalAccessException e) {
            throw new ArgumentUtils.ValidationException(null, "Error while instantiating class '" + arg + "'");
        }
        catch (InstantiationException e) {
            throw new ArgumentUtils.ValidationException(null, "Error while instantiating class '" + arg + "'");
        }
    }

    void run() {
        Map resultHandlerParams;
        Map algorithmParams;
        Map loaderParams;
        if (this.args.length == 0) {
            this.usage(null);
            return;
        }
        try {
            this.parseArgs();
            loaderParams = ArgumentUtils.validateParameters((Component)this.loader, this.loaderRawParams);
            algorithmParams = ArgumentUtils.validateParameters((Component)this.algorithm, this.algorithmRawParams);
            resultHandlerParams = ArgumentUtils.validateParameters((Component)this.resultHandler, this.resultHandlerRawParams);
        }
        catch (ArgumentUtils.ValidationException e) {
            this.pw.println(e.getMessage());
            this.usage(e.getComponent());
            return;
        }
        catch (RuntimeException e) {
            this.usage(null);
            return;
        }
        Schema schema = this.loader.createSchema(loaderParams);
        ArgumentUtils.TextProgress progress = new ArgumentUtils.TextProgress(this.pw);
        Result result = this.algorithm.run(schema, algorithmParams, (Progress)progress);
        if (result == null) {
            System.out.println("Algorithm was canceled.");
            return;
        }
        this.resultHandler.handle(resultHandlerParams, schema, result);
    }

    public static String depunctify(String name) {
        String s = name.replaceAll("[\\[\\]\\. _]+", "_");
        s = s.replaceAll("^_", "");
        s = s.replaceAll("_$", "");
        return s;
    }
}

