/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.sql.SqlQuery;
import org.pentaho.aggdes.Main;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dialect;
import org.pentaho.aggdes.model.Table;
import org.pentaho.aggdes.model.mondrian.MondrianDialect;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.model.mondrian.MondrianTable;

public class MondrianAttribute
implements Attribute {
    private final MondrianTable table;
    private final RolapStar.Column column;
    private final double distinctValueCount;
    private final List<Attribute> ancestors;

    public MondrianAttribute(MondrianTable table, List<Attribute> ancestors, RolapStar.Column column, double distinctValueCount) {
        this.table = table;
        this.column = column;
        this.distinctValueCount = distinctValueCount;
        this.ancestors = ancestors;
    }

    public RolapStar.Column getRolapStarColumn() {
        return this.column;
    }

    public String getLabel() {
        return "[" + this.table.getLabel() + "].[" + this.column.getName() + "]";
    }

    public Table getTable() {
        return this.table;
    }

    public double getDistinctValueCount() {
        return this.distinctValueCount;
    }

    public double estimateSpace() {
        return MondrianSchemaLoader.estimateSpaceForColumn(this.column);
    }

    public String getCandidateColumnName() {
        return Main.depunctify(this.getLabel());
    }

    public String getDatatype(Dialect dialect) {
        return this.internalGetDatatypeString(this.column, dialect);
    }

    private String internalGetDatatypeString(RolapStar.Column column, Dialect dialect) {
        mondrian.spi.Dialect mondrianDialect = ((MondrianDialect)dialect).getMondrianDialect();
        SqlQuery query = new SqlQuery(mondrianDialect);
        query.addFrom((MondrianDef.RelationOrJoin)column.getTable().getRelation(), column.getTable().getAlias(), false);
        query.addSelect(column.getExpression().getExpression(query), null);
        String sql = query.toString();
        Connection jdbcConnection = null;
        try {
            String[] words;
            String typeString;
            jdbcConnection = column.getStar().getDataSource().getConnection();
            PreparedStatement pstmt = jdbcConnection.prepareStatement(sql);
            pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = pstmt.getMetaData();
            assert (resultSetMetaData.getColumnCount() == 1);
            String type = resultSetMetaData.getColumnTypeName(1);
            int precision = resultSetMetaData.getPrecision(1);
            int scale = resultSetMetaData.getScale(1);
            if (type.equals("DOUBLE")) {
                precision = 0;
            }
            if (precision == 0 || precision == Integer.MAX_VALUE || !dialect.supportsPrecision(jdbcConnection.getMetaData(), type)) {
                typeString = type;
            } else if (scale == 0) {
                if (!resultSetMetaData.isSigned(1) && type.contains("UNSIGNED")) {
                    words = type.split("\\s+");
                    if (words.length > 1) {
                        String typeFirstWord = words[0];
                        String typeSignWord = words[1];
                        typeString = typeFirstWord + "(" + precision + ") " + typeSignWord;
                    } else {
                        typeString = type + "(" + precision + ")";
                    }
                } else {
                    typeString = type + "(" + precision + ")";
                }
            } else if (!resultSetMetaData.isSigned(1) && type.contains("UNSIGNED")) {
                words = type.split("\\s+");
                if (words.length > 1) {
                    String typeFirstWord = words[0];
                    String typeSignWord = words[1];
                    typeString = typeFirstWord + "(" + precision + ", " + scale + ")" + " " + typeSignWord;
                } else {
                    typeString = type + "(" + precision + ", " + scale + ")";
                }
            } else {
                typeString = type + "(" + precision + ", " + scale + ")";
            }
            pstmt.close();
            jdbcConnection.close();
            jdbcConnection = null;
            String string = typeString;
            return string;
        }
        catch (SQLException e) {
            throw Util.newError((Throwable)e, (String)("Error while deriving type of column " + this.toString() + ", sql: " + sql));
        }
        finally {
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public List<Attribute> getAncestorAttributes() {
        return this.ancestors;
    }
}

