/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import mondrian.spi.Dialect;
import org.pentaho.aggdes.model.Dialect;

public class MondrianDialect
implements Dialect {
    private final mondrian.spi.Dialect dialect;

    public MondrianDialect(mondrian.spi.Dialect dialect) {
        this.dialect = dialect;
    }

    public void quoteIdentifier(StringBuilder buf, String ... names) {
        this.dialect.quoteIdentifier(buf, names);
    }

    public String getIntegerTypeString() {
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.POSTGRESQL) {
            return "INT8";
        }
        return "INTEGER";
    }

    public String getDoubleTypeString() {
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            return "NUMBER";
        }
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.POSTGRESQL) {
            return "FLOAT8";
        }
        return "DOUBLE";
    }

    public String removeInvalidIdentifierCharacters(String str) {
        return str.replaceAll("\\s", "_").replaceAll("[^\\w_]", "");
    }

    public int getMaximumTableNameLength() {
        return 30;
    }

    public int getMaximumColumnNameLength() {
        return 30;
    }

    public mondrian.spi.Dialect getMondrianDialect() {
        return this.dialect;
    }

    public void comment(StringBuilder buf, String s) {
        buf.append("-- ").append(s).append(NL);
    }

    public void terminateCommand(StringBuilder buf) {
        buf.append(";").append(NL);
    }

    public boolean supportsPrecision(DatabaseMetaData meta, String type) throws SQLException {
        return meta.getDatabaseProductName().toUpperCase().indexOf("HSQL") < 0 && (this.dialect.getDatabaseProduct() != Dialect.DatabaseProduct.POSTGRESQL && this.dialect.getDatabaseProduct() != Dialect.DatabaseProduct.LUCIDDB || type.toUpperCase().indexOf("CHAR") >= 0);
    }
}

