/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Connection;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MondrianDef;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapStar;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dialect;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.StatisticsProvider;
import org.pentaho.aggdes.model.mondrian.Messages;
import org.pentaho.aggdes.model.mondrian.MondrianAttribute;
import org.pentaho.aggdes.model.mondrian.MondrianDialect;
import org.pentaho.aggdes.model.mondrian.MondrianDimension;
import org.pentaho.aggdes.model.mondrian.MondrianHierarchy;
import org.pentaho.aggdes.model.mondrian.MondrianLevel;
import org.pentaho.aggdes.model.mondrian.MondrianMeasure;
import org.pentaho.aggdes.model.mondrian.MondrianStatisticsProvider;
import org.pentaho.aggdes.model.mondrian.MondrianTable;

public class MondrianSchema
implements Schema {
    private static final Log logger = LogFactory.getLog(MondrianSchema.class);
    private final Connection connection;
    private final RolapCube cube;
    private final List<MondrianTable> tables = new ArrayList<MondrianTable>();
    private final List<MondrianDimension> dimensions = new ArrayList<MondrianDimension>();
    private final List<MondrianAttribute> attributes = new ArrayList<MondrianAttribute>();
    private final List<MondrianMeasure> measures = new ArrayList<MondrianMeasure>();
    private final StatisticsProvider statisticsProvider = new MondrianStatisticsProvider(this);
    private final Dialect dialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MondrianSchema(RolapConnection conn, RolapCube cube) {
        this.connection = conn;
        this.cube = cube;
        RolapStar star = cube.getStar();
        this.dialect = new MondrianDialect(star.getSqlQueryDialect());
        RolapStar.Table factTable = star.getFactTable();
        Locus locus = new Locus(new Execution(conn.getInternalStatement(), 0L), "MondrianSchema.init", "while loading the MondrianSchema into the Aggregation Designer.");
        Locus.push((Locus)locus);
        try {
            this.doTable(null, factTable);
            this.doCube(cube);
        }
        finally {
            Locus.pop((Locus)locus);
        }
    }

    public Connection getRolapConnection() {
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return this.connection.getDataSource().getConnection().getMetaData();
    }

    protected MondrianAttribute createAttribute(MondrianTable table, List<Attribute> ancestors, RolapStar.Column column, double distinctValueCount) {
        return new MondrianAttribute(table, ancestors, column, distinctValueCount);
    }

    protected MondrianMeasure createMeasure(MondrianTable table, RolapStar.Measure measure) {
        return new MondrianMeasure(table, measure);
    }

    private void doTable(MondrianTable parentTableImpl, RolapStar.Table table) {
        MondrianTable tableImpl = new MondrianTable(parentTableImpl, table);
        this.tables.add(tableImpl);
        for (RolapStar.Column column : table.getColumns()) {
            if (column instanceof RolapStar.Measure) {
                RolapStar.Measure measure = (RolapStar.Measure)column;
                if (!measure.getCubeName().equals(this.cube.getName()) || measure.getName().equals("Fact Count")) continue;
                this.measures.add(this.createMeasure(tableImpl, measure));
                continue;
            }
            double valueCount = column.getCardinality();
            ArrayList<Attribute> ancestors = new ArrayList<Attribute>();
            this.attributes.add(this.createAttribute(tableImpl, ancestors, column, valueCount));
        }
        if (parentTableImpl == null) {
            RolapStar.Measure cloneMeasure = null;
            for (RolapStar.Column column : table.getColumns()) {
                if (!(column instanceof RolapStar.Measure)) continue;
                cloneMeasure = (RolapStar.Measure)column;
            }
            MondrianDef.MeasureExpression expr = new MondrianDef.MeasureExpression();
            MondrianDef.SQL star = new MondrianDef.SQL();
            star.cdata = "*";
            star.dialect = "generic";
            expr.expressions = new MondrianDef.SQL[]{star};
            RolapStar.Measure factCount = null;
            try {
                factCount = new RolapStar.Measure("fact_count", cloneMeasure.getCubeName(), RolapAggregator.Count, cloneMeasure.getTable(), (MondrianDef.Expression)expr, Dialect.Datatype.Integer);
            }
            catch (IllegalAccessError e) {
                throw new RuntimeException(Messages.getString("MondrianSchemaLoader.ERROR_0001_MONDRIAN_DEPENDENCY_ERROR"), e);
            }
            this.measures.add(new MondrianMeasure(tableImpl, factCount));
        }
        for (RolapStar.Table childTable : table.getChildren()) {
            this.doTable(tableImpl, childTable);
        }
    }

    private void doCube(RolapCube cube) {
        ArrayList<MondrianAttribute> newAttributes = new ArrayList<MondrianAttribute>();
        for (Dimension dimension : cube.getDimensions()) {
            if (dimension.isMeasures()) continue;
            MondrianDimension dimensionImpl = new MondrianDimension(dimension.getName());
            for (Hierarchy hierarchy : dimension.getHierarchies()) {
                MondrianHierarchy hierarchyImpl = new MondrianHierarchy(hierarchy.getName());
                MondrianLevel parent = null;
                for (Level level : hierarchy.getLevels()) {
                    RolapCubeLevel cubeLevel = (RolapCubeLevel)level;
                    RolapStar.Column col = cubeLevel.getStarKeyColumn();
                    MondrianAttribute attribImpl = null;
                    for (MondrianAttribute attrib : this.attributes) {
                        if (col != attrib.getRolapStarColumn()) continue;
                        attribImpl = attrib;
                        if (newAttributes.contains(attrib)) continue;
                        newAttributes.add(attrib);
                    }
                    if (!level.isAll() && attribImpl == null) {
                        throw new RuntimeException("attribute not found for level: " + level.getName() + ", star column: " + col);
                    }
                    for (MondrianLevel ancestor = parent; ancestor != null; ancestor = ancestor.getParent()) {
                        if (ancestor.getAttribute() == null) continue;
                        attribImpl.getAncestorAttributes().add(0, ancestor.getAttribute());
                    }
                    MondrianLevel levelImpl = new MondrianLevel(parent, cubeLevel, level.getName(), attribImpl);
                    hierarchyImpl.addLevel(levelImpl);
                    parent = levelImpl;
                }
                dimensionImpl.addHierarchy(hierarchyImpl);
            }
            this.dimensions.add(dimensionImpl);
        }
        this.attributes.clear();
        this.attributes.addAll(newAttributes);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Schema Attributes: ");
            for (Attribute attribute : this.attributes) {
                logger.debug((Object)("   " + attribute.getLabel()));
            }
        }
    }

    public StatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    public List<MondrianTable> getTables() {
        return this.tables;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public List<MondrianDimension> getDimensions() {
        return this.dimensions;
    }

    public List<? extends Attribute> getAttributes() {
        return this.attributes;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String generateAggregateSql(Aggregate aggregate, List<String> columnNameList) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Attribute attribute : aggregate.getAttributes()) {
            list.add(((MondrianAttribute)attribute).getRolapStarColumn());
        }
        for (Measure measure : aggregate.getMeasures()) {
            list.add(((MondrianMeasure)measure).getRolapStarMeasure());
        }
        return this.cube.getStar().generateSql(list, columnNameList);
    }

    public RolapCube getRolapCube() {
        return this.cube;
    }
}

