/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import mondrian.olap.MondrianDef;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.sql.SqlQuery;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.StatisticsProvider;
import org.pentaho.aggdes.model.mondrian.MondrianAttribute;
import org.pentaho.aggdes.model.mondrian.MondrianDialect;
import org.pentaho.aggdes.model.mondrian.MondrianSchema;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;

public class MondrianStatisticsProvider
implements StatisticsProvider {
    private final MondrianSchema schema;
    private Double factRowCount;

    public MondrianStatisticsProvider(MondrianSchema schema) {
        this.schema = schema;
    }

    public double getFactRowCount() {
        if (this.factRowCount == null) {
            RolapConnection connection = this.schema.getRolapCube().getSchema().getInternalConnection();
            RolapMember m = MondrianStatisticsProvider.findCountMeasure(this.schema.getRolapCube());
            if (m != null) {
                // empty if block
            }
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = this.schema.getRolapCube().getSchema().getInternalConnection().getDataSource().getConnection();
                stmt = conn.createStatement();
                SqlQuery query = new SqlQuery(((MondrianDialect)this.schema.getDialect()).getMondrianDialect());
                query.addSelect("count(*)", SqlStatement.Type.DOUBLE);
                query.addFrom((MondrianDef.RelationOrJoin)this.schema.getRolapCube().getStar().getFactTable().getRelation(), null, true);
                String sql = query.toString();
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    this.factRowCount = rs.getDouble(1);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get a count from the fact table", e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return this.factRowCount;
    }

    private static RolapMember findCountMeasure(RolapCube cube) {
        for (RolapMember member : cube.getMeasuresMembers()) {
            RolapStoredMeasure measure;
            if (!(member instanceof RolapStoredMeasure) || (measure = (RolapStoredMeasure)member).getAggregator() != RolapAggregator.Count) continue;
            return member;
        }
        return null;
    }

    public double getRowCount(List<Attribute> attributes) {
        double comboCount = 1.0;
        for (Attribute attribute : attributes) {
            comboCount *= ((MondrianAttribute)attribute).getDistinctValueCount();
        }
        return MondrianSchemaLoader.estimateAggregateCount(comboCount, this.getFactRowCount());
    }

    public double getSpace(List<Attribute> attributes) {
        double space = 0.0;
        for (Attribute attribute : attributes) {
            space += attribute.estimateSpace();
        }
        return space;
    }

    public double getLoadTime(List<Attribute> attributes) {
        return this.getFactRowCount() * this.getSpace(this.schema.getAttributes()) + this.getRowCount(attributes) * this.getSpace(attributes);
    }
}

