/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import mondrian.olap.MondrianDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.MondrianSchemaValidator;
import org.pentaho.aggdes.model.mondrian.validate.MondrianSchemaValidatorManager;

public class ValidationHelper {
    private static final Log logger = LogFactory.getLog(ValidationHelper.class);

    public static String messagesToString(List<ValidationMessage> messages) {
        Collections.sort(messages);
        StringBuilder buf = new StringBuilder();
        for (ValidationMessage message : messages) {
            buf.append(message.getType()).append("\t").append(message.getMessage()).append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    public static List<ValidationMessage> validateCube(String catalogUrl, String cubeName, Connection conn, List<MondrianSchemaValidator> validators) {
        MondrianDef.Schema schema = ValidationHelper.loadSchema(catalogUrl);
        MondrianDef.Cube cube = ValidationHelper.getCubeByName(schema, cubeName);
        MondrianSchemaValidatorManager man = new MondrianSchemaValidatorManager();
        man.setValidators(validators);
        List<ValidationMessage> messages = man.validateCube(schema, cube, conn);
        return messages;
    }

    public static MondrianDef.Schema loadSchema(String catalogUrl) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            logger.debug((Object)("catalogUrl: " + catalogUrl));
            return new MondrianDef.Schema(xmlParser.parse(new URL(catalogUrl)));
        }
        catch (XOMException e) {
            logger.error((Object)"an exception occurred; returning null", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"an exception occurred", (Throwable)e);
        }
        return null;
    }

    public static MondrianDef.Cube getCubeByName(MondrianDef.Schema schema, String name) {
        for (MondrianDef.Cube cube : schema.cubes) {
            if (!cube.name.equals(name)) continue;
            return cube;
        }
        return null;
    }

    public static boolean hasErrors(List<ValidationMessage> messages) {
        for (ValidationMessage message : messages) {
            if (message.getType() != ValidationMessage.Type.ERROR) continue;
            return true;
        }
        return false;
    }
}

